/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.attachment;

import java.text.DecimalFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.upload.FormFile;
import org.kuali.coeus.common.framework.attachment.KcAttachmentService;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.rice.krad.file.FileMeta;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.stereotype.Component;

@Component(value="kcAttachmentService")
public class KcAttachmentServiceImpl
implements KcAttachmentService {
    private static final String DEFAULT_ICON = "default";
    @Resource(name="KcFileMimeTypeIcons")
    private Map<String, String> KcFileMimeTypeIcons;
    private static final String REPLACEMENT_CHARACTER = "_";
    private static final String REGEX_TITLE_FILENAME_PATTERN = "([^0-9a-zA-Z\\.\\-_])";
    private static final String REGEX_TITLE_SPECIAL_CHARACTER_PATTERN = "([^\\x00-\\x7F])";

    @Override
    public String getFileTypeIcon(String type) {
        String iconPath = this.getMimeTypeIcons().get(type);
        if (iconPath == null) {
            return this.KcFileMimeTypeIcons.get(DEFAULT_ICON);
        }
        return iconPath;
    }

    protected Map<String, String> getMimeTypeIcons() {
        return this.KcFileMimeTypeIcons;
    }

    public void setMimeTypeIcons(Map<String, String> mimeTypeIcons) {
        this.KcFileMimeTypeIcons = mimeTypeIcons;
    }

    protected String getDefaultIcon() {
        return this.KcFileMimeTypeIcons.get(DEFAULT_ICON);
    }

    @Override
    public String getInvalidCharacters(String text) {
        Pattern pattern;
        Matcher matcher;
        if (ObjectUtils.isNotNull((Object)text) && (matcher = (pattern = Pattern.compile(REGEX_TITLE_FILENAME_PATTERN)).matcher(text)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public boolean getSpecialCharacter(String text) {
        Pattern pattern;
        Matcher matcher;
        return ObjectUtils.isNotNull((Object)text) && (matcher = (pattern = Pattern.compile(REGEX_TITLE_SPECIAL_CHARACTER_PATTERN)).matcher(text)).find();
    }

    @Override
    public String checkAndReplaceSpecialCharacters(String text) {
        String cleanText = text;
        if (ObjectUtils.isNotNull((Object)text)) {
            Pattern pattern = Pattern.compile(REGEX_TITLE_SPECIAL_CHARACTER_PATTERN);
            Matcher matcher = pattern.matcher(text);
            cleanText = matcher.replaceAll(REPLACEMENT_CHARACTER);
        }
        return cleanText;
    }

    @Override
    public String formatFileSizeString(Long size) {
        DecimalFormat format = new DecimalFormat("0.#");
        if (size >= 1000000000L) {
            return format.format((double)size.longValue() / 1.0E9) + " GB";
        }
        if (size >= 1000000L) {
            return format.format((double)size.longValue() / 1000000.0) + " MB";
        }
        return format.format((double)size.longValue() / 1000.0) + " KB";
    }

    @Override
    public boolean validPDFFile(FileMeta fileInQuestion, ErrorReporter errorReporter, String errorPrefix) {
        if (fileInQuestion.getName() == null) {
            errorReporter.reportError(errorPrefix, "error.attachment.file.required", new String[0]);
        } else if (!"application/pdf".equals(fileInQuestion.getContentType())) {
            errorReporter.reportWarning(errorPrefix, "error.s2s.fileType.invalid", fileInQuestion.getName(), "application/pdf");
        }
        return true;
    }

    @Override
    public boolean doesNewFileExist(FormFile file) {
        return file != null && StringUtils.isNotBlank((CharSequence)file.getFileName());
    }
}

