/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.service.CommitteeServiceBase;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.actions.IacucActionsKeyValuesBase;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

public class IacucProtocolReviewerValuesFinder
extends IacucActionsKeyValuesBase {
    private static final long serialVersionUID = 8186396635481365939L;

    public List<KeyValue> getKeyValues() {
        ProtocolSubmissionBase submission;
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(ValuesFinderUtils.getSelectOption());
        ProtocolBase protocol = this.getProtocol();
        if (protocol != null && (submission = this.getCurrentSubmission(protocol)) != null) {
            List<ProtocolReviewer> reviewers = submission.getProtocolReviewers();
            for (ProtocolReviewer reviewer : reviewers) {
                keyValues.add((KeyValue)new ConcreteKeyValue(reviewer.getProtocolReviewerId().toString(), reviewer.getFullName()));
            }
        }
        return keyValues;
    }

    private ProtocolSubmissionBase getCurrentSubmission(ProtocolBase protocol) {
        for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
            if (!StringUtils.equals((CharSequence)submission.getSubmissionStatusCode(), (CharSequence)"103") && !StringUtils.equals((CharSequence)submission.getSubmissionStatusCode(), (CharSequence)"102")) continue;
            return submission;
        }
        return null;
    }

    private ProtocolBase getProtocol() {
        Object formOrView = this.getFormOrView();
        if (formOrView != null && formOrView instanceof IacucProtocolForm) {
            return ((IacucProtocolForm)formOrView).getProtocolDocument().getProtocol();
        }
        return null;
    }

    @Override
    protected Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook() {
        return IacucCommitteeService.class;
    }
}

