/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.version.sequence.associate.SequenceAssociate;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.protocol.ProtocolBase;

public abstract class ProtocolAssociateBase
extends KcPersistableBusinessObjectBase
implements SequenceAssociate<ProtocolBase> {
    private static final long serialVersionUID = -4180835808867997880L;
    private String protocolNumber;
    private Integer sequenceNumber = 0;
    private Long protocolId;
    private ProtocolBase protocol;

    public ProtocolAssociateBase(ProtocolBase protocol) {
        this.setProtocol(protocol);
    }

    public ProtocolAssociateBase() {
    }

    public Long getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(Long protocolId) {
        this.protocolId = protocolId;
    }

    public ProtocolBase getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolBase protocol) {
        this.protocol = protocol;
        this.initProtocolInfo(protocol);
    }

    private void initProtocolInfo(ProtocolBase aProtocol) {
        this.setProtocolId(aProtocol != null ? aProtocol.getProtocolId() : null);
        this.setProtocolNumber(aProtocol != null ? aProtocol.getProtocolNumber() : null);
        this.setSequenceNumber(aProtocol != null ? aProtocol.getSequenceNumber() : null);
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getProtocolNumber() {
        if ((StringUtils.isBlank((CharSequence)this.protocolNumber) || "0".equals(this.protocolNumber)) && this.protocol != null && StringUtils.isNotBlank((CharSequence)this.protocol.getProtocolNumber())) {
            this.setProtocolNumber(this.protocol.getProtocolNumber());
        }
        return this.protocolNumber;
    }

    public void setProtocolNumber(String protocolNumber) {
        this.protocolNumber = protocolNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.protocolNumber == null ? 0 : this.protocolNumber.hashCode());
        result = 31 * result + (this.sequenceNumber == null ? 0 : this.sequenceNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolAssociateBase other = (ProtocolAssociateBase)obj;
        if (this.protocolNumber == null ? other.protocolNumber != null : !this.protocolNumber.equals(other.protocolNumber)) {
            return false;
        }
        return !(this.sequenceNumber == null ? other.sequenceNumber != null : !this.sequenceNumber.equals(other.sequenceNumber));
    }

    @Override
    public ProtocolBase getSequenceOwner() {
        return this.getProtocol();
    }

    @Override
    public void setSequenceOwner(ProtocolBase newlyVersionedOwner) {
        this.setProtocol(newlyVersionedOwner);
    }

    public final void init(ProtocolBase aProtocol) {
        this.resetPersistenceState();
        this.setProtocol(aProtocol);
        this.postInitHook(aProtocol);
        this.setSequenceNumber(0);
    }

    public void postInitHook(ProtocolBase aProtocol) {
    }
}

