/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch.service.impl;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.MutableDateTime;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.document.attribute.DocumentAttribute;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeContract;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeFactory;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteriaContract;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.docsearch.DocumentSearchCustomizationMediator;
import org.kuali.rice.kew.docsearch.DocumentSearchInternalUtils;
import org.kuali.rice.kew.docsearch.dao.DocumentSearchDAO;
import org.kuali.rice.kew.docsearch.service.DocumentSearchService;
import org.kuali.rice.kew.doctype.SecuritySession;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.exception.WorkflowServiceError;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.framework.document.search.AttributeFields;
import org.kuali.rice.kew.framework.document.search.DocumentSearchCriteriaConfiguration;
import org.kuali.rice.kew.framework.document.search.DocumentSearchResultValue;
import org.kuali.rice.kew.framework.document.search.DocumentSearchResultValues;
import org.kuali.rice.kew.impl.document.search.DocumentSearchGenerator;
import org.kuali.rice.kew.impl.document.search.DocumentSearchGeneratorImpl;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.useroptions.UserOptions;
import org.kuali.rice.kew.useroptions.UserOptionsService;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class DocumentSearchServiceImpl
implements DocumentSearchService {
    private static final Logger LOG = LogManager.getLogger(DocumentSearchServiceImpl.class);
    private static final int MAX_SEARCH_ITEMS = 5;
    private static final String LAST_SEARCH_ORDER_OPTION = "DocSearch.LastSearch.Order";
    private static final String NAMED_SEARCH_ORDER_BASE = "DocSearch.NamedSearch.";
    private static final String LAST_SEARCH_BASE_NAME = "DocSearch.LastSearch.Holding";
    private static final String DOC_SEARCH_CRITERIA_CLASS = "org.kuali.rice.kew.api.document.search.DocumentSearchCriteria";
    private static final String DATA_TYPE_DATE = "datetime";
    private volatile ConfigurationService kualiConfigurationService;
    private DocumentSearchCustomizationMediator documentSearchCustomizationMediator;
    private DocumentSearchDAO docSearchDao;
    private UserOptionsService userOptionsService;
    private static DictionaryValidationService dictionaryValidationService;
    private static DataDictionaryService dataDictionaryService;

    public void setDocumentSearchDAO(DocumentSearchDAO docSearchDao) {
        this.docSearchDao = docSearchDao;
    }

    public void setUserOptionsService(UserOptionsService userOptionsService) {
        this.userOptionsService = userOptionsService;
    }

    public void setDocumentSearchCustomizationMediator(DocumentSearchCustomizationMediator documentSearchCustomizationMediator) {
        this.documentSearchCustomizationMediator = documentSearchCustomizationMediator;
    }

    protected DocumentSearchCustomizationMediator getDocumentSearchCustomizationMediator() {
        return this.documentSearchCustomizationMediator;
    }

    @Override
    public void clearNamedSearches(String principalId) {
        String[] clearListNames;
        for (String clearListName : clearListNames = new String[]{"DocSearch.NamedSearch.%", "DocSearch.LastSearch.Holding%", "DocSearch.LastSearch.Order%"}) {
            List<UserOptions> records = this.userOptionsService.findByUserQualified(principalId, clearListName);
            for (UserOptions userOptions : records) {
                this.userOptionsService.deleteUserOptions(userOptions);
            }
        }
    }

    @Override
    public DocumentSearchCriteria getNamedSearchCriteria(String principalId, String searchName) {
        searchName = ((String)searchName).startsWith(NAMED_SEARCH_ORDER_BASE) ? searchName : NAMED_SEARCH_ORDER_BASE + (String)searchName;
        return this.getSavedSearchCriteria(principalId, (String)searchName);
    }

    @Override
    public DocumentSearchCriteria getSavedSearchCriteria(String principalId, String searchName) {
        UserOptions savedSearch = this.userOptionsService.findByOptionId(searchName, principalId);
        if (savedSearch == null) {
            return null;
        }
        return this.getCriteriaFromSavedSearch(savedSearch);
    }

    protected DocumentSearchCriteria getCriteriaFromSavedSearch(UserOptions savedSearch) {
        String optionValue = savedSearch.getOptionVal();
        try {
            return DocumentSearchInternalUtils.unmarshalDocumentSearchCriteria(optionValue);
        }
        catch (IOException e) {
            LOG.warn("Failed to load saved search for name '" + savedSearch.getOptionId() + "' removing saved search from database.", (Throwable)e);
            this.userOptionsService.deleteUserOptions(savedSearch);
            return DocumentSearchCriteria.Builder.create().build();
        }
    }

    private String getOptionCriteriaField(UserOptions userOption, String fieldName) {
        String value = userOption.getOptionVal();
        if (value != null) {
            String[] fields;
            for (String field : fields = value.split(",,")) {
                if (!field.startsWith(fieldName + "=")) continue;
                return field.substring(field.indexOf(fieldName) + fieldName.length() + 1, field.length());
            }
        }
        return null;
    }

    @Override
    public DocumentSearchResults lookupDocuments(String principalId, DocumentSearchCriteria criteria) {
        return this.lookupDocuments(principalId, criteria, !StringUtils.isBlank((String)criteria.getSaveName()));
    }

    @Override
    public DocumentSearchResults lookupDocuments(String principalId, DocumentSearchCriteria criteria, boolean saveSearch) {
        DocumentSearchGenerator docSearchGenerator = this.getStandardDocumentSearchGenerator();
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByNameCaseInsensitive(criteria.getDocumentTypeName());
        DocumentSearchCriteria.Builder criteriaBuilder = DocumentSearchCriteria.Builder.create((DocumentSearchCriteriaContract)criteria);
        this.validateDocumentSearchCriteria(docSearchGenerator, criteriaBuilder);
        DocumentSearchCriteria builtCriteria = this.applyCriteriaCustomizations(documentType, criteriaBuilder.build());
        if (!CollectionUtils.isEmpty((Collection)criteria.getApplicationDocumentStatuses()) && CollectionUtils.isEmpty((Collection)builtCriteria.getApplicationDocumentStatuses())) {
            DocumentSearchCriteria.Builder patchedCriteria = DocumentSearchCriteria.Builder.create((DocumentSearchCriteriaContract)builtCriteria);
            patchedCriteria.setApplicationDocumentStatuses(criteriaBuilder.getApplicationDocumentStatuses());
            builtCriteria = patchedCriteria.build();
        }
        boolean criteriaModified = !criteria.equals((Object)(builtCriteria = this.applyCriteriaDefaults(builtCriteria)));
        List<RemotableAttributeField> searchFields = this.determineSearchFields(documentType);
        DocumentSearchResults.Builder searchResults = this.docSearchDao.findDocuments(docSearchGenerator, builtCriteria, criteriaModified, searchFields);
        if (documentType != null) {
            DocumentSearchCriteria.Builder docSearchUserIdCriteriaBuilder = DocumentSearchCriteria.Builder.create((DocumentSearchCriteriaContract)builtCriteria);
            docSearchUserIdCriteriaBuilder.setDocSearchUserId(principalId);
            DocumentSearchCriteria docSearchUserIdCriteria = docSearchUserIdCriteriaBuilder.build();
            DocumentSearchResultValues resultValues = this.getDocumentSearchCustomizationMediator().customizeResults(documentType, docSearchUserIdCriteria, searchResults.build());
            if (resultValues != null && CollectionUtils.isNotEmpty((Collection)resultValues.getResultValues())) {
                HashMap<String, DocumentSearchResultValue> resultValueMap = new HashMap<String, DocumentSearchResultValue>();
                for (DocumentSearchResultValue resultValue : resultValues.getResultValues()) {
                    resultValueMap.put(resultValue.getDocumentId(), resultValue);
                }
                for (DocumentSearchResult.Builder result : searchResults.getSearchResults()) {
                    DocumentSearchResultValue value = (DocumentSearchResultValue)resultValueMap.get(result.getDocument().getDocumentId());
                    if (value == null) continue;
                    this.applyResultCustomization(result, value);
                }
            }
        }
        if (StringUtils.isNotBlank((String)principalId) && !searchResults.getSearchResults().isEmpty()) {
            DocumentSearchResults builtResults = searchResults.build();
            Set<String> authorizedDocumentIds = KEWServiceLocator.getDocumentSecurityService().documentSearchResultAuthorized(principalId, builtResults, new SecuritySession(principalId));
            if (CollectionUtils.isNotEmpty(authorizedDocumentIds)) {
                int numFiltered = 0;
                ArrayList<DocumentSearchResult.Builder> finalResults = new ArrayList<DocumentSearchResult.Builder>();
                for (DocumentSearchResult.Builder result : searchResults.getSearchResults()) {
                    if (authorizedDocumentIds.contains(result.getDocument().getDocumentId())) {
                        finalResults.add(result);
                        continue;
                    }
                    ++numFiltered;
                }
                searchResults.setSearchResults(finalResults);
                searchResults.setNumberOfSecurityFilteredResults(numFiltered);
            } else {
                searchResults.setNumberOfSecurityFilteredResults(searchResults.getSearchResults().size());
                searchResults.setSearchResults(Collections.emptyList());
            }
        }
        if (saveSearch) {
            this.saveSearch(principalId, builtCriteria);
        }
        return searchResults.build();
    }

    protected void applyResultCustomization(DocumentSearchResult.Builder result, DocumentSearchResultValue value) {
        LinkedHashMap<String, ArrayList<DocumentAttribute.AbstractBuilder>> customizedAttributeMap = new LinkedHashMap<String, ArrayList<DocumentAttribute.AbstractBuilder>>();
        for (DocumentAttribute customizedAttribute : value.getDocumentAttributes()) {
            ArrayList<DocumentAttribute.AbstractBuilder> attributesForName = (ArrayList<DocumentAttribute.AbstractBuilder>)customizedAttributeMap.get(customizedAttribute.getName());
            if (attributesForName == null) {
                attributesForName = new ArrayList<DocumentAttribute.AbstractBuilder>();
                customizedAttributeMap.put(customizedAttribute.getName(), attributesForName);
            }
            attributesForName.add(DocumentAttributeFactory.loadContractIntoBuilder((DocumentAttributeContract)customizedAttribute));
        }
        HashSet<String> documentAttributeNamesCustomized = new HashSet<String>();
        ArrayList<DocumentAttribute.AbstractBuilder> newDocumentAttributes = new ArrayList<DocumentAttribute.AbstractBuilder>();
        for (DocumentAttribute.AbstractBuilder documentAttribute : result.getDocumentAttributes()) {
            String name = documentAttribute.getName();
            if (customizedAttributeMap.containsKey(name)) {
                if (documentAttributeNamesCustomized.contains(name)) continue;
                documentAttributeNamesCustomized.add(name);
                newDocumentAttributes.addAll((Collection)customizedAttributeMap.get(name));
                customizedAttributeMap.remove(name);
                continue;
            }
            if (documentAttributeNamesCustomized.contains(name)) continue;
            newDocumentAttributes.add(documentAttribute);
        }
        for (List cusotmizedDocumentAttribute : customizedAttributeMap.values()) {
            newDocumentAttributes.addAll(cusotmizedDocumentAttribute);
        }
        result.setDocumentAttributes(newDocumentAttributes);
    }

    protected DocumentSearchCriteria applyCriteriaCustomizations(DocumentType documentType, DocumentSearchCriteria criteria) {
        if (documentType == null) {
            return criteria;
        }
        DocumentSearchCriteria customizedCriteria = this.getDocumentSearchCustomizationMediator().customizeCriteria(documentType, criteria);
        if (customizedCriteria != null) {
            return customizedCriteria;
        }
        return criteria;
    }

    protected DocumentSearchCriteria applyCriteriaDefaults(DocumentSearchCriteria criteria) {
        DocumentSearchCriteria.Builder comparisonCriteria = this.createEmptyComparisonCriteria(criteria);
        boolean isCriteriaEmpty = criteria.equals((Object)comparisonCriteria.build());
        boolean isTitleOnly = false;
        boolean isDocTypeOnly = false;
        if (!isCriteriaEmpty) {
            comparisonCriteria.setTitle(criteria.getTitle());
            isTitleOnly = criteria.equals((Object)comparisonCriteria.build());
        }
        if (!isCriteriaEmpty && !isTitleOnly) {
            comparisonCriteria = this.createEmptyComparisonCriteria(criteria);
            comparisonCriteria.setDocumentTypeName(criteria.getDocumentTypeName());
            isDocTypeOnly = criteria.equals((Object)comparisonCriteria.build());
        }
        if (isCriteriaEmpty || isTitleOnly || isDocTypeOnly) {
            DocumentSearchCriteria.Builder criteriaBuilder = DocumentSearchCriteria.Builder.create((DocumentSearchCriteriaContract)criteria);
            Integer defaultCreateDateDaysAgoValue = null;
            if (isCriteriaEmpty || isDocTypeOnly) {
                defaultCreateDateDaysAgoValue = KewApiConstants.DOCUMENT_SEARCH_NO_CRITERIA_CREATE_DATE_DAYS_AGO;
            } else if (isTitleOnly) {
                defaultCreateDateDaysAgoValue = KewApiConstants.DOCUMENT_SEARCH_DOC_TITLE_CREATE_DATE_DAYS_AGO;
            }
            if (defaultCreateDateDaysAgoValue != null) {
                MutableDateTime mutableDateTime = new MutableDateTime();
                mutableDateTime.addDays(defaultCreateDateDaysAgoValue.intValue());
                criteriaBuilder.setDateCreatedFrom(mutableDateTime.toDateTime());
            }
            criteria = criteriaBuilder.build();
        }
        return criteria;
    }

    protected DocumentSearchCriteria.Builder createEmptyComparisonCriteria(DocumentSearchCriteria criteria) {
        DocumentSearchCriteria.Builder builder = DocumentSearchCriteria.Builder.create();
        builder.setSaveName(criteria.getSaveName());
        builder.setStartAtIndex(criteria.getStartAtIndex());
        builder.setMaxResults(criteria.getMaxResults());
        builder.setIsAdvancedSearch(criteria.getIsAdvancedSearch());
        builder.setSearchOptions(criteria.getSearchOptions());
        return builder;
    }

    protected List<RemotableAttributeField> determineSearchFields(DocumentType documentType) {
        List attributeFields;
        DocumentSearchCriteriaConfiguration searchConfiguration;
        ArrayList<RemotableAttributeField> searchFields = new ArrayList<RemotableAttributeField>();
        if (documentType != null && (searchConfiguration = this.getDocumentSearchCustomizationMediator().getDocumentSearchCriteriaConfiguration(documentType)) != null && (attributeFields = searchConfiguration.getSearchAttributeFields()) != null) {
            for (AttributeFields fields : attributeFields) {
                searchFields.addAll(fields.getRemotableAttributeFields());
            }
        }
        return searchFields;
    }

    @Override
    public DocumentSearchGenerator getStandardDocumentSearchGenerator() {
        String searchGeneratorClass = ConfigContext.getCurrentContextConfig().getProperty("documentSearch.generator.class.name");
        if (searchGeneratorClass == null) {
            return new DocumentSearchGeneratorImpl();
        }
        return (DocumentSearchGenerator)GlobalResourceLoader.getObject((ObjectDefinition)new ObjectDefinition(searchGeneratorClass));
    }

    @Override
    public void validateDocumentSearchCriteria(DocumentSearchGenerator docSearchGenerator, DocumentSearchCriteria.Builder criteria) {
        List<WorkflowServiceError> errors = this.validateWorkflowDocumentSearchCriteria(criteria);
        List<RemotableAttributeError> searchAttributeErrors = docSearchGenerator.validateSearchableAttributes(criteria);
        if (!CollectionUtils.isEmpty(searchAttributeErrors)) {
            for (RemotableAttributeError searchAttributeError : searchAttributeErrors) {
                for (String errorMessage : searchAttributeError.getErrors()) {
                    WorkflowServiceErrorImpl error = new WorkflowServiceErrorImpl(errorMessage, "error.custom", errorMessage);
                    errors.add(error);
                }
            }
        }
        if (!errors.isEmpty() || !GlobalVariables.getMessageMap().hasNoErrors()) {
            throw new WorkflowServiceErrorException("Document Search Validation Errors", errors);
        }
    }

    protected List<WorkflowServiceError> validateWorkflowDocumentSearchCriteria(DocumentSearchCriteria.Builder criteria) {
        ArrayList<WorkflowServiceError> errors = new ArrayList<WorkflowServiceError>();
        criteria.setApproverPrincipalName(this.trimCriteriaValue(criteria.getApproverPrincipalName()));
        criteria.setViewerPrincipalName(this.trimCriteriaValue(criteria.getViewerPrincipalName()));
        criteria.setInitiatorPrincipalName(this.trimCriteriaValue(criteria.getInitiatorPrincipalName()));
        this.validateGroupCriteria(criteria, errors);
        criteria.setDocumentId(criteria.getDocumentId());
        boolean compareDatePairs = true;
        if (criteria.getDateCreatedFrom() == null) {
            compareDatePairs = false;
        } else if (!this.validateDate("dateCreatedFrom", criteria.getDateCreatedFrom().toString(), "dateCreatedFrom")) {
            compareDatePairs = false;
        } else {
            criteria.setDateCreatedFrom(criteria.getDateCreatedFrom());
        }
        if (criteria.getDateCreatedTo() == null) {
            compareDatePairs = false;
        } else if (!this.validateDate("dateCreatedTo", criteria.getDateCreatedTo().toString(), "dateCreatedTo")) {
            compareDatePairs = false;
        } else {
            criteria.setDateCreatedTo(criteria.getDateCreatedTo());
        }
        if (compareDatePairs && !this.checkDateRanges(new SimpleDateFormat("MM/dd/yyyy").format(criteria.getDateCreatedFrom().toDate()), new SimpleDateFormat("MM/dd/yyyy").format(criteria.getDateCreatedTo().toDate()))) {
            errors.add(new WorkflowServiceErrorImpl("The Date Created From (Date Created) must not have a \"From\" date that occurs after the \"To\" date.", "docsearch.DocumentSearchService.dateCreatedRange"));
        }
        compareDatePairs = true;
        if (criteria.getDateApprovedFrom() == null) {
            compareDatePairs = false;
        } else if (!this.validateDate("dateApprovedFrom", criteria.getDateApprovedFrom().toString(), "dateApprovedFrom")) {
            compareDatePairs = false;
        } else {
            criteria.setDateApprovedFrom(criteria.getDateApprovedFrom());
        }
        if (criteria.getDateApprovedTo() == null) {
            compareDatePairs = false;
        } else if (!this.validateDate("dateApprovedTo", criteria.getDateApprovedTo().toString(), "dateApprovedTo")) {
            compareDatePairs = false;
        } else {
            criteria.setDateApprovedTo(criteria.getDateApprovedTo());
        }
        if (compareDatePairs && !this.checkDateRanges(new SimpleDateFormat("MM/dd/yyyy").format(criteria.getDateApprovedFrom().toDate()), new SimpleDateFormat("MM/dd/yyyy").format(criteria.getDateApprovedTo().toDate()))) {
            errors.add(new WorkflowServiceErrorImpl("The Date Approved From (Date Approved) must not have a \"From\" date that occurs after the \"To\" date.", "docsearch.DocumentSearchService.dateApprovedRange"));
        }
        compareDatePairs = true;
        if (criteria.getDateFinalizedFrom() == null) {
            compareDatePairs = false;
        } else if (!this.validateDate("dateFinalizedFrom", criteria.getDateFinalizedFrom().toString(), "dateFinalizedFrom")) {
            compareDatePairs = false;
        } else {
            criteria.setDateFinalizedFrom(criteria.getDateFinalizedFrom());
        }
        if (criteria.getDateFinalizedTo() == null) {
            compareDatePairs = false;
        } else if (!this.validateDate("dateFinalizedTo", criteria.getDateFinalizedTo().toString(), "dateFinalizedTo")) {
            compareDatePairs = false;
        } else {
            criteria.setDateFinalizedTo(criteria.getDateFinalizedTo());
        }
        if (compareDatePairs && !this.checkDateRanges(new SimpleDateFormat("MM/dd/yyyy").format(criteria.getDateFinalizedFrom().toDate()), new SimpleDateFormat("MM/dd/yyyy").format(criteria.getDateFinalizedTo().toDate()))) {
            errors.add(new WorkflowServiceErrorImpl("The Date Finalized From (Date Finalized) must not have a \"From\" date that occurs after the \"To\" date.", "docsearch.DocumentSearchService.dateFinalizedRange"));
        }
        compareDatePairs = true;
        if (criteria.getDateLastModifiedFrom() == null) {
            compareDatePairs = false;
        } else if (!this.validateDate("dateLastModifiedFrom", criteria.getDateLastModifiedFrom().toString(), "dateLastModifiedFrom")) {
            compareDatePairs = false;
        } else {
            criteria.setDateLastModifiedFrom(criteria.getDateLastModifiedFrom());
        }
        if (criteria.getDateLastModifiedTo() == null) {
            compareDatePairs = false;
        } else if (!this.validateDate("dateLastModifiedTo", criteria.getDateLastModifiedTo().toString(), "dateLastModifiedTo")) {
            compareDatePairs = false;
        } else {
            criteria.setDateLastModifiedTo(criteria.getDateLastModifiedTo());
        }
        if (compareDatePairs && !this.checkDateRanges(new SimpleDateFormat("MM/dd/yyyy").format(criteria.getDateLastModifiedFrom().toDate()), new SimpleDateFormat("MM/dd/yyyy").format(criteria.getDateLastModifiedTo().toDate()))) {
            errors.add(new WorkflowServiceErrorImpl("The Date Last Modified From (Date Last Modified) must not have a \"From\" date that occurs after the \"To\" date.", "docsearch.DocumentSearchService.dateLastModifiedRange"));
        }
        return errors;
    }

    private boolean validateDate(String dateFieldName, String dateFieldValue, String dateFieldErrorKey) {
        int oldErrorCount = GlobalVariables.getMessageMap().getErrorCount();
        DocumentSearchServiceImpl.getDictionaryValidationService().validateAttributeFormat(DOC_SEARCH_CRITERIA_CLASS, dateFieldName, dateFieldValue, DATA_TYPE_DATE, dateFieldErrorKey);
        return GlobalVariables.getMessageMap().getErrorCount() <= oldErrorCount;
    }

    public static DictionaryValidationService getDictionaryValidationService() {
        if (dictionaryValidationService == null) {
            dictionaryValidationService = KNSServiceLocator.getKNSDictionaryValidationService();
        }
        return dictionaryValidationService;
    }

    public static DataDictionaryService getDataDictionaryService() {
        if (dataDictionaryService == null) {
            dataDictionaryService = KNSServiceLocator.getDataDictionaryService();
        }
        return dataDictionaryService;
    }

    private boolean checkDateRanges(String fromDate, String toDate) {
        return Utilities.checkDateRanges(fromDate, toDate);
    }

    private String trimCriteriaValue(String criteriaValue) {
        if (StringUtils.isNotBlank((String)criteriaValue)) {
            criteriaValue = criteriaValue.trim();
        }
        if (StringUtils.isBlank((String)criteriaValue)) {
            return null;
        }
        return criteriaValue;
    }

    private void validateGroupCriteria(DocumentSearchCriteria.Builder criteria, List<WorkflowServiceError> errors) {
        if (StringUtils.isNotBlank((String)criteria.getGroupViewerId())) {
            Group group = KimApiServiceLocator.getGroupService().getGroup(criteria.getGroupViewerId());
            if (group == null) {
                errors.add(new WorkflowServiceErrorImpl("Workgroup Viewer Name is not a workgroup", "docsearch.DocumentSearchService.workgroup.viewer"));
            }
        } else {
            criteria.setGroupViewerId(null);
        }
    }

    @Override
    public List<KeyValue> getNamedSearches(String principalId) {
        ArrayList<UserOptions> namedSearches = new ArrayList<UserOptions>(this.userOptionsService.findByUserQualified(principalId, "DocSearch.NamedSearch.%"));
        ArrayList<KeyValue> sortedNamedSearches = new ArrayList<KeyValue>(0);
        if (!namedSearches.isEmpty()) {
            Collections.sort(namedSearches);
            for (UserOptions namedSearch : namedSearches) {
                ConcreteKeyValue keyValue = new ConcreteKeyValue(namedSearch.getOptionId(), namedSearch.getOptionId().substring(NAMED_SEARCH_ORDER_BASE.length(), namedSearch.getOptionId().length()));
                sortedNamedSearches.add((KeyValue)keyValue);
            }
        }
        return sortedNamedSearches;
    }

    @Override
    public List<KeyValue> getMostRecentSearches(String principalId) {
        UserOptions order = this.userOptionsService.findByOptionId(LAST_SEARCH_ORDER_OPTION, principalId);
        ArrayList<KeyValue> sortedMostRecentSearches = new ArrayList<KeyValue>();
        if (order != null && order.getOptionVal() != null && !"".equals(order.getOptionVal())) {
            String[] ordered;
            List<UserOptions> mostRecentSearches = this.userOptionsService.findByUserQualified(principalId, "DocSearch.LastSearch.Holding%");
            for (String anOrdered : ordered = order.getOptionVal().split(",")) {
                UserOptions matchingOption = null;
                for (UserOptions option : mostRecentSearches) {
                    if (!anOrdered.equals(option.getOptionId())) continue;
                    matchingOption = option;
                    break;
                }
                if (matchingOption == null) continue;
                DocumentSearchCriteria matchingCriteria = this.getCriteriaFromSavedSearch(matchingOption);
                sortedMostRecentSearches.add((KeyValue)new ConcreteKeyValue(anOrdered, this.getSavedSearchAbbreviatedString(matchingCriteria)));
            }
        }
        return sortedMostRecentSearches;
    }

    @Override
    public DocumentSearchCriteria clearCriteria(DocumentType documentType, DocumentSearchCriteria criteria) {
        DocumentSearchCriteria clearedCriteria = this.getDocumentSearchCustomizationMediator().customizeClearCriteria(documentType, criteria);
        if (clearedCriteria == null) {
            clearedCriteria = this.getStandardDocumentSearchGenerator().clearSearch(criteria);
        }
        return clearedCriteria;
    }

    protected String getSavedSearchAbbreviatedString(DocumentSearchCriteria criteria) {
        LinkedHashMap<String, String> abbreviatedStringMap = new LinkedHashMap<String, String>();
        this.addAbbreviatedString(abbreviatedStringMap, "Doc Type", criteria.getDocumentTypeName());
        this.addAbbreviatedString(abbreviatedStringMap, "Initiator", criteria.getInitiatorPrincipalName());
        this.addAbbreviatedString(abbreviatedStringMap, "Doc Id", criteria.getDocumentId());
        this.addAbbreviatedRangeString(abbreviatedStringMap, "Created", criteria.getDateCreatedFrom(), criteria.getDateCreatedTo());
        this.addAbbreviatedString(abbreviatedStringMap, "Title", criteria.getTitle());
        this.addAbbreviatedString(abbreviatedStringMap, "App Doc Id", criteria.getApplicationDocumentId());
        this.addAbbreviatedRangeString(abbreviatedStringMap, "Approved", criteria.getDateApprovedFrom(), criteria.getDateApprovedTo());
        this.addAbbreviatedRangeString(abbreviatedStringMap, "Modified", criteria.getDateLastModifiedFrom(), criteria.getDateLastModifiedTo());
        this.addAbbreviatedRangeString(abbreviatedStringMap, "Finalized", criteria.getDateFinalizedFrom(), criteria.getDateFinalizedTo());
        this.addAbbreviatedRangeString(abbreviatedStringMap, "App Doc Status Changed", criteria.getDateApplicationDocumentStatusChangedFrom(), criteria.getDateApplicationDocumentStatusChangedTo());
        this.addAbbreviatedString(abbreviatedStringMap, "Approver", criteria.getApproverPrincipalName());
        this.addAbbreviatedString(abbreviatedStringMap, "Viewer", criteria.getViewerPrincipalName());
        this.addAbbreviatedString(abbreviatedStringMap, "Group Viewer", criteria.getGroupViewerId());
        this.addAbbreviatedString(abbreviatedStringMap, "Node", criteria.getRouteNodeName());
        this.addAbbreviatedMultiValuedString(abbreviatedStringMap, "Status", criteria.getDocumentStatuses());
        this.addAbbreviatedMultiValuedString(abbreviatedStringMap, "Category", criteria.getDocumentStatusCategories());
        for (String documentAttributeName : criteria.getDocumentAttributeValues().keySet()) {
            this.addAbbreviatedMultiValuedString(abbreviatedStringMap, documentAttributeName, (Collection)criteria.getDocumentAttributeValues().get(documentAttributeName));
        }
        StringBuilder stringBuilder = new StringBuilder();
        int iteration = 0;
        for (String label : abbreviatedStringMap.keySet()) {
            stringBuilder.append(label).append("=").append((String)abbreviatedStringMap.get(label));
            if (iteration >= abbreviatedStringMap.keySet().size()) continue;
            stringBuilder.append("; ");
        }
        return stringBuilder.toString();
    }

    protected void addAbbreviatedString(Map<String, String> abbreviatedStringMap, String label, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            abbreviatedStringMap.put(label, value);
        }
    }

    protected void addAbbreviatedMultiValuedString(Map<String, String> abbreviatedStringMap, String label, Collection<? extends Object> values) {
        if (CollectionUtils.isNotEmpty(values)) {
            ArrayList<String> stringValues = new ArrayList<String>();
            for (Object object : values) {
                stringValues.add(object.toString());
            }
            abbreviatedStringMap.put(label, StringUtils.join(stringValues, (String)","));
        }
    }

    protected void addAbbreviatedRangeString(Map<String, String> abbreviatedStringMap, String label, DateTime dateFrom, DateTime dateTo) {
        if (dateFrom != null || dateTo != null) {
            StringBuilder abbreviatedString = new StringBuilder();
            if (dateFrom != null) {
                abbreviatedString.append(CoreApiServiceLocator.getDateTimeService().toDateString(dateFrom.toDate()));
            }
            abbreviatedString.append("..");
            if (dateTo != null) {
                abbreviatedString.append(CoreApiServiceLocator.getDateTimeService().toDateString(dateTo.toDate()));
            }
            abbreviatedStringMap.put(label, abbreviatedString.toString());
        }
    }

    private void saveSearch(String principalId, DocumentSearchCriteria criteria) {
        if (StringUtils.isBlank((String)principalId)) {
            return;
        }
        try {
            String savedSearchString = DocumentSearchInternalUtils.marshalDocumentSearchCriteria(criteria);
            if (StringUtils.isNotBlank((String)criteria.getSaveName())) {
                this.userOptionsService.save(principalId, NAMED_SEARCH_ORDER_BASE + criteria.getSaveName(), savedSearchString);
            } else {
                UserOptions searchOrder = this.userOptionsService.findByOptionId(LAST_SEARCH_ORDER_OPTION, principalId);
                if (searchOrder == null) {
                    this.userOptionsService.save(principalId, "DocSearch.LastSearch.Holding0", savedSearchString);
                    this.userOptionsService.save(principalId, LAST_SEARCH_ORDER_OPTION, "DocSearch.LastSearch.Holding0");
                } else {
                    String[] currentOrder = searchOrder.getOptionVal().split(",");
                    if (currentOrder.length == 5) {
                        String searchName = currentOrder[currentOrder.length - 1];
                        String[] newOrder = new String[5];
                        newOrder[0] = searchName;
                        for (int i = 0; i < currentOrder.length - 1; ++i) {
                            newOrder[i + 1] = currentOrder[i];
                        }
                        String newSearchOrder = this.rejoinWithCommas(newOrder);
                        this.userOptionsService.save(principalId, searchName, savedSearchString);
                        this.userOptionsService.save(principalId, LAST_SEARCH_ORDER_OPTION, newSearchOrder);
                    } else {
                        int absMax = 0;
                        for (String aCurrentOrder : currentOrder) {
                            int current = new Integer(aCurrentOrder.substring(LAST_SEARCH_BASE_NAME.length(), aCurrentOrder.length()));
                            if (current <= absMax) continue;
                            absMax = current;
                        }
                        String searchName = LAST_SEARCH_BASE_NAME + ++absMax;
                        String[] newOrder = new String[currentOrder.length + 1];
                        newOrder[0] = searchName;
                        for (int i = 0; i < currentOrder.length; ++i) {
                            newOrder[i + 1] = currentOrder[i];
                        }
                        String newSearchOrder = this.rejoinWithCommas(newOrder);
                        this.userOptionsService.save(principalId, searchName, savedSearchString);
                        this.userOptionsService.save(principalId, LAST_SEARCH_ORDER_OPTION, newSearchOrder);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Unable to save search due to exception", (Throwable)e);
        }
    }

    private String rejoinWithCommas(String[] newOrder) {
        StringBuilder newSearchOrder = new StringBuilder("");
        for (String aNewOrder : newOrder) {
            if (newSearchOrder.length() != 0) {
                newSearchOrder.append(",");
            }
            newSearchOrder.append(aNewOrder);
        }
        return newSearchOrder.toString();
    }

    public ConfigurationService getKualiConfigurationService() {
        if (this.kualiConfigurationService == null) {
            this.kualiConfigurationService = CoreApiServiceLocator.getKualiConfigurationService();
        }
        return this.kualiConfigurationService;
    }

    @Override
    public int getMaxResultCap(DocumentSearchCriteria criteria) {
        return this.docSearchDao.getMaxResultCap(criteria);
    }

    @Override
    public int getFetchMoreIterationLimit() {
        return this.docSearchDao.getFetchMoreIterationLimit();
    }
}

