/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.web;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.core.framework.persistence.jdbc.sql.SQLUtils;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.kew.exception.WorkflowServiceError;
import org.kuali.rice.kew.rule.KeyValueId;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.WorkflowRuleAttributeRows;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.service.RuleDelegationService;
import org.kuali.rice.kew.rule.service.RuleTemplateService;
import org.kuali.rice.kew.rule.web.WebRuleResponsibility;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;

public class WebRuleBaseValues
extends RuleBaseValues {
    private static final long serialVersionUID = 5938997470219200474L;
    private static final int TO_DATE_UPPER_LIMIT = 2100;
    private List rows = new ArrayList();
    private List fields = new ArrayList();
    private List roles = new ArrayList();
    private String fromDateString;
    private String toDateString;
    private String ruleTemplateName;
    private boolean hasExtensionValueErrors = false;

    public WebRuleBaseValues() {
    }

    public WebRuleBaseValues(RuleBaseValues rule) throws Exception {
        this.edit(rule);
    }

    private void loadFields() {
        RuleTemplateBo ruleTemplate;
        this.fields.clear();
        if (this.getRuleTemplateId() != null && (ruleTemplate = this.getRuleTemplateService().findByRuleTemplateId(this.getRuleTemplateId())) != null) {
            List<RuleTemplateAttributeBo> ruleTemplateAttributes = ruleTemplate.getActiveRuleTemplateAttributes();
            Collections.sort(ruleTemplateAttributes);
            for (RuleTemplateAttributeBo ruleTemplateAttribute : ruleTemplateAttributes) {
                if (!ruleTemplateAttribute.isWorkflowAttribute()) continue;
                WorkflowRuleAttributeRows workflowRuleAttributeRows = KEWServiceLocator.getWorkflowRuleAttributeMediator().getRuleRows(null, ruleTemplateAttribute);
                for (Row row : workflowRuleAttributeRows.getRows()) {
                    for (Field field : row.getFields()) {
                        String fieldValue = "";
                        RuleExtensionValue extensionValue = this.getRuleExtensionValue(ruleTemplateAttribute.getId(), field.getPropertyName());
                        fieldValue = extensionValue != null ? extensionValue.getValue() : field.getPropertyValue();
                        this.fields.add(new KeyValueId(field.getPropertyName(), fieldValue, ruleTemplateAttribute.getId()));
                    }
                }
            }
        }
    }

    private void loadWebValues() {
        this.loadRows();
        this.loadDates();
        this.loadRuleTemplateName();
    }

    private void loadRows() {
        RuleTemplateBo ruleTemplate;
        this.getRoles().clear();
        if (this.getRuleTemplateId() != null && (ruleTemplate = this.getRuleTemplateService().findByRuleTemplateId(this.getRuleTemplateId())) != null) {
            this.setRuleTemplateName(ruleTemplate.getName());
            List<RuleTemplateAttributeBo> ruleTemplateAttributes = ruleTemplate.getActiveRuleTemplateAttributes();
            Collections.sort(ruleTemplateAttributes);
            ArrayList<Row> rows = new ArrayList<Row>();
            for (RuleTemplateAttributeBo ruleTemplateAttribute : ruleTemplateAttributes) {
                if (!ruleTemplateAttribute.isWorkflowAttribute()) continue;
                WorkflowRuleAttributeRows workflowRuleAttributeRows = KEWServiceLocator.getWorkflowRuleAttributeMediator().getRuleRows((Map<String, String>)this.getFieldMap(ruleTemplateAttribute.getId()), ruleTemplateAttribute);
                rows.addAll(workflowRuleAttributeRows.getRows());
                this.getRoles().addAll(KEWServiceLocator.getWorkflowRuleAttributeMediator().getRoleNames(ruleTemplateAttribute));
            }
            this.setRows(rows);
        }
    }

    private void loadDates() {
        if (this.getFromDateString() != null) {
            this.setFromDateString(RiceConstants.getDefaultDateFormat().format(this.getFromDateValue()));
        }
        if (this.getToDateString() != null) {
            this.setToDateString(RiceConstants.getDefaultDateFormat().format(this.getToDateValue()));
        }
    }

    private void loadRuleTemplateName() {
        RuleTemplateBo ruleTemplate;
        if (StringUtils.isEmpty((String)this.getRuleTemplateName()) && this.getRuleTemplateId() != null && (ruleTemplate = this.getRuleTemplateService().findByRuleTemplateId(this.getRuleTemplateId())) != null) {
            this.setRuleTemplateName(ruleTemplate.getName());
        }
    }

    public List getFields() {
        return this.fields;
    }

    public void setFields(List fields) {
        this.fields = fields;
    }

    public KeyValueId getField(int index) {
        while (this.getFields().size() <= index) {
            KeyValueId field = new KeyValueId();
            this.getFields().add(field);
        }
        return (KeyValueId)this.getFields().get(index);
    }

    @Override
    public String getFromDateString() {
        return this.fromDateString;
    }

    public void setFromDateString(String fromDateString) {
        this.fromDateString = fromDateString;
    }

    public List<RoleName> getRoles() {
        return this.roles;
    }

    public void setRoles(List<RoleName> roles) {
        this.roles = roles;
    }

    public List<RoleName> getRows() {
        return this.rows;
    }

    public void setRows(List ruleTemplateAttributes) {
        this.rows = ruleTemplateAttributes;
    }

    @Override
    public String getToDateString() {
        return this.toDateString;
    }

    public void setToDateString(String toDateString) {
        this.toDateString = toDateString;
    }

    @Override
    public String getRuleTemplateName() {
        return this.ruleTemplateName;
    }

    public void setRuleTemplateName(String ruleTemplateName) {
        this.ruleTemplateName = ruleTemplateName;
    }

    public boolean isHasExtensionValueErrors() {
        return this.hasExtensionValueErrors;
    }

    public void setHasExtensionValueErrors(boolean hasRuleExtensionValueErrors) {
        this.hasExtensionValueErrors = hasRuleExtensionValueErrors;
    }

    public void edit(RuleBaseValues rule) throws Exception {
        this.load(rule);
        this.initialize();
    }

    public void load(RuleBaseValues rule) throws Exception {
        PropertyUtils.copyProperties((Object)((Object)this), (Object)((Object)rule));
        this.injectWebMembers();
    }

    public void initialize() throws Exception {
        this.loadFields();
        for (RuleResponsibilityBo element : this.getRuleResponsibilities()) {
            WebRuleResponsibility responsibility = (WebRuleResponsibility)element;
            responsibility.initialize();
        }
        this.establishRequiredState();
    }

    private void injectWebMembers() throws Exception {
        List<RuleResponsibilityBo> currentResponsibilities = this.getRuleResponsibilities();
        this.setRuleResponsibilities(new ArrayList<RuleResponsibilityBo>());
        for (RuleResponsibilityBo responsibility : currentResponsibilities) {
            WebRuleResponsibility webResponsibility = this.createNewRuleResponsibility();
            webResponsibility.load(responsibility);
        }
    }

    public void establishRequiredState() throws Exception {
        this.loadWebValues();
        if (this.getRuleResponsibilities().isEmpty()) {
            this.createNewRuleResponsibility();
        }
        for (RuleResponsibilityBo element : this.getRuleResponsibilities()) {
            WebRuleResponsibility responsibility = (WebRuleResponsibility)element;
            responsibility.establishRequiredState();
        }
    }

    @Override
    public RuleResponsibilityBo getResponsibility(int index) {
        while (this.getRuleResponsibilities().size() <= index) {
            this.createNewRuleResponsibility();
        }
        return this.getRuleResponsibilities().get(index);
    }

    public int getResponsibilitiesSize() {
        return this.getRuleResponsibilities().size();
    }

    public WebRuleResponsibility createNewRuleResponsibility() {
        WebRuleResponsibility responsibility = new WebRuleResponsibility();
        responsibility.setRuleBaseValues(this);
        this.addRuleResponsibility(responsibility);
        return responsibility;
    }

    public Map getFieldMap(String ruleTemplateAttributeId) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (KeyValueId field : this.getFields()) {
            if (!ruleTemplateAttributeId.equals(field.getId())) continue;
            fieldMap.put(field.getKey(), field.getValue());
        }
        return fieldMap;
    }

    public void populatePreviousRuleIds() {
        if (this.getPreviousRuleId() == null) {
            this.setPreviousRuleId(this.getId());
        }
        for (RuleResponsibilityBo element : this.getRuleResponsibilities()) {
            WebRuleResponsibility responsibility = (WebRuleResponsibility)element;
            responsibility.populatePreviousRuleIds();
        }
    }

    public void materialize() {
        if (this.getRuleTemplate() == null && this.getRuleTemplateId() != null) {
            this.setRuleTemplate(this.getRuleTemplateService().findByRuleTemplateId(this.getRuleTemplateId()));
        }
    }

    private void throttleDates() {
        if (this.getToDateValue() != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.getToDateValue());
            if (calendar.get(1) > 2100) {
                calendar.set(1, 2100);
                this.setToDateValue(new Timestamp(calendar.getTimeInMillis()));
                this.setToDateString(new SimpleDateFormat("MM/dd/yyyy").format(this.getToDateValue()));
            }
        }
    }

    private void saveServiceErrors(String errorKey, Collection srvErrors, ActionErrors errors) {
        for (WorkflowServiceError error : srvErrors) {
            if (error.getArg1() == null && error.getArg2() == null) {
                errors.add(errorKey, new ActionMessage(error.getKey()));
                continue;
            }
            if (error.getArg1() != null && error.getArg2() == null) {
                errors.add(errorKey, new ActionMessage(error.getKey(), (Object)error.getArg1()));
                continue;
            }
            errors.add(errorKey, new ActionMessage(error.getKey(), (Object)error.getArg1(), (Object)error.getArg2()));
        }
    }

    private Timestamp decodeTimestamp(String dateValue) throws ParseException {
        if (StringUtils.isEmpty((String)dateValue)) {
            return null;
        }
        String convertedDate = SQLUtils.getEntryFormattedDate((String)dateValue);
        if (convertedDate == null) {
            throw new ParseException("Date entered as '" + dateValue + "' is in invalid format", 0);
        }
        Date date = RiceConstants.getDefaultDateFormat().parse(convertedDate);
        return new Timestamp(date.getTime());
    }

    private RuleTemplateService getRuleTemplateService() {
        return (RuleTemplateService)KEWServiceLocator.getService("enRuleTemplateService");
    }

    public Map getActionRequestCodes() {
        RuleTemplateBo ruleTemplate;
        HashMap actionRequestCodes = new HashMap();
        actionRequestCodes.putAll(CodeTranslator.arLabels);
        if (this.getRuleTemplateId() != null && (ruleTemplate = this.getRuleTemplateService().findByRuleTemplateId(this.getRuleTemplateId())) != null) {
            if (ruleTemplate.getAcknowledge() != null && "false".equals(ruleTemplate.getAcknowledge().getValue())) {
                actionRequestCodes.remove("K");
            }
            if (ruleTemplate.getComplete() != null && "false".equals(ruleTemplate.getComplete().getValue())) {
                actionRequestCodes.remove("C");
            }
            if (ruleTemplate.getApprove() != null && "false".equals(ruleTemplate.getApprove().getValue())) {
                actionRequestCodes.remove("A");
            }
            if (ruleTemplate.getFyi() != null && "false".equals(ruleTemplate.getFyi().getValue())) {
                actionRequestCodes.remove("F");
            }
        }
        return actionRequestCodes;
    }

    public RuleDelegationBo getRuleDelegation() {
        if (this.getDelegateRule().booleanValue()) {
            List<RuleDelegationBo> ruleDelegations = this.getRuleDelegationService().findByDelegateRuleId(this.getId());
            RuleDelegationBo currentRuleDelegation = ruleDelegations.get(0);
            RuleBaseValues mostRecentRule = currentRuleDelegation.getRuleResponsibility().getRuleBaseValues();
            for (RuleDelegationBo ruleDelegation : ruleDelegations) {
                RuleBaseValues parentRule = ruleDelegation.getRuleResponsibility().getRuleBaseValues();
                if (!parentRule.getActivationDate().after(mostRecentRule.getActivationDate())) continue;
                mostRecentRule = ruleDelegation.getRuleResponsibility().getRuleBaseValues();
                currentRuleDelegation = ruleDelegation;
            }
            return currentRuleDelegation;
        }
        return null;
    }

    public String getParentRuleId() {
        if (this.getDelegateRule().booleanValue()) {
            List<RuleDelegationBo> ruleDelegations = this.getRuleDelegationService().findByDelegateRuleId(this.getId());
            RuleDelegationBo currentRuleDelegation = ruleDelegations.get(0);
            RuleBaseValues mostRecentRule = currentRuleDelegation.getRuleResponsibility().getRuleBaseValues();
            for (RuleDelegationBo ruleDelegation : ruleDelegations) {
                RuleBaseValues parentRule = ruleDelegation.getRuleResponsibility().getRuleBaseValues();
                if (!parentRule.getActivationDate().after(mostRecentRule.getActivationDate())) continue;
                mostRecentRule = ruleDelegation.getRuleResponsibility().getRuleBaseValues();
            }
            return mostRecentRule.getId();
        }
        return null;
    }

    private RuleDelegationService getRuleDelegationService() {
        return (RuleDelegationService)KEWServiceLocator.getService("enRuleDelegationService");
    }
}

