/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.onlinereview.authorization;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.KcTransactionalDocumentAuthorizerBase;
import org.kuali.coeus.common.framework.auth.task.ApplicationTask;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.IacucProtocolOnlineReviewDocument;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.iacuc.committee.meeting.IacucCommitteeScheduleMinute;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeScheduleService;
import org.kuali.kra.iacuc.onlinereview.authorization.IacucProtocolOnlineReviewTask;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolOnlineReviewDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    private static final long serialVersionUID = -5887926854171754314L;
    public static final String CAN_EDIT_REVIEW_TYPE = "canEditReviewType";
    public static final String CAN_EDIT_DETERMINATION = "canEditDetermination";
    public static final String CAN_SAVE = "canSave";
    private transient IacucCommitteeScheduleService committeeScheduleService;

    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        IacucProtocolOnlineReviewDocument protocolOnlineReviewDocument = (IacucProtocolOnlineReviewDocument)document;
        String userId = user.getPrincipalId();
        if (this.canExecuteProtocolOnlineReviewTask(userId, protocolOnlineReviewDocument, "maintainIacucProtocolOnlineReviews")) {
            editModes.add("fullEntry");
            editModes.add(CAN_SAVE);
            editModes.add(CAN_EDIT_REVIEW_TYPE);
            editModes.add(CAN_EDIT_DETERMINATION);
        } else if (this.canExecuteProtocolOnlineReviewTask(userId, protocolOnlineReviewDocument, "modifyIacucProtocolOnlineReview")) {
            editModes.add("fullEntry");
            editModes.add(CAN_SAVE);
            if (this.canExecuteProtocolOnlineReviewTask(userId, protocolOnlineReviewDocument, "editIacucProtocolOnlineReviewType")) {
                editModes.add(CAN_EDIT_REVIEW_TYPE);
            }
            if (this.canExecuteProtocolOnlineReviewTask(userId, protocolOnlineReviewDocument, "editIacucProtocolOnlineReviewDetermination")) {
                editModes.add(CAN_EDIT_DETERMINATION);
            }
        } else if (this.canExecuteProtocolOnlineReviewTask(userId, protocolOnlineReviewDocument, "viewIacucProtocolOnlineReview")) {
            editModes.add("viewOnly");
        } else {
            editModes.add("unviewable");
        }
        IacucProtocolDocument iacucProtocolDocument = (IacucProtocolDocument)protocolOnlineReviewDocument.getProtocolOnlineReview().getProtocol().getProtocolDocument();
        boolean canAdministerCommitteeScheduleMinutes = this.canExecuteIacucProtocolTask(userId, iacucProtocolDocument, "maintainIacucProtocolOnlineReviews");
        for (IacucCommitteeScheduleMinute minute : this.getCommitteeScheduleService().getMinutesByProtocol(protocolOnlineReviewDocument.getProtocolOnlineReview().getProtocolId())) {
            Long onlineReviewId;
            Long minuteOnlineReviewId = minute.getProtocolOnlineReviewIdFk();
            if (!Objects.equals(minuteOnlineReviewId, onlineReviewId = protocolOnlineReviewDocument.getProtocolOnlineReview().getProtocolOnlineReviewId())) continue;
            boolean isCreator = StringUtils.equalsIgnoreCase((CharSequence)minute.getCreateUser(), (CharSequence)GlobalVariables.getUserSession().getPrincipalName());
            minute.setReadOnly(!editModes.contains(CAN_SAVE) || !canAdministerCommitteeScheduleMinutes && !isCreator);
        }
        return editModes;
    }

    private boolean canExecuteIacucProtocolTask(String userId, IacucProtocolDocument doc, String taskName) {
        IacucProtocolTask task = new IacucProtocolTask(taskName, doc.getIacucProtocol());
        TaskAuthorizationService taskAuthenticationService = KcServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(userId, task);
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return true;
    }

    public boolean canOpen(Document document, Person user) {
        IacucProtocolOnlineReviewDocument protocolOnlineReviewDocument = (IacucProtocolOnlineReviewDocument)document;
        if (protocolOnlineReviewDocument.getProtocolOnlineReview() == null) {
            return this.canCreateProtocolOnlineReview(user);
        }
        return this.canExecuteProtocolOnlineReviewTask(user.getPrincipalId(), (IacucProtocolOnlineReviewDocument)document, "viewProtocolOnlineReview");
    }

    private boolean canCreateProtocolOnlineReview(Person user) {
        ApplicationTask task = new ApplicationTask("createIacucProtocolOnlineReview");
        TaskAuthorizationService taskAuthenticationService = KcServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(user.getPrincipalId(), task);
    }

    private boolean canExecuteProtocolOnlineReviewTask(String userId, IacucProtocolOnlineReviewDocument doc, String taskName) {
        IacucProtocolOnlineReviewTask task = new IacucProtocolOnlineReviewTask(taskName, doc.getProtocolOnlineReview());
        TaskAuthorizationService taskAuthenticationService = KcServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(userId, task);
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        return this.canExecuteProtocolOnlineReviewTask(user.getPrincipalId(), (IacucProtocolOnlineReviewDocument)document, "modifyIacucProtocolOnlineReview") || this.canExecuteProtocolOnlineReviewTask(user.getPrincipalId(), (IacucProtocolOnlineReviewDocument)document, "maintainIacucProtocolOnlineReviews");
    }

    @Override
    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    @Override
    public boolean canCopy(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canCancel(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canRoute(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canApprove(Document document, Person user) {
        return super.canApprove(document, user);
    }

    @Override
    public boolean canDisapprove(Document document, Person user) {
        boolean result = super.canDisapprove(document, user);
        return result &= this.canExecuteProtocolOnlineReviewTask(user.getPrincipalId(), (IacucProtocolOnlineReviewDocument)document, "maintainIacucProtocolOnlineReviews");
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canFyi(Document document, Person user) {
        return false;
    }

    public IacucCommitteeScheduleService getCommitteeScheduleService() {
        if (this.committeeScheduleService == null) {
            this.committeeScheduleService = KcServiceLocator.getService(IacucCommitteeScheduleService.class);
        }
        return this.committeeScheduleService;
    }

    public void setCommitteeScheduleService(IacucCommitteeScheduleService committeeScheduleService) {
        this.committeeScheduleService = committeeScheduleService;
    }
}

