/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.type.InvestigatorCreditType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.common.framework.version.sequence.associate.SequenceAssociate;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalContact;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnitCreditSplit;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.krad.service.BusinessObjectService;

public class InstitutionalProposalPersonUnit
extends KcPersistableBusinessObjectBase
implements Comparable<InstitutionalProposalPersonUnit>,
SequenceAssociate<InstitutionalProposal> {
    private static final long serialVersionUID = 8863551989073626234L;
    private Long institutionalProposalPersonUnitId;
    private InstitutionalProposalPerson institutionalProposalPerson;
    private boolean leadUnit;
    private Unit unit;
    private List<InstitutionalProposalPersonUnitCreditSplit> creditSplits = new ArrayList<InstitutionalProposalPersonUnitCreditSplit>();
    private String unitNumber;
    private Long institutionalProposalContactId;

    public InstitutionalProposalPersonUnit() {
    }

    public InstitutionalProposalPersonUnit(InstitutionalProposalPerson institutionalProposalPerson) {
        this();
        this.setInstitutionalProposalPerson(institutionalProposalPerson);
    }

    public InstitutionalProposalPersonUnit(InstitutionalProposalPerson institutionalProposalPerson, Unit unit, boolean isLeadUnit) {
        this();
        this.institutionalProposalPerson = institutionalProposalPerson;
        this.setUnit(unit);
        this.leadUnit = isLeadUnit;
    }

    public static Unit findLeadUnit(Collection<InstitutionalProposalPersonUnit> institutionalProposalPersonUnits) {
        Unit foundLeadUnit = null;
        for (InstitutionalProposalPersonUnit apu : institutionalProposalPersonUnits) {
            if (!apu.isLeadUnit()) continue;
            foundLeadUnit = apu.getUnit();
        }
        return foundLeadUnit;
    }

    public List<UnitAdministrator> getOspAdministrators() {
        ArrayList<UnitAdministrator> ospAdministrators = new ArrayList<UnitAdministrator>();
        if (this.getUnit() != null) {
            for (UnitAdministrator unitAdministrator : this.getUnit().getUnitAdministrators()) {
                if (!unitAdministrator.getUnitAdministratorType().getDescription().equals("OSP_ADMINISTRATOR")) continue;
                ospAdministrators.add(unitAdministrator);
            }
        }
        return ospAdministrators;
    }

    public void add(InstitutionalProposalPersonUnitCreditSplit creditSplit) {
        this.creditSplits.add(creditSplit);
        creditSplit.setInstitutionalProposalPersonUnit(this);
    }

    public void initializeDefaultCreditSplits() {
        List creditTypes = (List)this.getBusinessObjectService().findAll(InvestigatorCreditType.class);
        for (InvestigatorCreditType creditType : creditTypes) {
            InstitutionalProposalPersonUnitCreditSplit creditSplit = new InstitutionalProposalPersonUnitCreditSplit(creditType, ScaleTwoDecimal.ZERO);
            this.add(creditSplit);
        }
    }

    @Override
    public int compareTo(InstitutionalProposalPersonUnit other) {
        return this.unit.getUnitName().compareToIgnoreCase(other.getUnit().getUnitName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstitutionalProposalPersonUnit)) {
            return false;
        }
        InstitutionalProposalPersonUnit other = (InstitutionalProposalPersonUnit)obj;
        if (this.institutionalProposalPerson == null ? other.institutionalProposalPerson != null : !this.institutionalProposalPerson.equals(other.institutionalProposalPerson)) {
            return false;
        }
        return !(this.unit == null ? other.unit != null : !this.unit.equals(other.unit));
    }

    public Long getInstitutionalProposalContactId() {
        return this.institutionalProposalContactId;
    }

    public InstitutionalProposalContact getInstitutionalProposalPerson() {
        return this.institutionalProposalPerson;
    }

    public Long getInstitutionalProposalPersonUnitId() {
        return this.institutionalProposalPersonUnitId;
    }

    public InstitutionalProposalPersonUnitCreditSplit getCreditSplit(int index) {
        return this.creditSplits.get(index);
    }

    public List<InstitutionalProposalPersonUnitCreditSplit> getCreditSplits() {
        return this.creditSplits;
    }

    public String getFullName() {
        return this.institutionalProposalPerson != null ? (this.institutionalProposalPerson.getContact() != null ? this.institutionalProposalPerson.getContact().getFullName() : null) : null;
    }

    public Unit getUnit() {
        this.lazilyLoadUnit();
        return this.unit;
    }

    public String getUnitName() {
        return this.unit != null ? this.unit.getUnitName() : null;
    }

    public String getUnitNumber() {
        return this.unitNumber;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.institutionalProposalPerson == null ? 0 : this.institutionalProposalPerson.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean isLeadUnit() {
        return this.leadUnit;
    }

    public void setInstitutionalProposalContactId(Long institutionalProposalPersonId) {
        this.institutionalProposalContactId = institutionalProposalPersonId;
    }

    public void setInstitutionalProposalPerson(InstitutionalProposalPerson institutionalProposalPerson) {
        this.institutionalProposalPerson = institutionalProposalPerson;
        this.institutionalProposalContactId = institutionalProposalPerson != null ? institutionalProposalPerson.getInstitutionalProposalContactId() : null;
    }

    public void setInstitutionalProposalPersonUnitId(Long institutionalProposalPersonUnitId) {
        this.institutionalProposalPersonUnitId = institutionalProposalPersonUnitId;
    }

    public void setCreditSplits(List<InstitutionalProposalPersonUnitCreditSplit> creditSplits) {
        this.creditSplits = creditSplits;
    }

    public void setLeadUnit(boolean leadUnit) {
        this.leadUnit = leadUnit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
        this.unitNumber = unit != null ? unit.getUnitNumber() : null;
    }

    public void setUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    private void lazilyLoadUnit() {
        Collection c;
        if (StringUtils.isNotEmpty((CharSequence)this.unitNumber) && this.unit == null && (c = this.getBusinessObjectService().findMatching(Unit.class, Collections.singletonMap("unitNumber", this.unitNumber))).size() > 0) {
            this.unit = (Unit)c.iterator().next();
        }
    }

    @Override
    public InstitutionalProposal getSequenceOwner() {
        return this.getInstitutionalProposalPerson() != null ? this.getInstitutionalProposalPerson().getInstitutionalProposal() : null;
    }

    @Override
    public void setSequenceOwner(InstitutionalProposal newlyVersionedOwner) {
        if (this.getInstitutionalProposalPerson() != null) {
            this.getInstitutionalProposalPerson().setInstitutionalProposal(newlyVersionedOwner);
        }
    }

    @Override
    public Integer getSequenceNumber() {
        return this.getInstitutionalProposalPerson() != null ? this.getInstitutionalProposalPerson().getSequenceNumber() : 0;
    }

    @Override
    public void resetPersistenceState() {
        this.institutionalProposalPersonUnitId = null;
    }
}

