/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.messaging.AsynchronousCall;
import org.kuali.rice.ksb.messaging.PersistedMessage;
import org.kuali.rice.ksb.messaging.PersistedMessagePayload;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.kuali.rice.ksb.util.KSBConstants;

@Entity
@Table(name="KRSB_MSG_QUE_T")
@NamedQueries(value={@NamedQuery(name="PersistedMessageBO.FindAll", query="select pm from PersistedMessageBO pm"), @NamedQuery(name="PersistedMessageBO.FindByServiceName", query="select pm from PersistedMessageBO pm where pm.serviceName = :serviceName and pm.methodName = :methodName"), @NamedQuery(name="PersistedMessageBO.GetNextDocuments", query="select pm from PersistedMessageBO pm where pm.applicationId = :applicationId and pm.queueStatus <> :queueStatus and pm.ipNumber = :ipNumber order by pm.queuePriority asc, pm.routeQueueId asc, pm.queueDate asc")})
public class PersistedMessageBO
implements PersistedMessage,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    private static final long serialVersionUID = -7047766894738304195L;
    @Id
    @GeneratedValue(generator="KRSB_MSG_QUE_S")
    @PortableSequenceGenerator(name="KRSB_MSG_QUE_S")
    @Column(name="MSG_QUE_ID")
    private Long routeQueueId;
    @Column(name="PRIO")
    private Integer queuePriority;
    @Column(name="STAT_CD")
    private String queueStatus;
    @Column(name="DT")
    private Timestamp queueDate;
    @Column(name="EXP_DT")
    private Timestamp expirationDate;
    @Column(name="RTRY_CNT")
    private Integer retryCount;
    @Version
    @Column(name="VER_NBR")
    private Integer lockVerNbr;
    @Column(name="IP_NBR")
    private String ipNumber;
    @Column(name="SVC_NM")
    private String serviceName;
    @Column(name="APPL_ID")
    private String applicationId;
    @Column(name="SVC_MTHD_NM")
    private String methodName;
    @Column(name="APP_VAL_ONE")
    private String value1;
    @Column(name="APP_VAL_TWO")
    private String value2;
    @Transient
    private AsynchronousCall methodCall;
    @Transient
    private PersistedMessagePayload payload;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public static PersistedMessageBO buildMessage(ServiceConfiguration serviceConfiguration, AsynchronousCall methodCall) {
        PersistedMessageBO message = new PersistedMessageBO();
        message.setPayload(new PersistedMessagePayload(methodCall, message));
        message.setIpNumber(RiceUtilities.getIpNumber());
        message.setServiceName(serviceConfiguration.getServiceName().toString());
        message.setQueueDate(new Timestamp(System.currentTimeMillis()));
        if (serviceConfiguration.getPriority() == null) {
            message.setQueuePriority(KSBConstants.ROUTE_QUEUE_DEFAULT_PRIORITY);
        } else {
            message.setQueuePriority(serviceConfiguration.getPriority());
        }
        message.setQueueStatus("Q");
        message.setRetryCount(0);
        if (serviceConfiguration.getMillisToLive() > 0L) {
            message.setExpirationDate(new Timestamp(System.currentTimeMillis() + serviceConfiguration.getMillisToLive()));
        }
        message.setApplicationId(CoreConfigHelper.getApplicationId());
        message.setMethodName(methodCall.getMethodName());
        return message;
    }

    public PersistedMessageBO copy() {
        PersistedMessageBO message = new PersistedMessageBO();
        message._persistence_set_routeQueueId(this._persistence_get_routeQueueId());
        message._persistence_set_queuePriority(this._persistence_get_queuePriority());
        message._persistence_set_queueStatus(this._persistence_get_queueStatus());
        message._persistence_set_queueDate(this._persistence_get_queueDate());
        message._persistence_set_expirationDate(this._persistence_get_expirationDate());
        message._persistence_set_retryCount(this._persistence_get_retryCount());
        message._persistence_set_lockVerNbr(this._persistence_get_lockVerNbr());
        message._persistence_set_ipNumber(this._persistence_get_ipNumber());
        message._persistence_set_serviceName(this._persistence_get_serviceName());
        message._persistence_set_applicationId(this._persistence_get_applicationId());
        message._persistence_set_methodName(this._persistence_get_methodName());
        message._persistence_set_value1(this._persistence_get_value1());
        message._persistence_set_value2(this._persistence_get_value2());
        message.methodCall = this.methodCall;
        message.payload = this.payload;
        return message;
    }

    @Override
    public String getApplicationId() {
        return this._persistence_get_applicationId();
    }

    public void setApplicationId(String applicationId) {
        this._persistence_set_applicationId(applicationId);
    }

    @Override
    public String getIpNumber() {
        return this._persistence_get_ipNumber();
    }

    public void setIpNumber(String ipNumber) {
        this._persistence_set_ipNumber(ipNumber);
    }

    @Override
    public Timestamp getQueueDate() {
        return this._persistence_get_queueDate();
    }

    @Override
    public Integer getQueuePriority() {
        return this._persistence_get_queuePriority();
    }

    @Override
    public String getQueueStatus() {
        return this._persistence_get_queueStatus();
    }

    @Override
    public Integer getRetryCount() {
        return this._persistence_get_retryCount();
    }

    public void setQueueDate(Timestamp timestamp) {
        this._persistence_set_queueDate(timestamp);
    }

    public void setQueuePriority(Integer integer) {
        this._persistence_set_queuePriority(integer);
    }

    public void setQueueStatus(String string) {
        this._persistence_set_queueStatus(string);
    }

    public void setRetryCount(Integer integer) {
        this._persistence_set_retryCount(integer);
    }

    public Integer getLockVerNbr() {
        return this._persistence_get_lockVerNbr();
    }

    public void setLockVerNbr(Integer lockVerNbr) {
        this._persistence_set_lockVerNbr(lockVerNbr);
    }

    @Override
    public Long getRouteQueueId() {
        return this._persistence_get_routeQueueId();
    }

    public void setRouteQueueId(Long queueSequence) {
        this._persistence_set_routeQueueId(queueSequence);
    }

    @Override
    public String getServiceName() {
        return this._persistence_get_serviceName();
    }

    public void setServiceName(String serviceName) {
        this._persistence_set_serviceName(serviceName);
    }

    public String toString() {
        return "[RouteQueue: , routeQueueId=" + this._persistence_get_routeQueueId() + ", ipNumber=" + this._persistence_get_ipNumber() + "applicationId=" + this._persistence_get_applicationId() + ", serviceName=" + this._persistence_get_serviceName() + ", methodName=" + this._persistence_get_methodName() + ", queueStatus=" + this._persistence_get_queueStatus() + ", queuePriority=" + this._persistence_get_queuePriority() + ", queueDate=" + this._persistence_get_queueDate() + "]";
    }

    @Override
    public AsynchronousCall getMethodCall() {
        return this.methodCall;
    }

    public void setMethodCall(AsynchronousCall methodCall) {
        this.methodCall = methodCall;
    }

    @Override
    public String getMethodName() {
        return this._persistence_get_methodName();
    }

    public void setMethodName(String methodName) {
        this._persistence_set_methodName(methodName);
    }

    @Override
    public Timestamp getExpirationDate() {
        return this._persistence_get_expirationDate();
    }

    public void setExpirationDate(Timestamp expirationDate) {
        this._persistence_set_expirationDate(expirationDate);
    }

    @Override
    public PersistedMessagePayload getPayload() {
        if (this.payload == null) {
            if (this.getRouteQueueId() == null) {
                return null;
            }
            this.payload = KSBServiceLocator.getMessageQueueService().findByPersistedMessageByRouteQueueId(this.getRouteQueueId());
        }
        return this.payload;
    }

    public void setPayload(PersistedMessagePayload payload) {
        this.payload = payload;
    }

    @Override
    public String getValue1() {
        return this._persistence_get_value1();
    }

    public void setValue1(String value1) {
        this._persistence_set_value1(value1);
    }

    @Override
    public String getValue2() {
        return this._persistence_get_value2();
    }

    public void setValue2(String value2) {
        this._persistence_set_value2(value2);
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new PersistedMessageBO();
    }

    public Object _persistence_get(String string) {
        if (string == "queuePriority") {
            return this.queuePriority;
        }
        if (string == "ipNumber") {
            return this.ipNumber;
        }
        if (string == "value2") {
            return this.value2;
        }
        if (string == "value1") {
            return this.value1;
        }
        if (string == "retryCount") {
            return this.retryCount;
        }
        if (string == "methodName") {
            return this.methodName;
        }
        if (string == "serviceName") {
            return this.serviceName;
        }
        if (string == "queueDate") {
            return this.queueDate;
        }
        if (string == "queueStatus") {
            return this.queueStatus;
        }
        if (string == "routeQueueId") {
            return this.routeQueueId;
        }
        if (string == "lockVerNbr") {
            return this.lockVerNbr;
        }
        if (string == "applicationId") {
            return this.applicationId;
        }
        if (string == "expirationDate") {
            return this.expirationDate;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "queuePriority") {
            this.queuePriority = (Integer)object;
            return;
        }
        if (string == "ipNumber") {
            this.ipNumber = (String)object;
            return;
        }
        if (string == "value2") {
            this.value2 = (String)object;
            return;
        }
        if (string == "value1") {
            this.value1 = (String)object;
            return;
        }
        if (string == "retryCount") {
            this.retryCount = (Integer)object;
            return;
        }
        if (string == "methodName") {
            this.methodName = (String)object;
            return;
        }
        if (string == "serviceName") {
            this.serviceName = (String)object;
            return;
        }
        if (string == "queueDate") {
            this.queueDate = (Timestamp)object;
            return;
        }
        if (string == "queueStatus") {
            this.queueStatus = (String)object;
            return;
        }
        if (string == "routeQueueId") {
            this.routeQueueId = (Long)object;
            return;
        }
        if (string == "lockVerNbr") {
            this.lockVerNbr = (Integer)object;
            return;
        }
        if (string == "applicationId") {
            this.applicationId = (String)object;
            return;
        }
        if (string == "expirationDate") {
            this.expirationDate = (Timestamp)object;
            return;
        }
    }

    public Integer _persistence_get_queuePriority() {
        this._persistence_checkFetched("queuePriority");
        return this.queuePriority;
    }

    public void _persistence_set_queuePriority(Integer n) {
        this._persistence_checkFetchedForSet("queuePriority");
        this._persistence_propertyChange("queuePriority", this.queuePriority, n);
        this.queuePriority = n;
    }

    public String _persistence_get_ipNumber() {
        this._persistence_checkFetched("ipNumber");
        return this.ipNumber;
    }

    public void _persistence_set_ipNumber(String string) {
        this._persistence_checkFetchedForSet("ipNumber");
        this._persistence_propertyChange("ipNumber", this.ipNumber, string);
        this.ipNumber = string;
    }

    public String _persistence_get_value2() {
        this._persistence_checkFetched("value2");
        return this.value2;
    }

    public void _persistence_set_value2(String string) {
        this._persistence_checkFetchedForSet("value2");
        this._persistence_propertyChange("value2", this.value2, string);
        this.value2 = string;
    }

    public String _persistence_get_value1() {
        this._persistence_checkFetched("value1");
        return this.value1;
    }

    public void _persistence_set_value1(String string) {
        this._persistence_checkFetchedForSet("value1");
        this._persistence_propertyChange("value1", this.value1, string);
        this.value1 = string;
    }

    public Integer _persistence_get_retryCount() {
        this._persistence_checkFetched("retryCount");
        return this.retryCount;
    }

    public void _persistence_set_retryCount(Integer n) {
        this._persistence_checkFetchedForSet("retryCount");
        this._persistence_propertyChange("retryCount", this.retryCount, n);
        this.retryCount = n;
    }

    public String _persistence_get_methodName() {
        this._persistence_checkFetched("methodName");
        return this.methodName;
    }

    public void _persistence_set_methodName(String string) {
        this._persistence_checkFetchedForSet("methodName");
        this._persistence_propertyChange("methodName", this.methodName, string);
        this.methodName = string;
    }

    public String _persistence_get_serviceName() {
        this._persistence_checkFetched("serviceName");
        return this.serviceName;
    }

    public void _persistence_set_serviceName(String string) {
        this._persistence_checkFetchedForSet("serviceName");
        this._persistence_propertyChange("serviceName", this.serviceName, string);
        this.serviceName = string;
    }

    public Timestamp _persistence_get_queueDate() {
        this._persistence_checkFetched("queueDate");
        return this.queueDate;
    }

    public void _persistence_set_queueDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("queueDate");
        this._persistence_propertyChange("queueDate", this.queueDate, timestamp);
        this.queueDate = timestamp;
    }

    public String _persistence_get_queueStatus() {
        this._persistence_checkFetched("queueStatus");
        return this.queueStatus;
    }

    public void _persistence_set_queueStatus(String string) {
        this._persistence_checkFetchedForSet("queueStatus");
        this._persistence_propertyChange("queueStatus", this.queueStatus, string);
        this.queueStatus = string;
    }

    public Long _persistence_get_routeQueueId() {
        this._persistence_checkFetched("routeQueueId");
        return this.routeQueueId;
    }

    public void _persistence_set_routeQueueId(Long l) {
        this._persistence_checkFetchedForSet("routeQueueId");
        this._persistence_propertyChange("routeQueueId", this.routeQueueId, l);
        this.routeQueueId = l;
    }

    public Integer _persistence_get_lockVerNbr() {
        this._persistence_checkFetched("lockVerNbr");
        return this.lockVerNbr;
    }

    public void _persistence_set_lockVerNbr(Integer n) {
        this._persistence_checkFetchedForSet("lockVerNbr");
        this._persistence_propertyChange("lockVerNbr", this.lockVerNbr, n);
        this.lockVerNbr = n;
    }

    public String _persistence_get_applicationId() {
        this._persistence_checkFetched("applicationId");
        return this.applicationId;
    }

    public void _persistence_set_applicationId(String string) {
        this._persistence_checkFetchedForSet("applicationId");
        this._persistence_propertyChange("applicationId", this.applicationId, string);
        this.applicationId = string;
    }

    public Timestamp _persistence_get_expirationDate() {
        this._persistence_checkFetched("expirationDate");
        return this.expirationDate;
    }

    public void _persistence_set_expirationDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("expirationDate");
        this._persistence_propertyChange("expirationDate", this.expirationDate, timestamp);
        this.expirationDate = timestamp;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

