/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.mask;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.mask.MaskFormatter;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

@BeanTag(name="maskFormatteSubString")
public class MaskFormatterSubString
implements MaskFormatter {
    private static final long serialVersionUID = -876112522775686636L;
    protected String maskCharacter = "*";
    protected int maskLength;

    @Override
    public String maskValue(Object value) {
        if (value == null) {
            return null;
        }
        if (this.maskCharacter == null) {
            throw new RuntimeException("Mask character not specified. Check DD maskTo attribute.");
        }
        String strValue = value.toString();
        if (strValue.length() < this.maskLength) {
            return StringUtils.repeat((String)this.maskCharacter, (int)this.maskLength);
        }
        if (this.maskLength > 0) {
            return StringUtils.repeat((String)this.maskCharacter, (int)this.maskLength) + strValue.substring(this.maskLength);
        }
        return strValue;
    }

    @BeanTagAttribute(name="maskCharacter")
    public String getMaskCharacter() {
        return this.maskCharacter;
    }

    public void setMaskCharacter(String maskCharacter) {
        this.maskCharacter = maskCharacter;
    }

    @BeanTagAttribute(name="maskLength")
    public int getMaskLength() {
        return this.maskLength;
    }

    public void setMaskLength(int maskLength) {
        this.maskLength = maskLength;
    }
}

