/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import org.flywaydb.core.internal.util.StringUtils;

public final class PropertiesUtils {
    private PropertiesUtils() {
    }

    public static Properties loadPropertiesFromString(String propertiesData) throws IOException {
        Properties properties = new Properties();
        BufferedReader in = new BufferedReader(new StringReader(propertiesData));
        String line;
        while ((line = in.readLine()) != null) {
            char firstChar;
            if ((line = StringUtils.trimLeadingWhitespace(line)).length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (PropertiesUtils.endsWithContinuationMarker(line)) {
                String nextLine = in.readLine();
                line = line.substring(0, line.length() - 1);
                if (nextLine == null) continue;
                line = line + StringUtils.trimLeadingWhitespace(nextLine);
            }
            int separatorIndex = line.indexOf("=");
            if (separatorIndex == -1) {
                separatorIndex = line.indexOf(":");
            }
            String key = separatorIndex != -1 ? line.substring(0, separatorIndex) : line;
            String value = separatorIndex != -1 ? line.substring(separatorIndex + 1) : "";
            key = StringUtils.trimTrailingWhitespace(key);
            value = StringUtils.trimLeadingWhitespace(value);
            properties.put(PropertiesUtils.unescape(key), PropertiesUtils.unescape(value));
        }
        return properties;
    }

    private static boolean endsWithContinuationMarker(String line) {
        boolean evenSlashCount = true;
        for (int index = line.length() - 1; index >= 0 && line.charAt(index) == '\\'; --index) {
            evenSlashCount = !evenSlashCount;
        }
        return !evenSlashCount;
    }

    private static String unescape(String str) {
        StringBuilder outBuffer = new StringBuilder(str.length());
        int index = 0;
        while (index < str.length()) {
            int c;
            if ((c = str.charAt(index++)) == 92) {
                if ((c = str.charAt(index++)) == 116) {
                    c = 9;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 110) {
                    c = 10;
                } else if (c == 102) {
                    c = 12;
                }
            }
            outBuffer.append((char)c);
        }
        return outBuffer.toString();
    }

    public static int getIntProperty(Properties properties, String key, int defaultValue) {
        String value = properties.getProperty(key);
        if (StringUtils.hasText(value)) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }
}

