/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.persistence.platform;

import java.sql.Connection;
import org.apache.ojb.broker.PersistenceBroker;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;

public abstract class ANSISqlDatabasePlatform
implements DatabasePlatform {
    public String getTruncateTableSql(String tableName) {
        return "truncate table " + tableName;
    }

    public String getCreateTableFromTableSql(String tableToCreate, String fromTable) {
        return new StringBuffer("create table ").append(tableToCreate).append(" as select * from ").append(fromTable).toString();
    }

    public String getInsertDataFromTableSql(String restoreTableName, String fromTableName) {
        return new StringBuffer("insert into ").append(restoreTableName).append(" select * from ").append(fromTableName).toString();
    }

    public String getDropTableSql(String tableName) {
        return new StringBuffer("drop table ").append(tableName).toString();
    }

    public String getIsNullFunction(String exprToTest, String exprToReplaceIfTestExprNull) {
        return " case when " + exprToTest + " is null then " + exprToReplaceIfTestExprNull + " else " + exprToTest + " end ";
    }

    public String getDateSQL(String date, String time) {
        String d = date.replace('/', '-');
        if (time == null) {
            return "{d '" + d + "'}";
        }
        return "{ts '" + d + " " + time + "'}";
    }

    public String getUpperCaseFunction() {
        return "UPPER";
    }

    public String toString() {
        return "[ANSISqlDatabasePlatform]";
    }

    public Long getNextValSQL(String sequenceName, Object nextValSource) {
        if (nextValSource instanceof Connection) {
            return this.getNextValSqlJdbc(sequenceName, (Connection)nextValSource);
        }
        if (nextValSource instanceof PersistenceBroker) {
            return this.getNextValSqlOjb(sequenceName, (PersistenceBroker)nextValSource);
        }
        throw new IllegalArgumentException("No next value strategy found for given nextValSource: " + nextValSource);
    }

    @Deprecated
    protected abstract Long getNextValSqlOjb(String var1, PersistenceBroker var2);

    @Deprecated
    protected abstract Long getNextValSqlJdbc(String var1, Connection var2);
}

