/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.api.notification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.ken.api.notification.NotificationChannel;
import org.kuali.rice.ken.api.notification.NotificationContentType;
import org.kuali.rice.ken.api.notification.NotificationContract;
import org.kuali.rice.ken.api.notification.NotificationPriority;
import org.kuali.rice.ken.api.notification.NotificationProducer;
import org.kuali.rice.ken.api.notification.NotificationRecipient;
import org.kuali.rice.ken.api.notification.NotificationRecipientContract;
import org.kuali.rice.ken.api.notification.NotificationSender;
import org.kuali.rice.ken.api.notification.NotificationSenderContract;
import org.w3c.dom.Element;

@XmlRootElement(name="notification")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="NotificationType", propOrder={"priority", "content", "channel", "contentType", "creationDateTime", "recipients", "senders", "autoRemoveDateTime", "deliveryType", "producer", "sendDateTime", "processingFlag", "lockedDate", "title", "contentMessage", "id", "versionNumber", "objectId", "docTypeName", "_futureElements"})
public final class Notification
extends AbstractDataTransferObject
implements NotificationContract {
    @XmlElement(name="priority", required=false)
    private final NotificationPriority priority;
    @XmlElement(name="content", required=false)
    private final String content;
    @XmlElement(name="channel", required=false)
    private final NotificationChannel channel;
    @XmlElement(name="contentType", required=false)
    private final NotificationContentType contentType;
    @XmlElement(name="creationDateTime", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime creationDateTime;
    @XmlElementWrapper(name="recipients", required=false)
    @XmlElement(name="recipient", required=false)
    private final List<NotificationRecipient> recipients;
    @XmlElementWrapper(name="senders", required=false)
    @XmlElement(name="sender", required=false)
    private final List<NotificationSender> senders;
    @XmlElement(name="autoRemoveDateTime", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime autoRemoveDateTime;
    @XmlElement(name="deliveryType", required=false)
    private final String deliveryType;
    @XmlElement(name="producer", required=false)
    private final NotificationProducer producer;
    @XmlElement(name="sendDateTime", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime sendDateTime;
    @XmlElement(name="processingFlag", required=false)
    private final String processingFlag;
    @XmlElement(name="lockedDate", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime lockedDate;
    @XmlElement(name="title", required=false)
    private final String title;
    @XmlElement(name="contentMessage", required=false)
    private final String contentMessage;
    @XmlElement(name="id", required=false)
    private final Long id;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlElement(name="docTypeName", required=false)
    private final String docTypeName;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private Notification() {
        this.priority = null;
        this.content = null;
        this.channel = null;
        this.contentType = null;
        this.creationDateTime = null;
        this.recipients = null;
        this.senders = null;
        this.autoRemoveDateTime = null;
        this.deliveryType = null;
        this.producer = null;
        this.sendDateTime = null;
        this.processingFlag = null;
        this.lockedDate = null;
        this.title = null;
        this.contentMessage = null;
        this.id = null;
        this.versionNumber = null;
        this.objectId = null;
        this.docTypeName = null;
    }

    private Notification(Builder builder) {
        this.priority = builder.getPriority() == null ? null : builder.getPriority().build();
        this.content = builder.getContent();
        this.channel = builder.getChannel() == null ? null : builder.getChannel().build();
        this.contentType = builder.getContentType() == null ? null : builder.getContentType().build();
        this.creationDateTime = builder.getCreationDateTime();
        this.recipients = new ArrayList<NotificationRecipient>();
        if (CollectionUtils.isNotEmpty(builder.getRecipients())) {
            for (NotificationRecipient.Builder recipient : builder.getRecipients()) {
                this.recipients.add(recipient.build());
            }
        }
        this.senders = new ArrayList<NotificationSender>();
        if (CollectionUtils.isNotEmpty(builder.getSenders())) {
            for (NotificationSender.Builder sender : builder.getSenders()) {
                this.senders.add(sender.build());
            }
        }
        this.autoRemoveDateTime = builder.getAutoRemoveDateTime();
        this.deliveryType = builder.getDeliveryType();
        this.producer = builder.getProducer() == null ? null : builder.getProducer().build();
        this.sendDateTime = builder.getSendDateTime();
        this.processingFlag = builder.getProcessingFlag();
        this.lockedDate = builder.getLockedDate();
        this.title = builder.getTitle();
        this.contentMessage = builder.getContentMessage();
        this.id = builder.getId();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
        this.docTypeName = builder.getDocTypeName();
    }

    @Override
    public NotificationPriority getPriority() {
        return this.priority;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public NotificationChannel getChannel() {
        return this.channel;
    }

    @Override
    public NotificationContentType getContentType() {
        return this.contentType;
    }

    @Override
    public DateTime getCreationDateTime() {
        return this.creationDateTime;
    }

    public List<NotificationRecipient> getRecipients() {
        return this.recipients;
    }

    public List<NotificationSender> getSenders() {
        return this.senders;
    }

    @Override
    public DateTime getAutoRemoveDateTime() {
        return this.autoRemoveDateTime;
    }

    @Override
    public String getDeliveryType() {
        return this.deliveryType;
    }

    @Override
    public NotificationProducer getProducer() {
        return this.producer;
    }

    @Override
    public DateTime getSendDateTime() {
        return this.sendDateTime;
    }

    @Override
    public String getProcessingFlag() {
        return this.processingFlag;
    }

    @Override
    public DateTime getLockedDate() {
        return this.lockedDate;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getContentMessage() {
        return this.contentMessage;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public String getDocTypeName() {
        return this.docTypeName;
    }

    static class Elements {
        static final String PRIORITY = "priority";
        static final String CONTENT = "content";
        static final String CHANNEL = "channel";
        static final String CONTENT_TYPE = "contentType";
        static final String CREATION_DATE_TIME = "creationDateTime";
        static final String LOCK_VER_NBR = "lockVerNbr";
        static final String RECIPIENTS = "recipients";
        static final String RECIPIENT = "recipient";
        static final String SENDERS = "senders";
        static final String SENDER = "sender";
        static final String AUTO_REMOVE_DATE_TIME = "autoRemoveDateTime";
        static final String DELIVERY_TYPE = "deliveryType";
        static final String PRODUCER = "producer";
        static final String SEND_DATE_TIME = "sendDateTime";
        static final String PROCESSING_FLAG = "processingFlag";
        static final String LOCKED_DATE = "lockedDate";
        static final String TITLE = "title";
        static final String CONTENT_MESSAGE = "contentMessage";
        static final String ID = "id";
        static final String DOC_TYPE_NAME = "docTypeName";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "notification";
        static final String TYPE_NAME = "NotificationType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    NotificationContract {
        private NotificationPriority.Builder priority;
        private String content;
        private NotificationChannel.Builder channel;
        private NotificationContentType.Builder contentType;
        private DateTime creationDateTime;
        private List<NotificationRecipient.Builder> recipients;
        private List<NotificationSender.Builder> senders;
        private DateTime autoRemoveDateTime;
        private String deliveryType;
        private NotificationProducer.Builder producer;
        private DateTime sendDateTime;
        private String processingFlag;
        private DateTime lockedDate;
        private String title;
        private String contentMessage;
        private Long id;
        private Long versionNumber;
        private String objectId;
        private String docTypeName;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(NotificationContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setPriority(contract.getPriority() == null ? null : NotificationPriority.Builder.create(contract.getPriority()));
            builder.setContent(contract.getContent());
            builder.setChannel(contract.getChannel() == null ? null : NotificationChannel.Builder.create(contract.getChannel()));
            builder.setContentType(contract.getContentType() == null ? null : NotificationContentType.Builder.create(contract.getContentType()));
            builder.setCreationDateTime(contract.getCreationDateTime());
            if (contract.getRecipients() != null) {
                ArrayList<NotificationRecipient.Builder> tempRecipients = new ArrayList<NotificationRecipient.Builder>();
                for (NotificationRecipientContract notificationRecipientContract : contract.getRecipients()) {
                    tempRecipients.add(NotificationRecipient.Builder.create(notificationRecipientContract));
                }
                builder.setRecipients(tempRecipients);
            }
            if (contract.getSenders() != null) {
                ArrayList<NotificationSender.Builder> tempSenders = new ArrayList<NotificationSender.Builder>();
                for (NotificationSenderContract notificationSenderContract : contract.getSenders()) {
                    tempSenders.add(NotificationSender.Builder.create(notificationSenderContract));
                }
                builder.setSenders(tempSenders);
            }
            builder.setAutoRemoveDateTime(contract.getAutoRemoveDateTime());
            builder.setDeliveryType(contract.getDeliveryType());
            builder.setProducer(contract.getProducer() == null ? null : NotificationProducer.Builder.create(contract.getProducer()));
            builder.setSendDateTime(contract.getSendDateTime());
            builder.setProcessingFlag(contract.getProcessingFlag());
            builder.setLockedDate(contract.getLockedDate());
            builder.setTitle(contract.getTitle());
            builder.setContentMessage(contract.getContentMessage());
            builder.setId(contract.getId());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            builder.setDocTypeName(contract.getDocTypeName());
            return builder;
        }

        public Notification build() {
            return new Notification(this);
        }

        @Override
        public NotificationPriority.Builder getPriority() {
            return this.priority;
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public NotificationChannel.Builder getChannel() {
            return this.channel;
        }

        @Override
        public NotificationContentType.Builder getContentType() {
            return this.contentType;
        }

        @Override
        public DateTime getCreationDateTime() {
            return this.creationDateTime;
        }

        public List<NotificationRecipient.Builder> getRecipients() {
            return this.recipients;
        }

        public List<NotificationSender.Builder> getSenders() {
            return this.senders;
        }

        @Override
        public DateTime getAutoRemoveDateTime() {
            return this.autoRemoveDateTime;
        }

        @Override
        public String getDeliveryType() {
            return this.deliveryType;
        }

        @Override
        public NotificationProducer.Builder getProducer() {
            return this.producer;
        }

        @Override
        public DateTime getSendDateTime() {
            return this.sendDateTime;
        }

        @Override
        public String getProcessingFlag() {
            return this.processingFlag;
        }

        @Override
        public DateTime getLockedDate() {
            return this.lockedDate;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getContentMessage() {
            return this.contentMessage;
        }

        @Override
        public Long getId() {
            return this.id;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        @Override
        public String getDocTypeName() {
            return this.docTypeName;
        }

        public void setPriority(NotificationPriority.Builder priority) {
            this.priority = priority;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setChannel(NotificationChannel.Builder channel) {
            this.channel = channel;
        }

        public void setContentType(NotificationContentType.Builder contentType) {
            this.contentType = contentType;
        }

        public void setCreationDateTime(DateTime creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public void setRecipients(List<NotificationRecipient.Builder> recipients) {
            this.recipients = recipients;
        }

        public void setSenders(List<NotificationSender.Builder> senders) {
            this.senders = senders;
        }

        public void setAutoRemoveDateTime(DateTime autoRemoveDateTime) {
            this.autoRemoveDateTime = autoRemoveDateTime;
        }

        public void setDeliveryType(String deliveryType) {
            this.deliveryType = deliveryType;
        }

        public void setProducer(NotificationProducer.Builder producer) {
            this.producer = producer;
        }

        public void setSendDateTime(DateTime sendDateTime) {
            this.sendDateTime = sendDateTime;
        }

        public void setProcessingFlag(String processingFlag) {
            this.processingFlag = processingFlag;
        }

        public void setLockedDate(DateTime lockedDate) {
            this.lockedDate = lockedDate;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setContentMessage(String contentMessage) {
            this.contentMessage = contentMessage;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public void setDocTypeName(String docTypeName) {
            this.docTypeName = docTypeName;
        }
    }
}

