/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.permissions.impl.rule.event;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.permissions.impl.bo.PermissionsUser;
import org.kuali.coeus.common.permissions.impl.rule.PermissionsRule;
import org.kuali.coeus.common.permissions.impl.web.bean.User;
import org.kuali.coeus.sys.framework.rule.KcDocumentEventBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;

public class AddPermissionsUserEvent
extends KcDocumentEventBase {
    private static final Logger LOG = LogManager.getLogger(AddPermissionsUserEvent.class);
    private PermissionsUser newUser;
    private List<User> users;

    public AddPermissionsUserEvent(Document document, List<User> users, PermissionsUser newUser) {
        super("adding user and role to document " + AddPermissionsUserEvent.getDocumentId((Document)document), "", document);
        this.users = users;
        this.newUser = newUser;
        this.logEvent();
    }

    public void validate() {
        super.validate();
        if (this.newUser == null) {
            throw new IllegalArgumentException("invalid (null) permissions user");
        }
    }

    @Override
    protected void logEvent() {
        StringBuffer logMessage = new StringBuffer(StringUtils.substringAfterLast((String)((Object)((Object)this)).getClass().getName(), (String)"."));
        logMessage.append(" with ");
        if (this.newUser == null) {
            logMessage.append("null newUser");
        } else {
            logMessage.append(this.newUser.toString());
        }
        LOG.debug((CharSequence)logMessage);
    }

    public Class getRuleInterfaceClass() {
        return PermissionsRule.class;
    }

    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((PermissionsRule)rule).processAddPermissionsUserBusinessRules(this.getDocument(), this.users, this.newUser);
    }
}

