/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.query;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.ojb.broker.query.DBException;

public abstract class SearchFilter {
    public static final int AND = 512;
    public static final int OR = 513;
    public static final int NOT = 2;
    public static final int IN = 3;
    public static final int NOT_IN = 4;
    public static final int LIKE = 265;
    public static final int EQUAL = 266;
    public static final int NOT_EQUAL = 267;
    public static final int LESS_THAN = 268;
    public static final int GREATER_THAN = 269;
    public static final int GREATER_EQUAL = 270;
    public static final int LESS_EQUAL = 271;
    protected static final int BINARY_OPER_MASK = 256;
    protected static final int LOGICAL_OPER_MASK = 512;
    protected SearchBase m_filter = null;

    public void matchList(String string, Vector vector, int n) {
        this.m_filter = null;
        if (n != 4) {
            n = 3;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        this.m_filter = new SearchBaseLeaf(string, n, (String[])objectArray);
    }

    public void matchList(String string, String[] stringArray, int n) {
        this.m_filter = null;
        if (n != 4) {
            n = 3;
        }
        this.m_filter = new SearchBaseLeaf(string, n, stringArray);
    }

    public void matchList(String string, int[] nArray, int n) {
        this.m_filter = null;
        if (n != 4) {
            n = 3;
        }
        this.m_filter = new SearchBaseLeafInt(string, n, nArray);
    }

    public void matchValue(String string, String string2, int n) {
        this.m_filter = null;
        if (n != 4) {
            n = 3;
        }
        String[] stringArray = new String[]{string2};
        this.m_filter = new SearchBaseLeaf(string, n, stringArray);
    }

    public void matchValue(String string, int n, int n2) {
        this.m_filter = null;
        if (n2 != 4) {
            n2 = 3;
        }
        this.m_filter = new SearchBaseLeafInt(string, n2, new int[]{n});
    }

    public void compareFilter(String string, String string2, int n) throws DBException {
        this.m_filter = null;
        if ((n & 0x100) == 0) {
            throw new DBException();
        }
        this.m_filter = new SearchBaseLeafComparison(string, n, string2);
    }

    public void matchSet(Hashtable hashtable, int n, int n2) throws DBException {
        this.m_filter = null;
        if ((n & 0x200) == 0) {
            throw new DBException();
        }
        if ((n2 & 0x100) == 0) {
            throw new DBException();
        }
        Vector<SearchBaseLeafComparison> vector = new Vector<SearchBaseLeafComparison>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            SearchBaseLeafComparison searchBaseLeafComparison = new SearchBaseLeafComparison(string, n2, string2);
            vector.addElement(searchBaseLeafComparison);
        }
        this.m_filter = new SearchBaseNode(n, vector);
    }

    public void matchSet(String[] stringArray, String[] stringArray2, int n) throws DBException {
        this.m_filter = null;
        if ((n & 0x200) == 0) {
            throw new DBException();
        }
        Vector<SearchBaseLeaf> vector = new Vector<SearchBaseLeaf>();
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            SearchBaseLeaf searchBaseLeaf = new SearchBaseLeaf(stringArray[i], 3, stringArray2[i]);
            vector.addElement(searchBaseLeaf);
        }
        this.m_filter = new SearchBaseNode(n, vector);
    }

    public void combine(Vector vector, int n) throws DBException {
        if ((n & 0x200) == 0) {
            throw new DBException();
        }
        Vector<SearchBase> vector2 = new Vector<SearchBase>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SearchFilter searchFilter = (SearchFilter)enumeration.nextElement();
            vector2.addElement(searchFilter.getFilter());
        }
        this.m_filter = new SearchBaseNode(n, this.m_filter, vector2);
    }

    public void combine(SearchFilter searchFilter, int n) throws DBException {
        if ((n & 0x200) == 0) {
            throw new DBException();
        }
        Vector<SearchBase> vector = new Vector<SearchBase>();
        vector.addElement(searchFilter.getFilter());
        this.m_filter = new SearchBaseNode(n, this.m_filter, vector);
    }

    protected static String ConvertBinaryOperator(int n) {
        String string;
        switch (n) {
            default: {
                string = "=";
                break;
            }
            case 265: {
                string = "LIKE";
                break;
            }
            case 267: {
                string = "!=";
                break;
            }
            case 268: {
                string = "<";
                break;
            }
            case 269: {
                string = ">";
                break;
            }
            case 270: {
                string = ">=";
                break;
            }
            case 271: {
                string = "<=";
            }
        }
        return string;
    }

    protected SearchBase getFilter() {
        return this.m_filter;
    }

    public abstract String toString();

    protected class SearchBaseNode
    extends SearchBase {
        public Vector nodes;

        SearchBaseNode(int n, Vector vector) {
            this.oper = n;
            this.nodes = vector;
        }

        SearchBaseNode(int n, Object object, Vector vector) {
            this.oper = n;
            this.nodes = new Vector();
            if (object != null) {
                this.nodes.addElement(object);
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.nodes.addElement(enumeration.nextElement());
            }
        }
    }

    protected class SearchBaseLeafInt
    extends SearchBase {
        public String elementName;
        public int[] matches;

        SearchBaseLeafInt(String string, int n, int[] nArray) {
            this.elementName = string;
            this.oper = n;
            this.matches = nArray;
        }

        SearchBaseLeafInt(String string, int n, int n2) {
            this.elementName = string;
            this.oper = n;
            this.matches = new int[1];
            this.matches[0] = n2;
        }
    }

    protected class SearchBaseLeaf
    extends SearchBase {
        public String elementName;
        public String[] matches;

        SearchBaseLeaf(String string, int n, String[] stringArray) {
            this.elementName = string;
            this.oper = n;
            this.matches = stringArray;
        }

        SearchBaseLeaf(String string, int n, String string2) {
            this.elementName = string;
            this.oper = n;
            this.matches = new String[1];
            this.matches[0] = string2;
        }
    }

    protected class SearchBaseLeafComparison
    extends SearchBase {
        public String elementName;
        public String value;

        SearchBaseLeafComparison(String string, int n, String string2) {
            this.elementName = string;
            this.oper = n;
            this.value = string2;
        }
    }

    protected class SearchBase {
        public int oper;

        protected SearchBase() {
        }
    }
}

