/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.api.generate;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.api.generate.FormGenerationResults;

public class MultiProjectFormGenerationResult
implements FormGenerationResults {
    private final boolean valid;
    private final String applicationXml;
    private final Map<String, List<AuditError>> auditErrors;
    private final Map<String, List<AttachmentData>> attachments;

    private MultiProjectFormGenerationResult(boolean valid, Map<String, List<AuditError>> errors, String applicationXml, Map<String, List<AttachmentData>> attachments) {
        this.valid = valid;
        this.applicationXml = applicationXml;
        this.auditErrors = errors;
        this.attachments = attachments;
    }

    public static MultiProjectFormGenerationResult invalid(Map<String, List<AuditError>> errors) {
        return new MultiProjectFormGenerationResult(false, errors, null, Collections.emptyMap());
    }

    public static MultiProjectFormGenerationResult valid(Map<String, List<AuditError>> errors, String applicationXML, Map<String, List<AttachmentData>> attachments) {
        return new MultiProjectFormGenerationResult(true, errors, applicationXML, attachments);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getApplicationXml() {
        return this.applicationXml;
    }

    @Override
    public List<AuditError> getErrors() {
        return this.auditErrors.entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Optional<List<AuditError>> getProposalErrors(String proposalNumber) {
        return Optional.ofNullable(this.auditErrors.get(proposalNumber));
    }

    @Override
    public List<AttachmentData> getAttachments() {
        return this.attachments.entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Optional<List<AttachmentData>> getProposalAttachments(String proposalNumber) {
        return Optional.ofNullable(this.attachments.get(proposalNumber));
    }
}

