/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.award.paymentreports.Report;
import org.kuali.kra.award.paymentreports.ValidClassReportFrequency;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.KeyValuesService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;

public class ReportCodeValuesFinder
extends UifKeyValuesFinderBase {
    private static final Comparator<KeyValue> COMPARATOR = new ReportCodeComparator();
    KeyValuesService keyValuesService;
    private String reportClassCode;

    public ReportCodeValuesFinder() {
    }

    public ReportCodeValuesFinder(String reportClassCode) {
        this.reportClassCode = reportClassCode;
    }

    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(ValuesFinderUtils.getSelectOption());
        if (this.getReportClassCode() != null) {
            keyValues.addAll(this.getKeyValues(this.getValidReportCodes()));
        }
        return keyValues;
    }

    protected List<String> getValidReportCodes() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("reportClassCode", this.getReportClassCode());
        return this.getKeyValuesService().findMatching(ValidClassReportFrequency.class, criteria).stream().map(ValidClassReportFrequency::getReportCode).collect(Collectors.toList());
    }

    protected List<KeyValue> getKeyValues(List<String> validFrequencyCodes) {
        return CollectionUtils.isEmpty(validFrequencyCodes) ? Collections.emptyList() : this.getKeyValuesService().findMatching(Report.class, Collections.singletonMap("reportCode", validFrequencyCodes)).stream().map(this::createKeyValue).sorted(COMPARATOR).collect(Collectors.toList());
    }

    protected KeyValue createKeyValue(Report report) {
        String description = report.getDescription();
        if (report.getFinalReportFlag()) {
            description = String.format("%s (Final Report)", description);
        }
        return new ConcreteKeyValue(report.getReportCode(), description);
    }

    public String getReportClassCode() {
        return this.reportClassCode;
    }

    public void setReportClassCode(String reportClassCode) {
        this.reportClassCode = reportClassCode;
    }

    protected KeyValuesService getKeyValuesService() {
        if (this.keyValuesService == null) {
            this.keyValuesService = KcServiceLocator.getService(KeyValuesService.class);
        }
        return this.keyValuesService;
    }

    static class ReportCodeComparator
    implements Comparator<KeyValue> {
        ReportCodeComparator() {
        }

        @Override
        public int compare(KeyValue kv1, KeyValue kv2) {
            try {
                String desc1 = kv1.getValue();
                String desc2 = kv2.getValue();
                if (desc1 == null) {
                    desc1 = "";
                }
                if (desc2 == null) {
                    desc2 = "";
                }
                return desc1.compareTo(desc2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

