/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security.admin.web;

import java.security.KeyStoreException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.kuali.rice.ksb.service.KSBServiceLocator;

public class JavaSecurityManagementForm
extends ActionForm {
    private static final long serialVersionUID = -46462912979586142L;
    private String alias;
    private String password;
    private String passwordVerify;

    public ActionErrors validateGenerateClientKeystore(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (StringUtils.isBlank((String)this.getAlias())) {
            errors.add("property", new ActionMessage("Alias must have a valid value.", false));
        }
        if (StringUtils.isBlank((String)this.getPassword()) || StringUtils.isBlank((String)this.getPasswordVerify())) {
            errors.add("property", new ActionMessage("Password must have a valid value in both fields.", false));
        }
        if (errors.isEmpty() && !StringUtils.equals((String)this.getPassword(), (String)this.getPasswordVerify())) {
            errors.add("property", new ActionMessage("Passwords do not match.", false));
        }
        if (errors.isEmpty()) {
            try {
                if (KSBServiceLocator.getJavaSecurityManagementService().isAliasInKeystore(this.getAlias())) {
                    errors.add("property", new ActionMessage("Alias '" + this.getAlias() + "' already exists in keystore.", false));
                }
            }
            catch (KeyStoreException e) {
                errors.add("property", new ActionMessage("Could not check keystore file for alias '" + this.getAlias(), false));
            }
        }
        return errors;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias == null ? null : alias.trim();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPasswordVerify() {
        return this.passwordVerify;
    }

    public void setPasswordVerify(String passwordVerify) {
        this.passwordVerify = passwordVerify;
    }
}

