/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout.collections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.element.Label;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.util.KRADUtils;

public class TableExporter {
    public static String buildExportTableData(CollectionGroup collectionGroup, Object model, String formatType) {
        Map<String, String> exportTableFormatOptions = TableExporter.getExportTableFormatOptions(formatType);
        String startTable = exportTableFormatOptions.get("startTable");
        String endTable = exportTableFormatOptions.get("endTable");
        StringBuilder tableRows = new StringBuilder("");
        TableLayoutManager layoutManager = (TableLayoutManager)collectionGroup.getLayoutManager();
        List<Label> headerLabels = layoutManager.getHeaderLabels();
        List<Field> rowFields = layoutManager.getAllRowFields();
        int numberOfColumns = layoutManager.getNumberOfColumns();
        List<Integer> ignoredColumns = TableExporter.findIgnoredColumns(layoutManager, collectionGroup);
        if (!headerLabels.isEmpty()) {
            ArrayList<String> labels = new ArrayList<String>();
            for (Label label : headerLabels) {
                labels.add(label.getLabelText());
            }
            tableRows.append(TableExporter.buildExportTableRow(labels, exportTableFormatOptions, ignoredColumns));
        }
        if (!rowFields.isEmpty()) {
            ArrayList<String> columnData = new ArrayList<String>();
            for (Field field : rowFields) {
                columnData.add(KRADUtils.getSimpleFieldValue(model, field));
                if (columnData.size() < numberOfColumns) continue;
                tableRows.append(TableExporter.buildExportTableRow(columnData, exportTableFormatOptions, ignoredColumns));
                columnData.clear();
            }
        }
        return startTable + tableRows.toString() + endTable;
    }

    protected static List<Integer> findIgnoredColumns(TableLayoutManager layoutManager, CollectionGroup collectionGroup) {
        ArrayList<Integer> ignoreColumns = new ArrayList<Integer>();
        int actionColumnIndex = layoutManager.getActionColumnIndex();
        int numberOfColumns = layoutManager.getNumberOfColumns();
        boolean renderActions = collectionGroup.isRenderLineActions() && !Boolean.TRUE.equals(collectionGroup.getReadOnly());
        boolean renderSelectField = collectionGroup.isIncludeLineSelectionField();
        boolean renderSequenceField = layoutManager.isRenderSequenceField();
        if (renderActions || renderSelectField || renderSequenceField) {
            int shiftColumn = 0;
            if (renderSelectField) {
                ignoreColumns.add(shiftColumn);
                ++shiftColumn;
            }
            if (renderSequenceField) {
                ignoreColumns.add(shiftColumn);
                ++shiftColumn;
            }
            if (renderActions) {
                if (actionColumnIndex == 1) {
                    ignoreColumns.add(shiftColumn);
                } else if (actionColumnIndex == -1) {
                    ignoreColumns.add(numberOfColumns - 1);
                } else if (actionColumnIndex > 1) {
                    ignoreColumns.add(actionColumnIndex);
                }
            }
        }
        return ignoreColumns;
    }

    protected static String buildExportTableRow(List<String> columnData, Map<String, String> tableFormatOptions, List<Integer> ignoredColumns) {
        String startRow = tableFormatOptions.get("startRow");
        String endRow = tableFormatOptions.get("endRow");
        String startColumn = tableFormatOptions.get("startColumn");
        String endColumn = tableFormatOptions.get("endColumn");
        boolean appendLastColumn = Boolean.valueOf(tableFormatOptions.get("appendLastColumn"));
        int columnIndex = 0;
        StringBuilder builder = new StringBuilder();
        for (String columnItem : columnData) {
            boolean displayColumn;
            boolean bl = displayColumn = !ignoredColumns.contains(columnIndex);
            if (displayColumn) {
                builder.append(startColumn + columnItem + endColumn);
            }
            if (columnIndex >= columnData.size() - 1 && !appendLastColumn) {
                builder.delete(builder.length() - endColumn.length(), builder.length());
            }
            ++columnIndex;
        }
        return startRow + builder.toString() + endRow;
    }

    protected static Map<String, String> getExportTableFormatOptions(String formatType) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contentType", "text/plain");
        map.put("formatType", "txt");
        map.put("startTable", "");
        map.put("endTable", "");
        map.put("startRow", "");
        map.put("endRow", "\n");
        map.put("startColumn", "");
        map.put("endColumn", ", ");
        map.put("appendLastColumn", "false");
        if ("csv".equals(formatType)) {
            map.put("contentType", "text/csv");
            map.put("formatType", "csv");
            map.put("startTable", "");
            map.put("endTable", "");
            map.put("startRow", "");
            map.put("endRow", "\n");
            map.put("startColumn", "");
            map.put("endColumn", ", ");
            map.put("appendLastColumn", "false");
        } else if ("xls".equals(formatType)) {
            map.put("contentType", "application/vnd.ms-excel");
            map.put("formatType", "xls");
            map.put("startTable", "");
            map.put("endTable", "");
            map.put("startRow", "");
            map.put("endRow", "\n");
            map.put("startColumn", "\"");
            map.put("endColumn", "\"\t");
            map.put("appendLastColumn", "true");
        } else if ("xml".equals(formatType)) {
            map.put("contentType", "application/xml");
            map.put("formatType", "xml");
            map.put("startTable", "<table>\n");
            map.put("endTable", "</table>\n");
            map.put("startRow", "  <row>\n");
            map.put("endRow", "  </row>\n");
            map.put("startColumn", "    <column>");
            map.put("endColumn", "</column>\n");
            map.put("appendLastColumn", "true");
        }
        return map;
    }
}

