/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.modular;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.nonpersonnel.AbstractBudgetCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetRateAndBase;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModular;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModularIdc;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModularService;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModularSummary;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="budgetModularService")
public class BudgetModularServiceImpl
implements BudgetModularService {
    private static final String RATE_CLASS_PROPERTY_NAME = "rateClass";
    private static final String RATE_NUMBER_PROPERTY_NAME = "rateNumber";
    private static final ScaleTwoDecimal TDC_NEXT_INCREMENT = new ScaleTwoDecimal(25000);
    @Autowired
    @Qualifier(value="budgetCalculationService")
    private BudgetCalculationService budgetCalculationService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    @Override
    public void generateModularPeriod(BudgetPeriod budgetPeriod) {
        if (ObjectUtils.isNull((Object)budgetPeriod.getBudgetModular())) {
            BudgetModular budgetModular = new BudgetModular(budgetPeriod);
            budgetModular.setBudgetPeriodObj(budgetPeriod);
            budgetPeriod.setBudgetModular(budgetModular);
        }
        budgetPeriod.getBudgetModular().calculateAllTotals();
    }

    @Override
    public BudgetModularSummary processModularSummary(Budget budget, boolean synchModular) {
        BudgetModularSummary modularSummary = new BudgetModularSummary();
        ScaleTwoDecimal directCostLessConsortiumFna = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal consortiumFna = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalDirectCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalFnaRequested = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalRequestedCost = ScaleTwoDecimal.ZERO;
        ArrayList<BudgetModularIdc> budgetModularIdcs = new ArrayList<BudgetModularIdc>();
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            BudgetModular budgetModular = budgetPeriod.getBudgetModular();
            if (ObjectUtils.isNull((Object)budgetModular)) continue;
            if (synchModular) {
                this.calculateAllTotalsAfterSync(budgetModular);
            } else {
                budgetModular.calculateAllTotals();
            }
            directCostLessConsortiumFna = (ScaleTwoDecimal)directCostLessConsortiumFna.add((AbstractDecimal)budgetModular.getDirectCostLessConsortiumFna());
            consortiumFna = (ScaleTwoDecimal)consortiumFna.add((AbstractDecimal)budgetModular.getConsortiumFna());
            totalDirectCost = (ScaleTwoDecimal)totalDirectCost.add((AbstractDecimal)budgetModular.getTotalDirectCost());
            totalFnaRequested = (ScaleTwoDecimal)totalFnaRequested.add((AbstractDecimal)budgetModular.getTotalFnaRequested());
            totalRequestedCost = (ScaleTwoDecimal)totalRequestedCost.add((AbstractDecimal)budgetModular.getTotalRequestedCost());
            budgetModularIdcs.addAll(budgetModular.getBudgetModularIdcs());
        }
        modularSummary.setDirectCostLessConsortiumFna(directCostLessConsortiumFna);
        modularSummary.setConsortiumFna(consortiumFna);
        modularSummary.setTotalDirectCost(totalDirectCost);
        modularSummary.setTotalFnaRequested(totalFnaRequested);
        modularSummary.setTotalRequestedCost(totalRequestedCost);
        modularSummary.setBudgetModularIdcs(budgetModularIdcs);
        return modularSummary;
    }

    private void calculateAllTotalsAfterSync(BudgetModular budgetModular) {
        budgetModular.calculateTotalDirectCost();
        ScaleTwoDecimal fnaRequested = budgetModular.getBudgetModularIdcs().stream().map(BudgetModularIdc::getFundsRequested).filter(Objects::nonNull).reduce(ScaleTwoDecimal.ZERO, AbstractDecimal::add);
        budgetModular.setTotalFnaRequested(fnaRequested);
        budgetModular.calculateTotalRequestedCost();
    }

    @Override
    public void synchModularBudget(Budget budget, boolean recalculateFromModifiedDirectCost) {
        if (!this.roundFandAbase()) {
            this.synchModularBudgetWithoutRoundingFandABase(budget);
        } else {
            this.synchModularBudgetAndRoundFandABase(budget, recalculateFromModifiedDirectCost);
        }
    }

    public void synchModularBudgetAndRoundFandABase(Budget budget, boolean recalculateFromModifiedDirectCost) {
        Collection<String> consortiumFnaCostElements = this.getConsortiumFnaOnlyCostElements();
        String fnaRateClassType = this.getFnaRateClassType();
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            BudgetModular budgetModular = this.initializeModularBudget(budgetPeriod);
            ScaleTwoDecimal directCostLessConsortiumFna = this.calculateConsortiumAmountsFandABaseRounded(budget, consortiumFnaCostElements, fnaRateClassType, budgetPeriod, budgetModular, recalculateFromModifiedDirectCost);
            if (budgetModular.getBudgetModularIdcs().size() > 0) {
                this.calculateFandAbase(recalculateFromModifiedDirectCost, budgetPeriod, budgetModular, budgetModular.getBudgetModularIdcs().size());
            }
            if (!recalculateFromModifiedDirectCost) {
                ScaleTwoDecimal modularTdc = this.roundToNextSubcontractModule(directCostLessConsortiumFna);
                budgetModular.setDirectCostLessConsortiumFna(modularTdc);
            }
            this.calculateAllTotalsAfterSync(budgetModular);
        }
    }

    public ScaleTwoDecimal calculateConsortiumAmountsFandABaseRounded(Budget budget, Collection<String> consortiumFnaCostElements, String fnaRateClassType, BudgetPeriod budgetPeriod, BudgetModular budgetModular, boolean recalculateFromModifiedDirectCost) {
        ScaleTwoDecimal directCostLessConsortiumFna = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal consortiumFna = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
            this.getBudgetCalculationService().calculateBudgetLineItem(budget, budgetLineItem);
            if (consortiumFnaCostElements.contains(budgetLineItem.getCostElement())) {
                consortiumFna = (ScaleTwoDecimal)consortiumFna.add((AbstractDecimal)budgetLineItem.getLineItemCost());
                directCostLessConsortiumFna = (ScaleTwoDecimal)directCostLessConsortiumFna.add((AbstractDecimal)this.calculateDirectCostWithoutFna(budgetLineItem));
            } else {
                directCostLessConsortiumFna = (ScaleTwoDecimal)directCostLessConsortiumFna.add((AbstractDecimal)budgetLineItem.getDirectCost());
            }
            this.createModularBudgetIndirectCost(budget, budgetModular, fnaRateClassType, budgetLineItem, true);
        }
        if (!recalculateFromModifiedDirectCost) {
            budgetModular.setConsortiumFna(consortiumFna);
        }
        return directCostLessConsortiumFna;
    }

    public void synchModularBudgetWithoutRoundingFandABase(Budget budget) {
        Collection<String> consortiumFnaOnlyCostElements = this.getConsortiumFnaOnlyCostElements();
        String fnaRateClassType = this.getFnaRateClassType();
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            BudgetModular budgetModular = this.initializeModularBudget(budgetPeriod);
            ScaleTwoDecimal directCostWithoutConsortiumFna = this.calculateConsortiumAmounts(budget, budgetPeriod, budgetModular, fnaRateClassType, consortiumFnaOnlyCostElements);
            budgetModular.setDirectCostLessConsortiumFna(this.roundToNextSubcontractModule(directCostWithoutConsortiumFna));
            this.calculateAllTotalsAfterSync(budgetModular);
        }
    }

    public ScaleTwoDecimal calculateConsortiumAmounts(Budget budget, BudgetPeriod budgetPeriod, BudgetModular budgetModular, String fnaRateClassType, Collection<String> consortiumFnaOnlyCostElements) {
        ScaleTwoDecimal directCostWithoutConsortiumFna = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal consortiumFna = ScaleTwoDecimal.ZERO;
        ArrayList<BudgetLineItem> budgetLineItems = new ArrayList<BudgetLineItem>(budgetPeriod.getBudgetLineItems());
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            this.getBudgetCalculationService().calculateBudgetLineItem(budget, budgetLineItem);
            if (consortiumFnaOnlyCostElements.contains(budgetLineItem.getCostElement())) {
                consortiumFna = (ScaleTwoDecimal)consortiumFna.add((AbstractDecimal)budgetLineItem.getLineItemCost());
                directCostWithoutConsortiumFna = (ScaleTwoDecimal)directCostWithoutConsortiumFna.add((AbstractDecimal)this.calculateDirectCostWithoutFna(budgetLineItem));
            } else {
                directCostWithoutConsortiumFna = (ScaleTwoDecimal)directCostWithoutConsortiumFna.add((AbstractDecimal)budgetLineItem.getDirectCost());
            }
            this.createModularBudgetIndirectCost(budget, budgetModular, fnaRateClassType, budgetLineItem, false);
        }
        budgetModular.setConsortiumFna(consortiumFna);
        return directCostWithoutConsortiumFna;
    }

    public void createModularBudgetIndirectCost(Budget budget, BudgetModular budgetModular, String fnaRateClassType, BudgetLineItem budgetLineItem, boolean roundFandABase) {
        for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
            budgetRateAndBase.refreshReferenceObject(RATE_CLASS_PROPERTY_NAME);
            if (!budgetRateAndBase.getRateClass().getRateClassTypeCode().equals(fnaRateClassType)) continue;
            BudgetModularIdc budgetModularIdc = this.setBudgetModularIdcInfo(budget, budgetModular, budgetRateAndBase);
            if (this.getApplyRateFlag(budgetLineItem, budgetRateAndBase)) {
                if (roundFandABase) {
                    this.setModularIdcInfoForFandABaseRoundedCalculation((ProposalDevelopmentBudgetExt)budget, budgetLineItem, budgetRateAndBase, budgetModularIdc);
                } else {
                    budgetModularIdc.setIdcBase(budgetRateAndBase.getBaseCost());
                }
            }
            budgetModularIdc.setBudgetModular(budgetModular);
            if (roundFandABase) {
                budgetModular.addNewBudgetModularIdcBaseRounded(budgetModularIdc);
                continue;
            }
            budgetModular.addNewBudgetModularIdcBaseUnrounded(budgetModularIdc);
        }
    }

    public void setModularIdcInfoForFandABaseRoundedCalculation(ProposalDevelopmentBudgetExt budget, BudgetLineItem budgetLineItem, BudgetRateAndBase budgetRateAndBase, BudgetModularIdc budgetModularIdc) {
        budgetModularIdc.setStartDate(budgetRateAndBase.getStartDate());
        budgetModularIdc.setEndDate(budgetRateAndBase.getEndDate());
        budgetModularIdc.setIdcBaseUnrounded(budgetRateAndBase.getBaseCost());
        budgetModularIdc.setIdcBase(null);
        this.setProposalNumber(budget, budgetLineItem, budgetModularIdc);
    }

    public BudgetModularIdc setBudgetModularIdcInfo(Budget budget, BudgetModular budgetModular, BudgetRateAndBase budgetRateAndBase) {
        BudgetModularIdc budgetModularIdc = new BudgetModularIdc();
        if (budgetModularIdc.getBudgetPeriod() == null) {
            budgetModularIdc.setBudgetPeriod(budgetModular.getBudgetPeriod());
        }
        if (budgetModularIdc.getBudgetId() == null) {
            budgetModularIdc.setBudgetId(budgetModular.getBudgetId());
        }
        if (budgetModularIdc.getBudgetPeriodId() == null) {
            budgetModularIdc.setBudgetPeriodId(budgetModular.getBudgetPeriodId());
        }
        budgetModularIdc.setRateNumber(budget.getNextValue(RATE_NUMBER_PROPERTY_NAME));
        budgetModularIdc.setDescription(budgetRateAndBase.getRateClassCode());
        budgetModularIdc.setIdcRate(budgetRateAndBase.getAppliedRate());
        budgetModularIdc.setFundsRequested(budgetRateAndBase.getCalculatedCost());
        return budgetModularIdc;
    }

    public void calculateFandAbase(boolean recalculateFromModifiedDirectCost, BudgetPeriod budgetPeriod, BudgetModular budgetModular, int numberOfIdcs) {
        ScaleTwoDecimal mtdcExcludedCosts = this.getMtdcExcludedCosts(budgetPeriod.getBudgetLineItems());
        ScaleTwoDecimal subcontractFna = this.getSubcontractFnaCosts(budgetPeriod.getBudgetLineItems());
        ScaleTwoDecimal startingFnaBase = this.getStartingFandAbase(budgetModular);
        ScaleTwoDecimal finalCostBase = ScaleTwoDecimal.ZERO;
        if (startingFnaBase.isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            ScaleTwoDecimal roundedFnaBaseWithExcludedCosts;
            if (recalculateFromModifiedDirectCost) {
                roundedFnaBaseWithExcludedCosts = budgetModular.getDirectCostLessConsortiumFna();
            } else {
                ScaleTwoDecimal fnaBaseLessSubcontractCosts = (ScaleTwoDecimal)((ScaleTwoDecimal)startingFnaBase.subtract((AbstractDecimal)subcontractFna)).add((AbstractDecimal)mtdcExcludedCosts);
                roundedFnaBaseWithExcludedCosts = this.roundToNextSubcontractModule(fnaBaseLessSubcontractCosts);
            }
            finalCostBase = (ScaleTwoDecimal)((ScaleTwoDecimal)roundedFnaBaseWithExcludedCosts.add((AbstractDecimal)subcontractFna)).subtract((AbstractDecimal)mtdcExcludedCosts);
        }
        if (numberOfIdcs == 1) {
            BudgetModularIdc idcEntry = budgetModular.getBudgetModularIdcs().get(0);
            idcEntry.setIdcBase(finalCostBase);
            idcEntry.calculateFundsRequested();
        } else {
            this.handleHierarchyBaseCalculations(budgetPeriod, budgetModular, startingFnaBase, finalCostBase);
        }
    }

    public ScaleTwoDecimal roundToNextSubcontractModule(ScaleTwoDecimal amountToBeRounded) {
        ScaleTwoDecimal amountRoundedToNextHighestModule = ScaleTwoDecimal.ZERO;
        while (amountToBeRounded.isGreaterThan((AbstractDecimal)amountRoundedToNextHighestModule)) {
            amountRoundedToNextHighestModule = (ScaleTwoDecimal)amountRoundedToNextHighestModule.add((AbstractDecimal)TDC_NEXT_INCREMENT);
        }
        return amountRoundedToNextHighestModule;
    }

    public ScaleTwoDecimal getStartingFandAbase(BudgetModular budgetModular) {
        ScaleTwoDecimal startingFnaBase = ScaleTwoDecimal.ZERO;
        for (BudgetModularIdc idcEntry : budgetModular.getBudgetModularIdcs()) {
            startingFnaBase = (ScaleTwoDecimal)startingFnaBase.add((AbstractDecimal)idcEntry.getIdcBaseUnrounded());
        }
        return startingFnaBase;
    }

    public void handleHierarchyBaseCalculations(BudgetPeriod budgetPeriod, BudgetModular budgetModular, ScaleTwoDecimal startingFnaBase, ScaleTwoDecimal finalCostBase) {
        ScaleTwoDecimal totalDirectFNACosts = startingFnaBase;
        long daysInPeriod = this.getDaysInPeriod(budgetPeriod.getStartDate(), budgetPeriod.getEndDate());
        for (BudgetModularIdc idcEntry : budgetModular.getBudgetModularIdcs()) {
            ScaleTwoDecimal thisChildFnaBase = idcEntry.getIdcBaseUnrounded();
            for (BudgetModularIdc anotherIdc : budgetModular.getBudgetModularIdcs()) {
                if (idcEntry.getHierarchyProposalNumber() == null || !idcEntry.getHierarchyProposalNumber().equals(anotherIdc.getHierarchyProposalNumber()) || idcEntry.getRateNumber().equals(anotherIdc.getRateNumber())) continue;
                thisChildFnaBase = (ScaleTwoDecimal)thisChildFnaBase.add((AbstractDecimal)anotherIdc.getIdcBaseUnrounded());
            }
            double childPercentOfTotal = thisChildFnaBase.doubleValue() / totalDirectFNACosts.doubleValue();
            long daysInIdcEntry = this.getDaysInPeriod(idcEntry.getStartDate(), idcEntry.getEndDate());
            double percentOfPeriod = (double)daysInIdcEntry / (double)daysInPeriod;
            double finalCostBaseDouble = finalCostBase.doubleValue();
            double partialCostBaseDouble = finalCostBaseDouble * percentOfPeriod * childPercentOfTotal;
            ScaleTwoDecimal partialCostBase = new ScaleTwoDecimal(partialCostBaseDouble);
            idcEntry.setIdcBase(partialCostBase);
            idcEntry.calculateFundsRequested();
        }
    }

    public void setProposalNumber(ProposalDevelopmentBudgetExt budget, BudgetLineItem budgetLineItem, BudgetModularIdc budgetModularIdc) {
        ProposalDevelopmentBudgetExt pdBudget = budget;
        if (budgetLineItem.getHierarchyProposalNumber() != null) {
            budgetModularIdc.setHierarchyProposalNumber(budgetLineItem.getHierarchyProposalNumber());
        } else {
            budgetModularIdc.setHierarchyProposalNumber(pdBudget.getDevelopmentProposal().getProposalNumber());
        }
    }

    public BudgetModular initializeModularBudget(BudgetPeriod budgetPeriod) {
        if (ObjectUtils.isNull((Object)budgetPeriod.getBudgetModular())) {
            BudgetModular tmpBudgetModular = new BudgetModular(budgetPeriod);
            tmpBudgetModular.setBudgetPeriodObj(budgetPeriod);
            budgetPeriod.setBudgetModular(tmpBudgetModular);
        }
        BudgetModular budgetModular = budgetPeriod.getBudgetModular();
        budgetModular.setBudgetModularIdcs(new ArrayList<BudgetModularIdc>());
        return budgetModular;
    }

    private ScaleTwoDecimal calculateDirectCostWithoutFna(BudgetLineItem budgetLineItem) {
        return budgetLineItem.getBudgetCalculatedAmounts().stream().filter(budgetLineItemCalculatedAmount -> !budgetLineItemCalculatedAmount.getRateClass().getRateClassTypeCode().equals(RateClassType.OVERHEAD.getRateClassType())).map(AbstractBudgetCalculatedAmount::getCalculatedCost).reduce(ScaleTwoDecimal.ZERO, AbstractDecimal::add);
    }

    protected ScaleTwoDecimal getMtdcExcludedCosts(List<BudgetLineItem> budgetLineItems) {
        ScaleTwoDecimal excludedCostTotal = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!budgetLineItem.getBudgetRateAndBaseList().isEmpty()) continue;
            excludedCostTotal = (ScaleTwoDecimal)excludedCostTotal.add((AbstractDecimal)budgetLineItem.getDirectCost());
        }
        return excludedCostTotal;
    }

    protected ScaleTwoDecimal getSubcontractFnaCosts(List<BudgetLineItem> budgetLineItems) {
        String COST_ELEMENT_SUB_UNDER_25K = this.getCostelementSubconFandAUnder25K();
        String COST_ELEMENT_SUB_OVER_25K = this.getCostelementSubconFandAOver25K();
        ScaleTwoDecimal subcontractFna = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!COST_ELEMENT_SUB_UNDER_25K.equals(budgetLineItem.getCostElement()) && !COST_ELEMENT_SUB_OVER_25K.equals(budgetLineItem.getCostElement())) continue;
            subcontractFna = (ScaleTwoDecimal)subcontractFna.add((AbstractDecimal)budgetLineItem.getLineItemCost());
        }
        return subcontractFna;
    }

    protected long getDaysInPeriod(Date startDate, Date endDate) {
        long diffMillis = endDate.getTime() - startDate.getTime();
        long diffDays = TimeUnit.DAYS.convert(diffMillis, TimeUnit.MILLISECONDS);
        return ++diffDays;
    }

    private boolean getApplyRateFlag(BudgetLineItem budgetLineItem, BudgetRateAndBase budgetRateAndBase) {
        return budgetLineItem.getBudgetCalculatedAmounts().stream().anyMatch(budgetCalculatedAmounts -> budgetCalculatedAmounts.getRateClassCode().equals(budgetRateAndBase.getRateClassCode()) && budgetCalculatedAmounts.getApplyRateFlag() != false);
    }

    public boolean roundFandAbase() {
        return this.parameterService.getParameterValueAsBoolean("KC-PD", "Document", "ModularBudget_Round_F_and_A_Base");
    }

    public Collection<String> getConsortiumFnaOnlyCostElements() {
        return this.parameterService.getParameterValuesAsString(Budget.class, "consortiumFnaCostElements");
    }

    public String getFnaRateClassType() {
        return this.parameterService.getParameterValueAsString(Budget.class, "fnaRateClassTypeCode");
    }

    public String getCostelementSubconFandAUnder25K() {
        return this.parameterService.getParameterValueAsString(Budget.class, "SUBCONTRACTOR_F_AND_A_LT_25K");
    }

    public String getCostelementSubconFandAOver25K() {
        return this.parameterService.getParameterValueAsString(Budget.class, "SUBCONTRACTOR_F_AND_A_GT_25K");
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }
}

