/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.budget.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategory;
import org.kuali.kra.external.HashMapElement;
import org.kuali.kra.external.budget.service.BudgetCategoryDTO;
import org.kuali.kra.external.budget.service.BudgetCategoryService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="budgetCategoryService")
public class BudgetCategoryServiceImpl
implements BudgetCategoryService {
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    @Override
    public List<BudgetCategoryDTO> lookupBudgetCategories(List<HashMapElement> criteria) {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        ArrayList<BudgetCategoryDTO> budgetCategoryDTOs = new ArrayList<BudgetCategoryDTO>();
        ArrayList budgetCategories = new ArrayList();
        if (ObjectUtils.isNull(criteria)) {
            budgetCategories = new ArrayList(this.businessObjectService.findAll(BudgetCategory.class));
        } else {
            for (HashMapElement element : criteria) {
                searchCriteria.put(element.getKey(), element.getValue());
            }
            budgetCategories = new ArrayList(this.businessObjectService.findMatching(BudgetCategory.class, searchCriteria));
        }
        if (budgetCategories != null && budgetCategories.size() > 0) {
            for (BudgetCategory budgetCategory : budgetCategories) {
                BudgetCategoryDTO budgetCategoryDTO = new BudgetCategoryDTO();
                budgetCategoryDTO.setBudgetCategoryCode(budgetCategory.getCode());
                budgetCategoryDTO.setAuthorPersonName(budgetCategory.getUpdateUser());
                budgetCategoryDTO.setBudgetCategoryTypeCode(budgetCategory.getBudgetCategoryTypeCode());
                budgetCategoryDTO.setBudgetCategoryTypeDescription(budgetCategory.getBudgetCategoryType().getDescription());
                budgetCategoryDTO.setDescription(budgetCategory.getDescription());
                budgetCategoryDTOs.add(budgetCategoryDTO);
            }
        }
        return budgetCategoryDTOs;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

