/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.translator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrimitiveAssignment {
    private static final Map<Class<?>, List<Class<?>>> compatibilityMatrix = new HashMap();

    public static boolean isCompatible(Class<?> primitiveType, Class<?> otherType) {
        if (compatibilityMatrix.containsKey(primitiveType)) {
            return compatibilityMatrix.get(primitiveType).contains(otherType);
        }
        return false;
    }

    private static void primitive(Class<?> primitiveClass, List<Class<?>> canAssign) {
        compatibilityMatrix.put(primitiveClass, canAssign);
    }

    private static List<Class<?>> canAssign(Class<?> ... items) {
        ArrayList classes = new ArrayList();
        for (Class<?> item : items) {
            classes.add(item);
        }
        return classes;
    }

    static {
        PrimitiveAssignment.primitive(Byte.TYPE, PrimitiveAssignment.canAssign(Byte.TYPE, Byte.class));
        PrimitiveAssignment.primitive(Short.TYPE, PrimitiveAssignment.canAssign(Short.TYPE, Short.class, Byte.TYPE, Byte.class));
        PrimitiveAssignment.primitive(Character.TYPE, PrimitiveAssignment.canAssign(Short.TYPE, Short.class, Byte.TYPE, Byte.class));
        PrimitiveAssignment.primitive(Integer.TYPE, PrimitiveAssignment.canAssign(Integer.TYPE, Integer.class, Short.TYPE, Short.class, Byte.TYPE, Byte.class));
        PrimitiveAssignment.primitive(Long.TYPE, PrimitiveAssignment.canAssign(Long.TYPE, Long.class, Integer.TYPE, Integer.class, Short.TYPE, Short.class, Byte.TYPE, Byte.class));
        PrimitiveAssignment.primitive(Float.TYPE, PrimitiveAssignment.canAssign(Float.TYPE, Float.class, Long.TYPE, Long.class, Integer.TYPE, Integer.class, Short.TYPE, Short.class, Byte.TYPE, Byte.class));
        PrimitiveAssignment.primitive(Double.TYPE, PrimitiveAssignment.canAssign(Double.TYPE, Double.class, Float.TYPE, Float.class, Long.TYPE, Long.class, Integer.TYPE, Integer.class, Short.TYPE, Short.class, Byte.TYPE, Byte.class));
        PrimitiveAssignment.primitive(Boolean.TYPE, PrimitiveAssignment.canAssign(Boolean.class, Boolean.TYPE));
    }
}

