/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kuali.rice.krad.datadictionary.Copyable;
import org.kuali.rice.krad.uif.util.LifecycleElement;

public class LifecycleAwareMap<K, V>
implements Map<K, V>,
Copyable,
Serializable {
    private static final long serialVersionUID = -2872079344892779899L;
    private final LifecycleElement lifecycleElement;
    private Map<K, V> delegate;

    public LifecycleAwareMap(LifecycleElement lifecycleElement) {
        this.lifecycleElement = lifecycleElement;
        this.delegate = Collections.emptyMap();
    }

    public LifecycleAwareMap(LifecycleElement lifecycleElement, Map<K, V> delegate) {
        this.lifecycleElement = lifecycleElement;
        this.delegate = delegate;
    }

    private void ensureMutable() {
        this.lifecycleElement.checkMutable(true);
        if (this.delegate == Collections.EMPTY_MAP) {
            this.delegate = new HashMap();
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.ensureMutable();
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.lifecycleElement.checkMutable(true);
        return this.delegate == Collections.EMPTY_MAP ? null : (V)this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.ensureMutable();
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        if (this.delegate != Collections.EMPTY_MAP) {
            this.delegate.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

