/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.useroptions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kew.useroptions.UserOptions;
import org.kuali.rice.kew.useroptions.UserOptionsId;
import org.kuali.rice.kew.useroptions.UserOptionsService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class UserOptionsServiceImpl
implements UserOptionsService {
    private DataObjectService dataObjectService;
    private static final Properties defaultProperties = new Properties();

    @Override
    public Collection<UserOptions> findByWorkflowUser(String principalId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"workflowId", (Object)principalId)});
        return this.dataObjectService.findMatching(UserOptions.class, criteria.build()).getResults();
    }

    @Override
    public List<UserOptions> findByUserQualified(String principalId, String likeString) {
        if (principalId == null) {
            return new ArrayList<UserOptions>(0);
        }
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"workflowId", (Object)principalId), PredicateFactory.like((String)"optionId", (CharSequence)likeString)})});
        return this.dataObjectService.findMatching(UserOptions.class, criteria.build()).getResults();
    }

    @Override
    public UserOptions findByOptionId(String optionId, String principalId) {
        if (optionId == null || "".equals(optionId) || principalId == null || "".equals(principalId)) {
            return null;
        }
        return (UserOptions)this.dataObjectService.find(UserOptions.class, (Object)new UserOptionsId(principalId, optionId));
    }

    @Override
    public void save(UserOptions userOptions) {
        this.dataObjectService.save((Object)userOptions, new PersistenceOption[0]);
    }

    @Override
    public void save(String principalId, Map<String, String> optionsMap) {
        if (optionsMap != null && !optionsMap.isEmpty()) {
            for (Map.Entry<String, String> entry : optionsMap.entrySet()) {
                UserOptions option = this.findByOptionId(entry.getKey(), principalId);
                if (option == null) {
                    option = new UserOptions();
                    option.setWorkflowId(principalId);
                }
                option.setOptionId(entry.getKey());
                option.setOptionVal(entry.getValue());
                this.save(option);
            }
        }
    }

    @Override
    public void save(String principalId, String optionId, String optionValue) {
        if (optionValue.length() <= 2000) {
            UserOptions option = this.findByOptionId(optionId, principalId);
            if (option == null) {
                option = new UserOptions();
                option.setWorkflowId(principalId);
            }
            option.setOptionId(optionId);
            option.setOptionVal(optionValue);
            this.save(option);
        }
    }

    @Override
    public void deleteUserOptions(UserOptions userOptions) {
        this.dataObjectService.delete((Object)userOptions);
    }

    @Override
    public List<UserOptions> retrieveEmailPreferenceUserOptions(String emailSetting) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.equal((String)"optionId", (Object)"EMAIL_NOTIFICATION"), PredicateFactory.like((String)"optionId", (CharSequence)"%.DocumentTypeNotification")}), PredicateFactory.equal((String)"optionVal", (Object)emailSetting)});
        return this.dataObjectService.findMatching(UserOptions.class, criteria.build()).getResults();
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    static {
        defaultProperties.setProperty("EMAIL_NOTIFICATION", "weekly");
    }
}

