/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.util.BitUtil;

public class MortonEncoder {
    private MortonEncoder() {
    }

    public static final long encode(double latitude, double longitude) {
        GeoUtils.checkLatitude((double)latitude);
        GeoUtils.checkLongitude((double)longitude);
        int latEnc = GeoEncodingUtils.encodeLatitude((double)latitude) ^ Integer.MIN_VALUE;
        int lonEnc = GeoEncodingUtils.encodeLongitude((double)longitude) ^ Integer.MIN_VALUE;
        return BitUtil.interleave((int)lonEnc, (int)latEnc);
    }

    public static final long encodeCeil(double latitude, double longitude) {
        GeoUtils.checkLatitude((double)latitude);
        GeoUtils.checkLongitude((double)longitude);
        int latEnc = GeoEncodingUtils.encodeLatitudeCeil((double)latitude) ^ Integer.MIN_VALUE;
        int lonEnc = GeoEncodingUtils.encodeLongitudeCeil((double)longitude) ^ Integer.MIN_VALUE;
        return BitUtil.interleave((int)lonEnc, (int)latEnc);
    }

    public static final double decodeLatitude(long hash) {
        return GeoEncodingUtils.decodeLatitude((int)((int)BitUtil.deinterleave((long)(hash >>> 1)) ^ Integer.MIN_VALUE));
    }

    public static final double decodeLongitude(long hash) {
        return GeoEncodingUtils.decodeLongitude((int)((int)BitUtil.deinterleave((long)hash) ^ Integer.MIN_VALUE));
    }

    public static String geoTermToString(long term) {
        StringBuilder s = new StringBuilder(64);
        int numberOfLeadingZeros = Long.numberOfLeadingZeros(term);
        for (int i = 0; i < numberOfLeadingZeros; ++i) {
            s.append('0');
        }
        if (term != 0L) {
            s.append(Long.toBinaryString(term));
        }
        return s.toString();
    }
}

