/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.processor;

import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.DictionaryObjectAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ValidationUtils;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ExistenceConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.OptionalElementConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.ProcessorResult;

public class ExistenceConstraintProcessor
extends OptionalElementConstraintProcessor<ExistenceConstraint> {
    private static final String CONSTRAINT_NAME = "existence constraint";

    @Override
    public ProcessorResult process(DictionaryValidationResult result, Object value, ExistenceConstraint constraint, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        return new ProcessorResult(this.processSingleExistenceConstraint(result, value, constraint, attributeValueReader));
    }

    @Override
    public String getName() {
        return CONSTRAINT_NAME;
    }

    @Override
    public Class<? extends Constraint> getConstraintType() {
        return ExistenceConstraint.class;
    }

    protected ConstraintValidationResult processSingleExistenceConstraint(DictionaryValidationResult result, Object value, ExistenceConstraint constraint, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        if (constraint.isRequired() == null) {
            return result.addNoConstraint(attributeValueReader, CONSTRAINT_NAME);
        }
        if (constraint.isRequired().booleanValue() && !this.skipConstraint(attributeValueReader)) {
            if (ValidationUtils.isNullOrEmpty(value)) {
                String errorParameter = attributeValueReader.getLabel(attributeValueReader.getAttributeName());
                if (ValidationUtils.isNullOrEmpty(errorParameter)) {
                    errorParameter = attributeValueReader.getAttributeName();
                }
                return result.addError(attributeValueReader, CONSTRAINT_NAME, "error.required", errorParameter);
            }
            return result.addSuccess(attributeValueReader, CONSTRAINT_NAME);
        }
        return result.addSkipped(attributeValueReader, CONSTRAINT_NAME);
    }

    private boolean skipConstraint(AttributeValueReader attributeValueReader) {
        boolean skipConstraint = false;
        if (attributeValueReader instanceof DictionaryObjectAttributeValueReader) {
            DictionaryObjectAttributeValueReader dictionaryValueReader = (DictionaryObjectAttributeValueReader)attributeValueReader;
            skipConstraint = dictionaryValueReader.isNestedAttribute() && dictionaryValueReader.isParentAttributeNull();
        }
        return skipConstraint;
    }
}

