/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo;

import com.codiform.moo.configuration.Configuration;
import com.codiform.moo.curry.Translate;
import com.codiform.moo.curry.Update;
import com.codiform.moo.property.source.CompositeSourcePropertyFactory;
import com.codiform.moo.session.TranslationSession;
import com.codiform.moo.session.TranslationSource;
import com.codiform.moo.translator.CachingTranslatorFactory;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class Moo {
    private CachingTranslatorFactory translatorFactory;

    public Moo() {
        this(new Configuration());
    }

    public Moo(Configuration configuration) {
        CompositeSourcePropertyFactory sourcePropertyFactory = new CompositeSourcePropertyFactory();
        this.translatorFactory = new CachingTranslatorFactory(configuration, sourcePropertyFactory);
    }

    public <T> Translate<T> translate(Class<T> destinationClass) {
        return new Translate<T>(this.translatorFactory, destinationClass);
    }

    public <T> T translate(Object source, Class<T> destinationClass) {
        return this.newSession().getTranslation(source, destinationClass);
    }

    public <T> List<T> translateEach(List<?> sources, Class<T> destinationClass) {
        return this.newSession().getEachTranslation(sources, destinationClass);
    }

    public <T> Collection<T> translateEach(Collection<?> sources, Class<T> destinationClass) {
        return this.newSession().getEachTranslation(sources, destinationClass);
    }

    public <T> Set<T> translateEach(Set<?> sources, Class<T> destinationClass) {
        return this.newSession().getEachTranslation(sources, destinationClass);
    }

    public void update(Object source, Object destination) {
        this.newSession().update(source, destination);
    }

    public Update update(Object source) {
        return new Update(this.translatorFactory, source);
    }

    protected TranslationSource newSession() {
        return new TranslationSession(this.translatorFactory);
    }
}

