/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.group;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.PredicateUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupQueryResults;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.krad.lookup.LookupableImpl;

public class GroupLookupableImpl
extends LookupableImpl {
    private static final long serialVersionUID = -3149952849854425077L;

    protected Collection<?> executeSearch(Map<String, String> adjustedSearchCriteria, List<String> wildcardAsLiteralSearchCriteria, boolean bounded, Integer searchResultsLimit) {
        HashMap<String, String> criteriaMap = new HashMap<String, String>(adjustedSearchCriteria);
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        if (!criteriaMap.isEmpty()) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (StringUtils.isNotBlank((String)((String)criteriaMap.get("principalName")))) {
                String principalId = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName((String)criteriaMap.get("principalName")).getPrincipalId();
                Timestamp currentTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
                predicates.add(PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"members.memberId", (Object)principalId), PredicateFactory.equal((String)"members.typeCode", (Object)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode()), PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)"members.activeFromDateValue"), PredicateFactory.greaterThanOrEqual((String)"members.activeFromDateValue", (Object)currentTime)}), PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)"members.activeToDateValue"), PredicateFactory.lessThan((String)"members.activeToDateValue", (Object)currentTime)})})}));
            }
            criteriaMap.remove("principalName");
            predicates.add(PredicateUtils.convertMapToPredicate(criteriaMap));
            criteria.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])predicates.toArray(new Predicate[predicates.size()]))});
        }
        GroupQueryResults groupResults = this.getGroupService().findGroups(criteria.build());
        List groups = groupResults.getResults();
        ArrayList<GroupBo> groupBos = new ArrayList<GroupBo>(groups.size());
        for (Group group : groups) {
            groupBos.add(GroupBo.from(group));
        }
        return groupBos;
    }

    public GroupService getGroupService() {
        return KimApiServiceLocator.getGroupService();
    }
}

