/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.metadata.FieldType;
import org.apache.ojb.broker.metadata.FieldTypeClasses;
import org.apache.ojb.broker.metadata.JdbcType;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class JdbcTypesHelper {
    private static Map jdbcObjectTypesFromType = new HashMap();
    private static Map jdbcObjectTypesFromName = new HashMap();

    public static void setJdbcType(String string, int n, JdbcType jdbcType) {
        JdbcTypesHelper.setJdbcTypeByName(string, jdbcType);
        JdbcTypesHelper.setJdbcTypeByTypesIndex(n, jdbcType);
    }

    public static JdbcType getJdbcTypeByTypesIndex(Integer n) {
        return (JdbcType)jdbcObjectTypesFromType.get(n);
    }

    public static void setJdbcTypeByTypesIndex(int n, JdbcType jdbcType) {
        jdbcObjectTypesFromType.put(new Integer(n), jdbcType);
    }

    public static JdbcType getJdbcTypeByName(String string) {
        JdbcType jdbcType = null;
        jdbcType = (JdbcType)jdbcObjectTypesFromName.get(string.toLowerCase());
        if (jdbcType == null) {
            throw new OJBRuntimeException("The type " + string + " can not be handled by OJB." + " Please specify only types as defined by java.sql.Types.");
        }
        return jdbcType;
    }

    public static void setJdbcTypeByName(String string, JdbcType jdbcType) {
        jdbcObjectTypesFromName.put(string, jdbcType);
    }

    public static JdbcType getJdbcTypeByReflection(String string) {
        JdbcType jdbcType;
        if (string.equalsIgnoreCase(Character.class.getName()) || string.equalsIgnoreCase("char")) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("char");
        } else if (string.equalsIgnoreCase(Short.class.getName()) || string.equalsIgnoreCase("short")) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("smallint");
        } else if (string.equalsIgnoreCase(Integer.class.getName()) || string.equalsIgnoreCase("int")) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("integer");
        } else if (string.equalsIgnoreCase(Long.class.getName()) || string.equalsIgnoreCase("long")) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("bigint");
        } else if (string.equalsIgnoreCase(Byte.class.getName()) || string.equalsIgnoreCase("byte")) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("tinyint");
        } else if (string.equalsIgnoreCase(Float.class.getName()) || string.equalsIgnoreCase("float")) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("real");
        } else if (string.equalsIgnoreCase(Double.class.getName()) || string.equalsIgnoreCase("double")) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("float");
        } else if (string.equalsIgnoreCase(String.class.getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("varchar");
        } else if (string.equalsIgnoreCase(java.util.Date.class.getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("date");
        } else if (string.equalsIgnoreCase(Date.class.getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("date");
        } else if (string.equalsIgnoreCase(Time.class.getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("time");
        } else if (string.equalsIgnoreCase(Timestamp.class.getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("timestamp");
        } else if (string.equalsIgnoreCase(BigDecimal.class.getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("decimal");
        } else if (string.equalsIgnoreCase(Ref.class.getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("ref");
        } else if (string.equalsIgnoreCase(Struct.class.getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("struct");
        } else if (string.equalsIgnoreCase(Boolean.class.getName()) || string.equalsIgnoreCase("boolean")) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("bit");
        } else if (string.equalsIgnoreCase(URL.class.getName())) {
            jdbcType = JdbcTypesHelper.getJdbcTypeByName("datalink");
        } else {
            throw new OJBRuntimeException("The type " + string + " can not be handled by OJB automatically." + " Please specify a type as defined by java.sql.Types in your field-descriptor");
        }
        return jdbcType;
    }

    public static Object getObjectFromColumn(ResultSet resultSet, Integer n, int n2) throws SQLException {
        return JdbcTypesHelper.getObjectFromColumn(resultSet, null, n, null, n2);
    }

    private static Object getObjectFromColumn(ResultSet resultSet, CallableStatement callableStatement, Integer n, String string, int n2) throws SQLException {
        return JdbcTypesHelper.getJdbcTypeByTypesIndex(n).getObjectFromColumn(resultSet, callableStatement, string, n2);
    }

    public static String getSqlTypeAsString(int n) {
        String string = "*can't find String representation for sql type '" + n + "'*";
        try {
            Field[] fieldArray = Types.class.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                if (fieldArray[i].getInt(null) != n) continue;
                string = fieldArray[i].getName();
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    static {
        JdbcTypesHelper.setJdbcType("array", 2003, new T_Array());
        JdbcTypesHelper.setJdbcType("bigint", -5, new T_BigInt());
        JdbcTypesHelper.setJdbcType("binary", -2, new T_Binary());
        JdbcTypesHelper.setJdbcType("bit", -7, new T_Bit());
        JdbcTypesHelper.setJdbcType("blob", 2004, new T_Blob());
        JdbcTypesHelper.setJdbcType("char", 1, new T_Char());
        JdbcTypesHelper.setJdbcType("clob", 2005, new T_Clob());
        JdbcTypesHelper.setJdbcType("date", 91, new T_Date());
        JdbcTypesHelper.setJdbcType("decimal", 3, new T_Decimal());
        JdbcTypesHelper.setJdbcType("double", 8, new T_Double());
        JdbcTypesHelper.setJdbcType("float", 6, new T_Float());
        JdbcTypesHelper.setJdbcType("integer", 4, new T_Integer());
        JdbcTypesHelper.setJdbcType("longvarbinary", -4, new T_LongVarBinary());
        JdbcTypesHelper.setJdbcType("longvarchar", -1, new T_LongVarChar());
        JdbcTypesHelper.setJdbcType("numeric", 2, new T_Numeric());
        JdbcTypesHelper.setJdbcType("real", 7, new T_Real());
        JdbcTypesHelper.setJdbcType("ref", 2006, new T_Ref());
        JdbcTypesHelper.setJdbcType("smallint", 5, new T_SmallInt());
        JdbcTypesHelper.setJdbcType("struct", 2002, new T_Struct());
        JdbcTypesHelper.setJdbcType("time", 92, new T_Time());
        JdbcTypesHelper.setJdbcType("timestamp", 93, new T_Timestamp());
        JdbcTypesHelper.setJdbcType("tinyint", -6, new T_TinyInt());
        JdbcTypesHelper.setJdbcType("varbinary", -3, new T_VarBinary());
        JdbcTypesHelper.setJdbcType("varchar", 12, new T_Varchar());
        JdbcTypesHelper.setJdbcType("boolean", 16, new T_Boolean());
        JdbcTypesHelper.setJdbcType("datalink", 70, new T_Datalink());
    }

    public static final class T_Datalink
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'DATALINK'");
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getURL(n);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getURL(string);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getURL(n);
        }

        @Override
        public int getType() {
            return 70;
        }
    }

    public static final class T_Ref
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'REF'");
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getRef(n);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getRef(string);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getRef(n);
        }

        @Override
        public int getType() {
            return 2006;
        }
    }

    public static final class T_Struct
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'STRUCT'");
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getObject(n);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getObject(string);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getObject(n);
        }

        @Override
        public int getType() {
            return 2002;
        }
    }

    public static final class T_Array
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'ARRAY'");
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getArray(n);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getArray(string);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getArray(n);
        }

        @Override
        public int getType() {
            return 2003;
        }
    }

    public static final class T_Blob
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'BLOB'");
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            Blob blob = callableStatement.getBlob(n);
            return callableStatement.wasNull() ? null : blob.getBytes(1L, (int)blob.length());
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            Blob blob = resultSet.getBlob(string);
            return resultSet.wasNull() ? null : blob.getBytes(1L, (int)blob.length());
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            Blob blob = resultSet.getBlob(n);
            return resultSet.wasNull() ? null : blob.getBytes(1L, (int)blob.length());
        }

        @Override
        public int getType() {
            return 2004;
        }
    }

    public static final class T_Clob
    extends BaseType {
        protected static final int BUFSZ = 32768;

        protected static String safeClobToString(Clob clob) throws SQLException {
            long l = clob.length();
            if (l == 0L) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[32768];
            Reader reader = clob.getCharacterStream();
            try {
                int n;
                while ((n = reader.read(cArray)) != -1) {
                    stringBuffer.append(cArray, 0, n);
                }
                reader.close();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getLocalizedMessage());
            }
            return stringBuffer.toString();
        }

        @Override
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'CLOB'");
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            Clob clob = callableStatement.getClob(n);
            return callableStatement.wasNull() ? null : T_Clob.safeClobToString(clob);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            Clob clob = resultSet.getClob(string);
            return resultSet.wasNull() ? null : T_Clob.safeClobToString(clob);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            Clob clob = resultSet.getClob(n);
            return resultSet.wasNull() ? null : T_Clob.safeClobToString(clob);
        }

        @Override
        public int getType() {
            return 2005;
        }
    }

    public static final class T_Timestamp
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return new Timestamp(l);
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getTimestamp(n);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getTimestamp(string);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getTimestamp(n);
        }

        @Override
        public int getType() {
            return 93;
        }
    }

    public static final class T_Time
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return new Time(l);
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getTime(n);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getTime(string);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getTime(n);
        }

        @Override
        public int getType() {
            return 92;
        }
    }

    public static final class T_Date
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return new Date(l);
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getDate(n);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getDate(string);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getDate(n);
        }

        @Override
        public int getType() {
            return 91;
        }
    }

    public static final class T_LongVarBinary
    extends BaseType {
        protected static final int BUFSZ = 2048;

        protected static byte[] retrieveStreamDataFromRs(InputStream inputStream) throws SQLException {
            if (inputStream == null) {
                return null;
            }
            byte[] byArray = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            try {
                int n;
                byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[2048];
                while ((n = inputStream.read(byArray2, 0, byArray2.length)) > 0) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new SQLException("I/O exception retrieving LONGVARBINARY: " + iOException.getLocalizedMessage());
            }
            finally {
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return byArray;
        }

        @Override
        public Object sequenceKeyConversion(Long l) {
            return l.toString().getBytes();
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getBytes(n);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return T_LongVarBinary.retrieveStreamDataFromRs(resultSet.getBinaryStream(string));
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return T_LongVarBinary.retrieveStreamDataFromRs(resultSet.getBinaryStream(n));
        }

        @Override
        public int getType() {
            return -4;
        }
    }

    public static final class T_VarBinary
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return l.toString().getBytes();
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getBytes(n);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getBytes(string);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getBytes(n);
        }

        @Override
        public int getType() {
            return -3;
        }
    }

    public static final class T_Binary
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return l.toString().getBytes();
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getBytes(n);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getBytes(string);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getBytes(n);
        }

        @Override
        public int getType() {
            return -2;
        }
    }

    public static final class T_Double
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return new Double(l.doubleValue());
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            double d = callableStatement.getDouble(n);
            return callableStatement.wasNull() ? null : new Double(d);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            double d = resultSet.getDouble(string);
            return resultSet.wasNull() ? null : new Double(d);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            double d = resultSet.getDouble(n);
            return resultSet.wasNull() ? null : new Double(d);
        }

        @Override
        public int getType() {
            return 8;
        }
    }

    public static final class T_Float
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return new Double(l.doubleValue());
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            double d = callableStatement.getDouble(n);
            return callableStatement.wasNull() ? null : new Double(d);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            double d = resultSet.getDouble(string);
            return resultSet.wasNull() ? null : new Double(d);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            double d = resultSet.getDouble(n);
            return resultSet.wasNull() ? null : new Double(d);
        }

        @Override
        public int getType() {
            return 6;
        }
    }

    public static final class T_Real
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return new Float(l.floatValue());
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            float f = callableStatement.getFloat(n);
            return callableStatement.wasNull() ? null : new Float(f);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            float f = resultSet.getFloat(string);
            return resultSet.wasNull() ? null : new Float(f);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            float f = resultSet.getFloat(n);
            return resultSet.wasNull() ? null : new Float(f);
        }

        @Override
        public int getType() {
            return 7;
        }
    }

    public static final class T_BigInt
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return l;
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            long l = callableStatement.getLong(n);
            return callableStatement.wasNull() ? null : new Long(l);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            long l = resultSet.getLong(string);
            return resultSet.wasNull() ? null : new Long(l);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            long l = resultSet.getLong(n);
            return resultSet.wasNull() ? null : new Long(l);
        }

        @Override
        public int getType() {
            return -5;
        }
    }

    public static final class T_Integer
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return new Integer(l.intValue());
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            int n2 = callableStatement.getInt(n);
            return callableStatement.wasNull() ? null : new Integer(n2);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            int n = resultSet.getInt(string);
            return resultSet.wasNull() ? null : new Integer(n);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            int n2 = resultSet.getInt(n);
            return resultSet.wasNull() ? null : new Integer(n2);
        }

        @Override
        public int getType() {
            return 4;
        }
    }

    public static final class T_SmallInt
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return new Short(l.shortValue());
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            short s = callableStatement.getShort(n);
            return callableStatement.wasNull() ? null : new Short(s);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            short s = resultSet.getShort(string);
            return resultSet.wasNull() ? null : new Short(s);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            short s = resultSet.getShort(n);
            return resultSet.wasNull() ? null : new Short(s);
        }

        @Override
        public int getType() {
            return 5;
        }
    }

    public static final class T_TinyInt
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return new Byte(l.byteValue());
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            byte by = callableStatement.getByte(n);
            return callableStatement.wasNull() ? null : new Byte(by);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            byte by = resultSet.getByte(string);
            return resultSet.wasNull() ? null : new Byte(by);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            byte by = resultSet.getByte(n);
            return resultSet.wasNull() ? null : new Byte(by);
        }

        @Override
        public int getType() {
            return -6;
        }
    }

    public static final class T_Boolean
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'BOOLEAN'");
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            boolean bl = callableStatement.getBoolean(n);
            return callableStatement.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)bl);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            boolean bl = resultSet.getBoolean(string);
            return resultSet.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)bl);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            boolean bl = resultSet.getBoolean(n);
            return resultSet.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)bl);
        }

        @Override
        public int getType() {
            return 16;
        }
    }

    public static final class T_Bit
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'BIT'");
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            boolean bl = callableStatement.getBoolean(n);
            return callableStatement.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)bl);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            boolean bl = resultSet.getBoolean(string);
            return resultSet.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)bl);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            boolean bl = resultSet.getBoolean(n);
            return resultSet.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)bl);
        }

        @Override
        public int getType() {
            return -7;
        }
    }

    public static final class T_Decimal
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return new BigDecimal(l);
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getBigDecimal(n);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getBigDecimal(string);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getBigDecimal(n);
        }

        @Override
        public int getType() {
            return 3;
        }
    }

    public static final class T_Numeric
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return new BigDecimal(l);
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getBigDecimal(n);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getBigDecimal(string);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getBigDecimal(n);
        }

        @Override
        public int getType() {
            return 2;
        }
    }

    public static final class T_LongVarChar
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return l.toString();
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getString(n);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getString(string);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getString(n);
        }

        @Override
        public int getType() {
            return -1;
        }
    }

    public static final class T_Varchar
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return l.toString();
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getString(n);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getString(string);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getString(n);
        }

        @Override
        public int getType() {
            return 12;
        }
    }

    public static final class T_Char
    extends BaseType {
        @Override
        public Object sequenceKeyConversion(Long l) {
            return l.toString();
        }

        @Override
        Object readValueFromStatement(CallableStatement callableStatement, int n) throws SQLException {
            return callableStatement.getString(n);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, String string) throws SQLException {
            return resultSet.getString(string);
        }

        @Override
        Object readValueFromResultSet(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getString(n);
        }

        @Override
        public int getType() {
            return 1;
        }
    }

    public static abstract class BaseType
    implements JdbcType {
        private FieldType fieldType = FieldTypeClasses.newFieldType(this);

        protected BaseType() {
        }

        abstract Object readValueFromResultSet(ResultSet var1, String var2) throws SQLException;

        abstract Object readValueFromResultSet(ResultSet var1, int var2) throws SQLException;

        abstract Object readValueFromStatement(CallableStatement var1, int var2) throws SQLException;

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            boolean bl = false;
            if (object instanceof JdbcType) {
                bl = this.getType() == ((JdbcType)object).getType();
            }
            return bl;
        }

        public int hashCode() {
            return this.getType();
        }

        @Override
        public FieldType getFieldType() {
            return this.fieldType;
        }

        @Override
        public Object getObjectFromColumn(CallableStatement callableStatement, int n) throws SQLException {
            return this.getObjectFromColumn(null, callableStatement, null, n);
        }

        @Override
        public Object getObjectFromColumn(ResultSet resultSet, String string) throws SQLException {
            return this.getObjectFromColumn(resultSet, null, string, Integer.MIN_VALUE);
        }

        @Override
        public Object getObjectFromColumn(ResultSet resultSet, CallableStatement callableStatement, String string, int n) throws SQLException {
            if (callableStatement != null) {
                if (n == Integer.MIN_VALUE) {
                    throw new UnsupportedOperationException("Not implemented yet");
                }
                return this.readValueFromStatement(callableStatement, n);
            }
            return n == Integer.MIN_VALUE ? this.readValueFromResultSet(resultSet, string) : this.readValueFromResultSet(resultSet, n);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("jdbcType", this.getType()).append("jdbcTypeString", (Object)JdbcTypesHelper.getSqlTypeAsString(this.getType())).append("associatedFieldType", (Object)this.getFieldType()).toString();
        }
    }
}

