/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;

public final class RiceUtilities {
    private static final Logger LOG = LogManager.getLogger(RiceUtilities.class);
    private static String instanceIpAddress;
    private static String instanceHostName;

    private RiceUtilities() {
        throw new UnsupportedOperationException("do not call");
    }

    public static synchronized String getIpNumber() {
        if (instanceIpAddress == null) {
            if (ConfigContext.getCurrentContextConfig() != null) {
                String ip = System.getProperty("host.ip");
                if (StringUtils.isBlank((String)ip)) {
                    ip = ConfigContext.getCurrentContextConfig().getProperty("host.ip");
                }
                if (StringUtils.isBlank((String)ip)) {
                    return RiceUtilities.getCurrentEnvironmentNetworkIp();
                }
                instanceIpAddress = ip;
            } else {
                return RiceUtilities.getCurrentEnvironmentNetworkIp();
            }
        }
        return instanceIpAddress;
    }

    private static String getCurrentEnvironmentNetworkIp() {
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            LOG.error("Somehow we have a socket error...", (Throwable)e);
            return "127.0.0.1";
        }
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                InetAddress addr = address.nextElement();
                if (addr.isLoopbackAddress() || addr.isSiteLocalAddress() || addr.getHostAddress().indexOf(":") > -1) continue;
                return addr.getHostAddress();
            }
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }

    public static synchronized String getHostName() {
        if (instanceHostName == null) {
            try {
                String host;
                if (ConfigContext.getCurrentContextConfig() != null) {
                    host = System.getProperty("host.name");
                    if (StringUtils.isBlank((String)host)) {
                        host = ConfigContext.getCurrentContextConfig().getProperty("host.name");
                    }
                    if (StringUtils.isBlank((String)host)) {
                        return InetAddress.getByName(RiceUtilities.getCurrentEnvironmentNetworkIp()).getHostName();
                    }
                } else {
                    return InetAddress.getByName(RiceUtilities.getCurrentEnvironmentNetworkIp()).getHostName();
                }
                instanceHostName = host;
            }
            catch (Exception ex) {
                return "localhost";
            }
        }
        return instanceHostName;
    }

    public static InputStream getResourceAsStream(String resourceLoc) throws MalformedURLException, IOException {
        Resource resource = RiceUtilities.getResource(resourceLoc);
        if (resource.exists()) {
            return resource.getInputStream();
        }
        return null;
    }

    private static Resource getResource(String resourceLoc) {
        AbsoluteFileSystemResourceLoader resourceLoader = new AbsoluteFileSystemResourceLoader();
        resourceLoader.setClassLoader(ClassLoaderUtils.getDefaultClassLoader());
        return resourceLoader.getResource(resourceLoc);
    }

    public static <T extends Throwable> T findExceptionInStack(Throwable topLevelException, Class<T> exceptionClass) {
        for (Throwable t = topLevelException; t != null; t = t.getCause()) {
            if (!exceptionClass.isAssignableFrom(t.getClass())) continue;
            return (T)t;
        }
        return null;
    }

    public static String getFileSizeUnits(Long fileSize) {
        Long newFileSize = fileSize;
        String fileSizeUnits = "bytes";
        if (fileSize > 1024L) {
            Long kiloSize = fileSize / 1024L;
            if (kiloSize < 1024L) {
                newFileSize = kiloSize;
                fileSizeUnits = "KB";
            } else {
                Long megaSize = kiloSize / 1024L;
                if (megaSize < 1024L) {
                    newFileSize = megaSize;
                    fileSizeUnits = "MB";
                } else {
                    Long gigaSize;
                    newFileSize = gigaSize = Long.valueOf(megaSize / 1024L);
                    fileSizeUnits = "GB";
                }
            }
        }
        return newFileSize + fileSizeUnits;
    }

    private static class AbsoluteFileSystemResourceLoader
    extends FileSystemResourceLoader {
        private AbsoluteFileSystemResourceLoader() {
        }

        protected Resource getResourceByPath(String path) {
            return new FileSystemResource(path);
        }
    }
}

