/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryBySQL;

public class RsQueryObject {
    private Query query;
    private ClassDescriptor cld;
    private boolean isSQLBased;

    public static RsQueryObject get(ClassDescriptor classDescriptor, Query query) {
        return new RsQueryObject(classDescriptor, query);
    }

    private RsQueryObject(ClassDescriptor classDescriptor, Query query) {
        this.query = query;
        this.cld = classDescriptor;
        if (query instanceof QueryBySQL) {
            this.isSQLBased = true;
        }
    }

    public ResultSetAndStatement performQuery(JdbcAccess jdbcAccess) {
        if (this.isSQLBased()) {
            return jdbcAccess.executeSQL(((QueryBySQL)this.query).getSql(), this.cld, true);
        }
        return jdbcAccess.executeQuery(this.query, this.cld);
    }

    public boolean usePaging() {
        return this.query.usePaging();
    }

    public int getStartIndex() {
        return this.query.getStartAtIndex();
    }

    public int getEndIndex() {
        return this.query.getEndAtIndex();
    }

    public ClassDescriptor getClassDescriptor() {
        return this.cld;
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean isSQLBased() {
        return this.isSQLBased;
    }

    public String getSQLBasedQuery() {
        if (this.isSQLBased()) {
            return ((QueryBySQL)this.query).getSql();
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + "[" + "query: " + this.query + ", class descriptor: " + this.cld.getClassNameOfObject() + "]";
    }
}

