/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.map;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kuali.coeus.common.questionnaire.framework.answer.Answer;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.s2s.map.ApplicantOrganization;
import org.kuali.coeus.propdev.impl.s2s.map.AttachmentMappingService;
import org.kuali.coeus.propdev.impl.s2s.map.Compliance;
import org.kuali.coeus.propdev.impl.s2s.map.PersonMappingService;
import org.kuali.coeus.propdev.impl.s2s.map.Project;
import org.kuali.coeus.propdev.impl.s2s.map.RenewalInformation;
import org.kuali.coeus.propdev.impl.s2s.map.S2sMappingService;
import org.kuali.coeus.propdev.impl.s2s.question.ProposalDevelopmentS2sModuleQuestionnaireBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="s2sMappingService")
public class S2sMappingServiceImpl
implements S2sMappingService {
    @Autowired
    @Qualifier(value="personMappingService")
    private PersonMappingService personMappingService;
    @Autowired
    @Qualifier(value="questionnaireAnswerService")
    private QuestionnaireAnswerService questionnaireAnswerService;
    @Autowired
    @Qualifier(value="attachmentMappingService")
    private AttachmentMappingService attachmentMappingService;

    @Override
    public Project toProject(ProposalDevelopmentDocumentContract pdDoc) {
        DevelopmentProposal proposal = (DevelopmentProposal)pdDoc.getDevelopmentProposal();
        List<AnswerHeader> questionnaireAnswers = this.questionnaireAnswerService.getQuestionnaireAnswer(new ProposalDevelopmentS2sModuleQuestionnaireBean(proposal));
        Project project = new Project();
        project.setTitle(proposal.getTitle());
        project.setApplicantOrganization(this.getApplicantOrganization(proposal));
        project.setAwardNumber(proposal.getCurrentAwardNumber());
        project.setCompliance(this.getCompliance(questionnaireAnswers));
        project.setRenewalInformation(this.getRenewalInformation(questionnaireAnswers));
        project.setAttachments(this.attachmentMappingService.getAttachments(proposal));
        return project;
    }

    private ApplicantOrganization getApplicantOrganization(DevelopmentProposalContract proposal) {
        ApplicantOrganization applicantOrganization = new ApplicantOrganization();
        ProposalSiteContract proposalSite = proposal.getApplicantOrganization();
        applicantOrganization.setName(proposalSite.getLocationName());
        applicantOrganization.setHumanSubjectsAssuranceNumber(proposalSite.getOrganization().getHumanSubAssurance());
        applicantOrganization.setAuthorizedRepresentative(this.getPersonMappingService().getAor(proposal));
        return applicantOrganization;
    }

    private Compliance getCompliance(List<AnswerHeader> questionnaireAnswers) {
        Compliance compliance = new Compliance();
        this.getAnswerAsBoolean(questionnaireAnswers, 145).ifPresent(compliance::setVertebrateAnimals);
        this.getAnswerAsBoolean(questionnaireAnswers, 146).ifPresent(compliance::setAnimalEuthanasiaIndicator);
        this.getAnswerAsBoolean(questionnaireAnswers, 146).ifPresent(compliance::setAVMAConsistentIndicator);
        this.getQuestionAnswer(questionnaireAnswers, 148).ifPresent(compliance::setEuthanasiaMethodDescription);
        this.getAnswerAsBoolean(questionnaireAnswers, 5).ifPresent(compliance::setIsHumanStemCellsInvolved);
        this.getAnswerAsBoolean(questionnaireAnswers, 6).ifPresent(compliance::setStemCellsIndicator);
        this.getQuestionAnswers(questionnaireAnswers, 149).ifPresent(compliance::setCellLines);
        this.getAnswerAsBoolean(questionnaireAnswers, -10145).ifPresent(compliance::setIsHumanFetalTissueInvolved);
        return compliance;
    }

    private RenewalInformation getRenewalInformation(List<AnswerHeader> questionnaireAnswers) {
        RenewalInformation renewal = new RenewalInformation();
        this.getAnswerAsBoolean(questionnaireAnswers, 118).ifPresent(renewal::setIsRenewalApplication);
        this.getAnswerAsBoolean(questionnaireAnswers, 120).ifPresent(renewal::setIsPreviouslyReported);
        this.getAnswerAsBoolean(questionnaireAnswers, 119).ifPresent(renewal::setIsInventionsAndPatents);
        this.getAnswerAsBoolean(questionnaireAnswers, 114).ifPresent(renewal::setIsChangeOfPDPI);
        this.getAnswerAsBoolean(questionnaireAnswers, 116).ifPresent(renewal::setIsChangeOfInstitution);
        this.getQuestionAnswer(questionnaireAnswers, 117).ifPresent(renewal::setFormerInstitutionName);
        this.getQuestionAnswer(questionnaireAnswers, 115).map(Integer::parseInt).flatMap(this.personMappingService::fromRolodex).ifPresent(renewal::setFormerPD);
        return renewal;
    }

    private Optional<Boolean> getAnswerAsBoolean(Collection<AnswerHeader> answerHeaders, int questionId) {
        return this.getQuestionAnswer(answerHeaders, questionId).map("Y"::equals);
    }

    private Optional<String> getQuestionAnswer(Collection<AnswerHeader> answerHeaders, int questionId) {
        return answerHeaders.stream().flatMap(header -> header.getAnswers().stream()).filter(answer -> answer.getQuestionSeqId().equals(questionId)).filter(answer -> "Y".equals(answer.getMatchedChild())).findFirst().map(Answer::getAnswer);
    }

    private Optional<List<String>> getQuestionAnswers(Collection<AnswerHeader> answerHeaders, int questionId) {
        List answers = answerHeaders.stream().flatMap(header -> header.getAnswers().stream()).filter(answer -> answer.getQuestionSeqId().equals(questionId)).filter(answer -> "Y".equals(answer.getMatchedChild())).map(Answer::getAnswer).collect(Collectors.toList());
        return answers.isEmpty() ? Optional.empty() : Optional.of(answers);
    }

    public PersonMappingService getPersonMappingService() {
        return this.personMappingService;
    }

    public void setPersonMappingService(PersonMappingService personMappingService) {
        this.personMappingService = personMappingService;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    public AttachmentMappingService getAttachmentMappingService() {
        return this.attachmentMappingService;
    }

    public void setAttachmentMappingService(AttachmentMappingService attachmentMappingService) {
        this.attachmentMappingService = attachmentMappingService;
    }
}

