/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Link;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ViewModelUtils;
import org.kuali.rice.krad.uif.widget.WidgetBase;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.UrlFactory;

@BeanTag(name="inquiry", parent="Uif-Inquiry")
public class Inquiry
extends WidgetBase {
    private static final long serialVersionUID = -2154388007867302901L;
    private static final Logger LOG = LogManager.getLogger(Inquiry.class);
    public static final String INQUIRY_TITLE_PREFIX = "title.inquiry.url.actiontext";
    public static final String INQUIRY_TITLE_POSTFIX = "title.inquiry.url.value.prependtext";
    private String baseInquiryUrl;
    private String dataObjectClassName;
    private String viewName;
    private Map<String, String> inquiryParameters = new HashMap<String, String>();
    private Link inquiryLink;
    private Action directInquiryAction;
    private boolean enableDirectInquiry;
    private boolean adjustInquiryParameters;
    private BindingInfo fieldBindingInfo;
    private boolean parentReadOnly;

    @Override
    public void afterEvaluateExpression() {
        super.afterEvaluateExpression();
        if (this.getReadOnly() == null) {
            Component parent = ViewLifecycle.getPhase().getParent();
            this.setReadOnly(parent == null ? null : parent.getReadOnly());
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (!this.isRender()) {
            return;
        }
        this.setRender(false);
        if (parent instanceof Component) {
            this.setParentReadOnly(((Component)parent).getReadOnly());
        }
        if (!this.isParentReadOnly() && parent instanceof InputField) {
            if (!this.enableDirectInquiry) {
                return;
            }
            if (StringUtils.isBlank((String)this.getDataObjectClassName()) || this.getInquiryParameters() == null || this.getInquiryParameters().isEmpty()) {
                this.adjustInquiryParameters = true;
                this.fieldBindingInfo = ((InputField)parent).getBindingInfo();
            }
        }
        if (parent instanceof DataField) {
            this.setupLink(model, (DataField)parent);
        }
        if (this.isRender() && !this.isParentReadOnly() && parent instanceof InputField && this.enableDirectInquiry) {
            ((InputField)parent).addPostInputAddon(this.directInquiryAction);
        }
    }

    private void setupLink(Object model, DataField field) {
        String propertyName = field.getBindingInfo().getBindingName();
        if (StringUtils.isNotBlank((String)this.getDataObjectClassName()) && this.getInquiryParameters() != null && !this.getInquiryParameters().isEmpty()) {
            Class<?> inquiryObjectClass;
            try {
                inquiryObjectClass = Class.forName(this.getDataObjectClassName());
            }
            catch (ClassNotFoundException e) {
                LOG.error("Unable to get class for: " + this.getDataObjectClassName());
                throw new RuntimeException(e);
            }
            this.updateInquiryParameters(field.getBindingInfo());
            this.buildInquiryLink(model, propertyName, inquiryObjectClass, this.getInquiryParameters());
        } else {
            ViewLifecycle viewLifecycle = ViewLifecycle.getActiveLifecycle();
            Object parentObject = ViewModelUtils.getParentObjectForMetadata(viewLifecycle.getView(), model, field);
            if (parentObject != null) {
                viewLifecycle.getHelper().buildInquiryLink(parentObject, propertyName, this);
            }
        }
    }

    public void updateInquiryParameters(BindingInfo bindingInfo) {
        HashMap<String, String> adjustedInquiryParameters = new HashMap<String, String>();
        for (Map.Entry<String, String> stringEntry : this.inquiryParameters.entrySet()) {
            String toField = stringEntry.getValue();
            String adjustedFromFieldPath = bindingInfo.getPropertyAdjustedBindingPath(stringEntry.getKey());
            adjustedInquiryParameters.put(adjustedFromFieldPath, toField);
        }
        this.inquiryParameters = adjustedInquiryParameters;
    }

    public void buildInquiryLink(Object dataObject, String propertyName, Class<?> inquiryObjectClass, Map<String, String> inquiryParams) {
        MessageService messageService = KRADServiceLocatorWeb.getMessageService();
        Properties urlParameters = new Properties();
        HashMap<String, String> inquiryKeyValues = new HashMap<String, String>();
        urlParameters.setProperty("dataObjectClassName", inquiryObjectClass.getName());
        urlParameters.setProperty("methodToCall", "start");
        if (StringUtils.isNotBlank((String)this.viewName)) {
            urlParameters.setProperty("viewName", this.viewName);
        }
        if (this.isParentReadOnly()) {
            for (Map.Entry<String, String> inquiryParameter : inquiryParams.entrySet()) {
                String parameterName = inquiryParameter.getKey();
                String parameterPropertyName = inquiryParameter.getValue();
                Object parameterValue = StringUtils.defaultString((String)ObjectPropertyUtils.getPropertyValueAsText(dataObject, parameterName));
                boolean isSecure = KRADUtils.isSecure(propertyName, dataObject.getClass());
                if (!isSecure) {
                    inquiryKeyValues.put(parameterPropertyName, (String)parameterValue);
                }
                if (isSecure) {
                    try {
                        if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                            parameterValue = CoreApiServiceLocator.getEncryptionService().encrypt(parameterValue) + "(&^#&)";
                        }
                    }
                    catch (GeneralSecurityException e) {
                        String message = "Unable to encrypt value for property name: " + parameterPropertyName;
                        LOG.error(message);
                        throw new RuntimeException(message, e);
                    }
                }
                urlParameters.put(parameterPropertyName, parameterValue);
            }
            ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(inquiryObjectClass);
            String inquiryUrl = responsibleModuleService != null && responsibleModuleService.isExternalizable(inquiryObjectClass) ? responsibleModuleService.getExternalizableDataObjectInquiryUrl(inquiryObjectClass, urlParameters) : UrlFactory.parameterizeUrl((String)this.getBaseInquiryUrl(), (Properties)urlParameters);
            this.getInquiryLink().setHref(inquiryUrl);
            this.getInquiryLink().setTitle(this.createTitleText(inquiryObjectClass, inquiryKeyValues));
            this.setRender(true);
        } else {
            String inquiryUrl = UrlFactory.parameterizeUrl((String)this.getBaseInquiryUrl(), (Properties)urlParameters);
            StringBuilder paramMapStringBuilder = new StringBuilder();
            for (Map.Entry<String, String> inquiryParameter : inquiryParams.entrySet()) {
                String inquiryParameterFrom = inquiryParameter.getKey();
                if (this.adjustInquiryParameters && this.fieldBindingInfo != null) {
                    inquiryParameterFrom = this.fieldBindingInfo.getPropertyAdjustedBindingPath(inquiryParameterFrom);
                }
                ViewLifecycle viewLifecycle = ViewLifecycle.getActiveLifecycle();
                if (!viewLifecycle.getViewPostMetadata().getAllRenderedPropertyPaths().contains(inquiryParameterFrom.toString())) {
                    this.setRender(false);
                    return;
                }
                paramMapStringBuilder.append(inquiryParameterFrom);
                paramMapStringBuilder.append(":");
                paramMapStringBuilder.append(inquiryParameter.getValue());
                paramMapStringBuilder.append(",");
            }
            String paramMapString = StringUtils.removeEnd((String)paramMapStringBuilder.toString(), (String)",");
            if (!this.getInquiryLink().isOpenInDialog()) {
                String title = this.getTitle();
                if (StringUtils.isNotBlank((String)title)) {
                    this.setTitle(title + " - " + messageService.getMessageText("accessibility.link.opensTab"));
                } else {
                    this.setTitle(messageService.getMessageText("accessibility.link.opensTab"));
                }
            }
            StringBuilder onClickScript = new StringBuilder("showDirectInquiry(\"");
            onClickScript.append(inquiryUrl);
            onClickScript.append("\", \"");
            onClickScript.append(paramMapString);
            onClickScript.append("\", ");
            onClickScript.append(this.getInquiryLink().isOpenInDialog());
            onClickScript.append(", \"");
            onClickScript.append(this.getInquiryLink().getLinkDialogId());
            onClickScript.append("\");");
            this.directInquiryAction.setPerformDirtyValidation(false);
            Object actionScript = "";
            if (StringUtils.isNotEmpty((String)this.directInquiryAction.getActionScript())) {
                actionScript = (String)actionScript + this.directInquiryAction.getActionScript();
            }
            this.directInquiryAction.setActionScript((String)actionScript + onClickScript.toString());
            this.setRender(true);
        }
    }

    public String createTitleText(Class<?> dataObjectClass, Map<String, String> inquiryKeyValues) {
        String titleUrlPrependText;
        DataObjectEntry dataObjectEntry;
        String dataObjectLabel;
        if (StringUtils.isNotBlank((String)this.getTitle())) {
            return this.getTitle();
        }
        ArrayList<String> titleTexts = new ArrayList<String>();
        String titlePrefix = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString(INQUIRY_TITLE_PREFIX);
        if (StringUtils.isNotBlank((String)titlePrefix)) {
            titleTexts.add(titlePrefix);
        }
        String string = dataObjectLabel = (dataObjectEntry = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDataObjectEntry(dataObjectClass.getName())) != null ? dataObjectEntry.getObjectLabel() : null;
        if (StringUtils.isNotBlank((String)dataObjectLabel)) {
            titleTexts.add(dataObjectLabel);
        }
        if (StringUtils.isNotBlank((String)(titleUrlPrependText = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("title.action.url.value.prependtext"))) && !inquiryKeyValues.isEmpty()) {
            titleTexts.add(titleUrlPrependText);
        }
        String titleText = StringUtils.defaultIfBlank((String)StringUtils.join(titleTexts, (String)" "), (String)"");
        return KRADUtils.buildAttributeTitleString(titleText, dataObjectClass, inquiryKeyValues);
    }

    @BeanTagAttribute
    public String getBaseInquiryUrl() {
        return this.baseInquiryUrl;
    }

    public void setBaseInquiryUrl(String baseInquiryUrl) {
        this.baseInquiryUrl = baseInquiryUrl;
    }

    @BeanTagAttribute
    public String getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(String dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    @BeanTagAttribute
    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @BeanTagAttribute
    public Map<String, String> getInquiryParameters() {
        return this.inquiryParameters;
    }

    public void setInquiryParameters(Map<String, String> inquiryParameters) {
        this.inquiryParameters = inquiryParameters;
    }

    @BeanTagAttribute
    public Link getInquiryLink() {
        return this.inquiryLink;
    }

    public void setInquiryLink(Link inquiryLink) {
        this.inquiryLink = inquiryLink;
    }

    @BeanTagAttribute
    public Action getDirectInquiryAction() {
        return this.directInquiryAction;
    }

    public void setDirectInquiryAction(Action directInquiryAction) {
        this.directInquiryAction = directInquiryAction;
    }

    @BeanTagAttribute
    public boolean isEnableDirectInquiry() {
        return this.enableDirectInquiry;
    }

    public void setEnableDirectInquiry(boolean enableDirectInquiry) {
        this.enableDirectInquiry = enableDirectInquiry;
    }

    protected boolean isParentReadOnly() {
        return this.parentReadOnly;
    }

    protected void setParentReadOnly(boolean parentReadOnly) {
        this.parentReadOnly = parentReadOnly;
    }

    public boolean isAdjustInquiryParameters() {
        return this.adjustInquiryParameters;
    }

    protected void setAdjustInquiryParameters(boolean adjustInquiryParameters) {
        this.adjustInquiryParameters = adjustInquiryParameters;
    }

    protected void setFieldBindingInfo(BindingInfo fieldBindingInfo) {
        this.fieldBindingInfo = fieldBindingInfo;
    }
}

