/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.impex.xml;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.impex.xml.XmlDoc;
import org.kuali.rice.core.api.impex.xml.XmlDocCollection;
import org.kuali.rice.core.api.impex.xml.XmlIngesterService;
import org.kuali.rice.core.framework.impex.xml.XmlImpexRegistry;
import org.kuali.rice.core.framework.impex.xml.XmlLoader;
import org.kuali.rice.core.impl.impex.xml.ClassLoaderEntityResolver;
import org.kuali.rice.core.impl.impex.xml.XmlDigesterService;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlIngesterServiceImpl
implements XmlIngesterService {
    private static final Logger LOG = LogManager.getLogger(XmlIngesterServiceImpl.class);
    private EntityResolver resolver = new ClassLoaderEntityResolver();
    private XmlDigesterService digesterService;
    private XmlImpexRegistry xmlImpexRegistry;
    private boolean validate = true;

    public void setXmlDigesterService(XmlDigesterService digesterService) {
        this.digesterService = digesterService;
    }

    public void setXmlImpexRegistry(XmlImpexRegistry xmlImpexRegistry) {
        this.xmlImpexRegistry = xmlImpexRegistry;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    public void setValidate(boolean b) {
        this.validate = b;
    }

    private static void addProcessingException(XmlDoc xmlDoc, String message, Throwable t) {
        Object msg = xmlDoc.getProcessingMessage();
        if (msg == null) {
            msg = "";
        }
        msg = (String)msg + message + "\n" + ExceptionUtils.getFullStackTrace((Throwable)t);
        xmlDoc.setProcessingMessage((String)msg);
    }

    private static void validate(final XmlDoc xmlDoc, EntityResolver resolver) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(true);
        dbf.setNamespaceAware(true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver(resolver);
        db.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException se) {
                LOG.warn("Warning parsing xml doc " + xmlDoc, (Throwable)se);
                XmlIngesterServiceImpl.addProcessingException(xmlDoc, "Warning parsing xml doc " + xmlDoc, se);
            }

            @Override
            public void error(SAXParseException se) throws SAXException {
                LOG.error("Error parsing xml doc " + xmlDoc, (Throwable)se);
                XmlIngesterServiceImpl.addProcessingException(xmlDoc, "Error parsing xml doc " + xmlDoc, se);
                throw se;
            }

            @Override
            public void fatalError(SAXParseException se) throws SAXException {
                LOG.error("Fatal error parsing xml doc " + xmlDoc, (Throwable)se);
                XmlIngesterServiceImpl.addProcessingException(xmlDoc, "Fatal error parsing xml doc " + xmlDoc, se);
                throw se;
            }
        });
        db.parse(xmlDoc.getStream());
    }

    private static void validate(List<XmlDocCollection> collections, EntityResolver resolver, Set<XmlDocCollection> successful, Set<XmlDocCollection> failed) {
        for (XmlDocCollection collection : collections) {
            for (XmlDoc xmlDoc : collection.getXmlDocs()) {
                try {
                    XmlIngesterServiceImpl.validate(xmlDoc, resolver);
                }
                catch (Exception e) {
                    LOG.error("Error validating doc: " + xmlDoc, (Throwable)e);
                    XmlIngesterServiceImpl.addProcessingException(xmlDoc, "Error validating doc: " + xmlDoc, e);
                    failed.add(collection);
                }
            }
            successful.add(collection);
        }
    }

    private void ingest(XmlLoader xmlLoader, Collection<XmlDocCollection> xmlDocCollections, String principalId, Set<Object> successful, Set<XmlDocCollection> failed) {
        for (XmlDocCollection xmlDocCollection : xmlDocCollections) {
            if (failed.contains(xmlDocCollection)) {
                LOG.debug("Skipping " + xmlDocCollection.getFile() + "...");
                continue;
            }
            try {
                this.digesterService.digest(xmlLoader, xmlDocCollection, principalId);
            }
            catch (Exception e) {
                LOG.error("Caught Exception loading xml data from " + xmlDocCollection.getFile() + ".  Will move associated file to problem dir.", (Throwable)e);
                failed.add(xmlDocCollection);
            }
        }
    }

    public Collection<XmlDocCollection> ingest(List<XmlDocCollection> collections) throws Exception {
        return this.ingest(collections, null);
    }

    private void ingestThroughOrderedLoaders(Collection<XmlDocCollection> xmlDocCollections, String principalId, Set<Object> successful, Set<XmlDocCollection> failed) {
        LOG.debug("Ingesting through ordered XmlLoaders");
        List xmlLoaders = this.xmlImpexRegistry.getLoaders();
        for (XmlLoader xmlLoader : xmlLoaders) {
            LOG.debug("Ingesting through ordered XmlLoader: " + xmlLoader);
            this.ingest(xmlLoader, xmlDocCollections, principalId, successful, failed);
        }
    }

    public Collection<XmlDocCollection> ingest(List<XmlDocCollection> collections, String principalId) {
        LinkedHashSet<XmlDocCollection> successful;
        LinkedHashSet<XmlDocCollection> failed = new LinkedHashSet<XmlDocCollection>();
        if (this.validate) {
            successful = new LinkedHashSet<XmlDocCollection>();
            XmlIngesterServiceImpl.validate(collections, this.resolver, successful, failed);
            collections = new LinkedList<XmlDocCollection>(successful);
        }
        successful = new LinkedHashSet();
        this.ingestThroughOrderedLoaders(collections, principalId, successful, failed);
        return failed;
    }
}

