/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.document.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.document.node.RouteNodeInstanceContract;
import org.kuali.rice.kew.api.document.node.RouteNodeInstanceState;
import org.kuali.rice.kew.api.document.node.RouteNodeInstanceStateContract;
import org.w3c.dom.Element;

@XmlRootElement(name="routeNodeInstance")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="RouteNodeInstanceType", propOrder={"id", "name", "state", "documentId", "branchId", "routeNodeId", "processId", "active", "complete", "initial", "nextNodeInstances", "_futureElements"})
public final class RouteNodeInstance
extends AbstractDataTransferObject
implements RouteNodeInstanceContract {
    @XmlElement(name="name", required=false)
    private final String name;
    @XmlElementWrapper(name="state", required=false)
    @XmlElement(name="routeNodeInstanceState", required=false)
    private final List<RouteNodeInstanceState> state;
    @XmlElement(name="documentId", required=false)
    private final String documentId;
    @XmlElement(name="branchId", required=false)
    private final String branchId;
    @XmlElement(name="routeNodeId", required=false)
    private final String routeNodeId;
    @XmlElement(name="processId", required=false)
    private final String processId;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="complete", required=false)
    private final boolean complete;
    @XmlElement(name="initial", required=false)
    private final boolean initial;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElementWrapper(name="nextNodeInstances", required=false)
    @XmlElement(name="nextNodeInstance", required=false)
    private final List<RouteNodeInstance> nextNodeInstances;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private RouteNodeInstance() {
        this.name = null;
        this.state = null;
        this.documentId = null;
        this.branchId = null;
        this.routeNodeId = null;
        this.processId = null;
        this.active = false;
        this.complete = false;
        this.initial = false;
        this.id = null;
        this.nextNodeInstances = null;
    }

    private RouteNodeInstance(Builder builder) {
        this.name = builder.getName();
        if (builder.getState() != null) {
            ArrayList<RouteNodeInstanceState> states = new ArrayList<RouteNodeInstanceState>();
            for (RouteNodeInstanceState.Builder stateBuilder : builder.getState()) {
                states.add(stateBuilder.build());
            }
            this.state = states;
        } else {
            this.state = Collections.emptyList();
        }
        if (builder.getNextNodeInstances() != null) {
            ArrayList<RouteNodeInstance> nextInstances = new ArrayList<RouteNodeInstance>();
            for (Builder instance : builder.getNextNodeInstances()) {
                nextInstances.add(instance.build());
            }
            this.nextNodeInstances = nextInstances;
        } else {
            this.nextNodeInstances = Collections.emptyList();
        }
        this.documentId = builder.getDocumentId();
        this.branchId = builder.getBranchId();
        this.routeNodeId = builder.getRouteNodeId();
        this.processId = builder.getProcessId();
        this.active = builder.isActive();
        this.complete = builder.isComplete();
        this.initial = builder.isInitial();
        this.id = builder.getId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<RouteNodeInstanceState> getState() {
        return this.state;
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    @Override
    public String getBranchId() {
        return this.branchId;
    }

    @Override
    public String getRouteNodeId() {
        return this.routeNodeId;
    }

    @Override
    public String getProcessId() {
        return this.processId;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean isInitial() {
        return this.initial;
    }

    public String getId() {
        return this.id;
    }

    public List<RouteNodeInstance> getNextNodeInstances() {
        return this.nextNodeInstances;
    }

    static class Elements {
        static final String NAME = "name";
        static final String STATE = "state";
        static final String ROUTE_NODE_INSTANCE_STATE = "routeNodeInstanceState";
        static final String DOCUMENT_ID = "documentId";
        static final String BRANCH_ID = "branchId";
        static final String ROUTE_NODE_ID = "routeNodeId";
        static final String PROCESS_ID = "processId";
        static final String ACTIVE = "active";
        static final String COMPLETE = "complete";
        static final String INITIAL = "initial";
        static final String ID = "id";
        static final String NEXT_NODE_INSTANCES = "nextNodeInstances";
        static final String NEXT_NODE_INSTANCE = "nextNodeInstance";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "routeNodeInstance";
        static final String TYPE_NAME = "RouteNodeInstanceType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    RouteNodeInstanceContract {
        private String name;
        private List<RouteNodeInstanceState.Builder> state;
        private String documentId;
        private String branchId;
        private String routeNodeId;
        private String processId;
        private boolean active;
        private boolean complete;
        private boolean initial;
        private String id;
        private List<Builder> nextNodeInstances;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(RouteNodeInstanceContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setName(contract.getName());
            if (contract.getState() != null) {
                ArrayList<RouteNodeInstanceState.Builder> stateBuilders = new ArrayList<RouteNodeInstanceState.Builder>();
                for (RouteNodeInstanceStateContract routeNodeInstanceStateContract : contract.getState()) {
                    stateBuilders.add(RouteNodeInstanceState.Builder.create(routeNodeInstanceStateContract));
                }
                builder.setState(stateBuilders);
            }
            builder.setDocumentId(contract.getDocumentId());
            builder.setBranchId(contract.getBranchId());
            builder.setRouteNodeId(contract.getRouteNodeId());
            builder.setProcessId(contract.getProcessId());
            builder.setActive(contract.isActive());
            builder.setComplete(contract.isComplete());
            builder.setInitial(contract.isInitial());
            builder.setId(contract.getId());
            if (contract.getNextNodeInstances() != null) {
                ArrayList<Builder> instanceBuilders = new ArrayList<Builder>();
                for (RouteNodeInstanceContract routeNodeInstanceContract : contract.getNextNodeInstances()) {
                    instanceBuilders.add(Builder.create(routeNodeInstanceContract));
                }
                builder.setNextNodeInstances(instanceBuilders);
            }
            return builder;
        }

        public RouteNodeInstance build() {
            return new RouteNodeInstance(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public List<RouteNodeInstanceState.Builder> getState() {
            return this.state;
        }

        @Override
        public String getDocumentId() {
            return this.documentId;
        }

        @Override
        public String getBranchId() {
            return this.branchId;
        }

        @Override
        public String getRouteNodeId() {
            return this.routeNodeId;
        }

        @Override
        public String getProcessId() {
            return this.processId;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        public boolean isInitial() {
            return this.initial;
        }

        public String getId() {
            return this.id;
        }

        public List<Builder> getNextNodeInstances() {
            return this.nextNodeInstances;
        }

        public void setNextNodeInstances(List<Builder> nextNodeInstances) {
            this.nextNodeInstances = Collections.unmodifiableList(nextNodeInstances);
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setState(List<RouteNodeInstanceState.Builder> state) {
            this.state = state;
        }

        public void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public void setBranchId(String branchId) {
            this.branchId = branchId;
        }

        public void setRouteNodeId(String routeNodeId) {
            this.routeNodeId = routeNodeId;
        }

        public void setProcessId(String processId) {
            this.processId = processId;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setComplete(boolean complete) {
            this.complete = complete;
        }

        public void setInitial(boolean initial) {
            this.initial = initial;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

