/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.locking;

import java.util.Map;
import org.apache.commons.transaction.locking.GenericLock;
import org.apache.commons.transaction.locking.GenericLockManager;
import org.apache.commons.transaction.locking.LockException;
import org.apache.commons.transaction.locking.MultiLevelLock;
import org.apache.commons.transaction.util.LoggerFacade;
import org.apache.ojb.broker.locking.LockRuntimeException;

class CommonsOJBLockManager
extends GenericLockManager {
    static final int COMMON_READ_LOCK = 101;
    static final int COMMON_WRITE_LOCK = 107;
    static final int COMMON_UPGRADE_LOCK = 113;

    public CommonsOJBLockManager(LoggerFacade loggerFacade, long l, long l2) throws IllegalArgumentException {
        super(1, loggerFacade, l, l2);
    }

    public boolean tryLock(Object object, Object object2, int n, boolean bl) {
        return this.tryLock(object, object2, n, bl, null);
    }

    public boolean tryLock(Object object, Object object2, int n, boolean bl, Object object3) {
        this.timeoutCheck(object);
        OJBLock oJBLock = this.atomicGetOrCreateLock(object2, object3);
        boolean bl2 = oJBLock.tryLock(object, n, bl ? 1 : 0, false);
        if (bl2) {
            this.addOwner(object, oJBLock);
        }
        return bl2;
    }

    public void lock(Object object, Object object2, int n, int n2, boolean bl, long l) throws LockException {
        this.lock(object, object2, n, n2, bl, l, null);
    }

    public void lock(Object object, Object object2, int n, int n2, boolean bl, long l, Object object3) throws LockException {
        this.timeoutCheck(object);
        OJBLock oJBLock = this.atomicGetOrCreateLock(object2, object3);
        super.doLock((GenericLock)oJBLock, object, object2, n, n2, bl, l);
    }

    public MultiLevelLock atomicGetOrCreateLock(Object object) {
        return this.atomicGetOrCreateLock(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OJBLock atomicGetOrCreateLock(Object object, Object object2) {
        Map map = this.globalLocks;
        synchronized (map) {
            MultiLevelLock multiLevelLock = this.getLock(object);
            if (multiLevelLock == null) {
                multiLevelLock = this.createLock(object, object2);
            }
            return (OJBLock)multiLevelLock;
        }
    }

    protected GenericLock createLock(Object object) {
        return this.createLock(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GenericLock createLock(Object object, Object object2) {
        Map map = this.globalLocks;
        synchronized (map) {
            if (object2 != null) {
                OJBLock oJBLock = this.createIsolationLevel(object, object2, this.logger);
                this.globalLocks.put(object, oJBLock);
                return oJBLock;
            }
            GenericLock genericLock = new GenericLock(object, this.maxLockLevel, this.logger);
            this.globalLocks.put(object, genericLock);
            return genericLock;
        }
    }

    public OJBLock createIsolationLevel(Object object, Object object2, LoggerFacade loggerFacade) {
        RepeadableReadsLock repeadableReadsLock = null;
        switch ((Integer)object2) {
            case 2: {
                repeadableReadsLock = new ReadUncommittedLock(object, loggerFacade);
                break;
            }
            case 3: {
                repeadableReadsLock = new ReadCommitedLock(object, loggerFacade);
                break;
            }
            case 5: {
                repeadableReadsLock = new RepeadableReadsLock(object, loggerFacade);
                break;
            }
            case 7: {
                repeadableReadsLock = new SerializeableLock(object, loggerFacade);
                break;
            }
            case 4: {
                throw new LockRuntimeException("Optimistic locking must be handled on top of this class");
            }
            default: {
                throw new LockRuntimeException("Unknown lock isolation level specified");
            }
        }
        return repeadableReadsLock;
    }

    int mapLockLevelDependendOnIsolationLevel(Integer n, int n2) {
        int n3 = 0;
        switch (n) {
            case 2: {
                n3 = ReadUncommittedLock.mapLockLevel(n2);
                break;
            }
            case 3: {
                n3 = ReadCommitedLock.mapLockLevel(n2);
                break;
            }
            case 5: {
                n3 = RepeadableReadsLock.mapLockLevel(n2);
                break;
            }
            case 7: {
                n3 = SerializeableLock.mapLockLevel(n2);
                break;
            }
            case 4: {
                throw new LockRuntimeException("Optimistic locking must be handled on top of this class");
            }
            default: {
                throw new LockRuntimeException("Unknown lock isolation level specified");
            }
        }
        return n3;
    }

    static final class SerializeableLock
    extends ReadUncommittedLock {
        public SerializeableLock(Object object, LoggerFacade loggerFacade) {
            super(object, loggerFacade);
        }

        @Override
        protected boolean isCompatible(int n, int n2) {
            return n2 <= 0;
        }
    }

    static class RepeadableReadsLock
    extends OJBLock {
        static final int NO_LOCK = 0;
        static final int READ_LOCK = 1;
        static final int UPGRADE_LOCK = 2;
        static final int WRITE_LOCK = 3;

        public RepeadableReadsLock(Object object, LoggerFacade loggerFacade) {
            super(object, 3, loggerFacade);
        }

        static int mapLockLevel(int n) {
            int n2 = 0;
            switch (n) {
                case 101: {
                    n2 = 1;
                    break;
                }
                case 113: {
                    n2 = 2;
                    break;
                }
                case 107: {
                    n2 = 3;
                    break;
                }
                default: {
                    throw new LockRuntimeException("Unknown common lock type: " + n);
                }
            }
            return n2;
        }

        @Override
        public boolean readLock(Object object, long l) throws InterruptedException {
            return this.acquire(object, 1, false, 1, false, l);
        }

        @Override
        public boolean writeLock(Object object, long l) throws InterruptedException {
            return this.acquire(object, 3, true, 1, false, l);
        }

        @Override
        public boolean upgradeLock(Object object, long l) throws InterruptedException {
            return this.acquire(object, 2, true, 1, true, l);
        }

        @Override
        public boolean hasRead(Object object) {
            return this.has(object, 1);
        }

        @Override
        public boolean hasWrite(Object object) {
            return this.has(object, 3);
        }

        @Override
        public boolean hasUpgrade(Object object) {
            return this.has(object, 2);
        }
    }

    static final class ReadCommitedLock
    extends RepeadableReadsLock {
        public ReadCommitedLock(Object object, LoggerFacade loggerFacade) {
            super(object, loggerFacade);
        }

        protected boolean isCompatible(int n, int n2) {
            if (n2 == 1) {
                return true;
            }
            return super.isCompatible(n, n2);
        }
    }

    static class ReadUncommittedLock
    extends RepeadableReadsLock {
        public ReadUncommittedLock(Object object, LoggerFacade loggerFacade) {
            super(object, loggerFacade);
        }

        protected boolean isCompatible(int n, int n2) {
            if (n2 == 1 || n == 1) {
                return true;
            }
            return super.isCompatible(n, n2);
        }
    }

    static abstract class OJBLock
    extends GenericLock {
        public OJBLock(Object object, int n, LoggerFacade loggerFacade) {
            super(object, n, loggerFacade);
        }

        protected boolean tryLock(Object object, int n, int n2, boolean bl) {
            return super.tryLock(object, n, n2, bl);
        }

        abstract boolean hasRead(Object var1);

        abstract boolean hasWrite(Object var1);

        abstract boolean hasUpgrade(Object var1);

        abstract boolean readLock(Object var1, long var2) throws InterruptedException;

        abstract boolean writeLock(Object var1, long var2) throws InterruptedException;

        abstract boolean upgradeLock(Object var1, long var2) throws InterruptedException;
    }
}

