/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.messages.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.messages.Message;
import org.kuali.rice.krad.messages.MessageProvider;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;

public class ResourceMessageProvider
implements MessageProvider {
    private static final String COMPONENT_PLACEHOLDER_BEGIN = "@cmp{";
    private static final String COMPONENT_PLACEHOLDER_END = "}";
    protected Map<String, List<ResourceBundle>> cachedResourceBundles = new HashMap<String, List<ResourceBundle>>();

    @Override
    public Message getMessage(String namespace, String component, String key, String locale) {
        Message message = null;
        List<ResourceBundle> bundles = this.getCachedResourceBundles(namespace, locale);
        String messageText = null;
        for (ResourceBundle bundle : bundles) {
            String resourceKey;
            if (bundle.containsKey(resourceKey = COMPONENT_PLACEHOLDER_BEGIN + component + COMPONENT_PLACEHOLDER_END + key)) {
                messageText = bundle.getString(resourceKey);
                continue;
            }
            if (!"All".equals(component) || !bundle.containsKey(key)) continue;
            messageText = bundle.getString(key);
        }
        if (StringUtils.isNotBlank(messageText)) {
            message = this.buildMessage(namespace, component, key, messageText, locale);
        }
        return message;
    }

    @Override
    public Collection<Message> getAllMessagesForComponent(String namespace, String component, String locale) {
        List<ResourceBundle> bundles = this.getCachedResourceBundles(namespace, locale);
        HashMap<String, Message> messagesByKey = new HashMap<String, Message>();
        for (ResourceBundle bundle : bundles) {
            Enumeration<String> resourceKeys = bundle.getKeys();
            while (resourceKeys.hasMoreElements()) {
                String resourceKey = resourceKeys.nextElement();
                boolean match = false;
                if (StringUtils.contains((String)resourceKey, (String)(COMPONENT_PLACEHOLDER_BEGIN + component + COMPONENT_PLACEHOLDER_END))) {
                    match = true;
                } else if ("All".equals(component) && !StringUtils.contains((String)resourceKey, (String)COMPONENT_PLACEHOLDER_BEGIN)) {
                    match = true;
                }
                if (!match) continue;
                String messageText = bundle.getString(resourceKey);
                resourceKey = this.cleanResourceKey(resourceKey);
                Message message = this.buildMessage(namespace, component, resourceKey, messageText, locale);
                messagesByKey.put(resourceKey, message);
            }
        }
        return messagesByKey.values();
    }

    protected String cleanResourceKey(String resourceKey) {
        String cleanedKey = resourceKey;
        String component = StringUtils.substringBetween((String)cleanedKey, (String)COMPONENT_PLACEHOLDER_BEGIN, (String)COMPONENT_PLACEHOLDER_END);
        if (StringUtils.isNotBlank((String)component)) {
            cleanedKey = StringUtils.remove((String)cleanedKey, (String)(COMPONENT_PLACEHOLDER_BEGIN + component + COMPONENT_PLACEHOLDER_END));
        }
        return cleanedKey;
    }

    protected Message buildMessage(String namespace, String component, String key, String messageText, String locale) {
        Message message = new Message();
        message.setNamespaceCode(namespace);
        message.setComponentCode(component);
        key = this.cleanResourceKey(key);
        message.setKey(key);
        message.setText(messageText);
        message.setLocale(locale);
        return message;
    }

    protected List<ResourceBundle> getCachedResourceBundles(String namespace, String localeCode) {
        String cacheKey;
        if (StringUtils.isBlank((String)namespace)) {
            namespace = "KUALI";
        }
        if (this.cachedResourceBundles.containsKey(cacheKey = namespace + "|" + localeCode)) {
            return this.cachedResourceBundles.get(cacheKey);
        }
        List<ResourceBundle> bundles = null;
        bundles = StringUtils.isBlank((String)namespace) || "KUALI".equals(namespace) ? this.getResourceBundlesForApplication(localeCode) : this.getResourceBundlesForNamespace(namespace, localeCode);
        this.cachedResourceBundles.put(cacheKey, bundles);
        return bundles;
    }

    protected List<ResourceBundle> getResourceBundlesForNamespace(String namespace, String localeCode) {
        List<String> resourceBundleNames = this.getResourceBundleNamesForNamespace(namespace);
        return this.getResourceBundles(resourceBundleNames, localeCode);
    }

    protected List<ResourceBundle> getResourceBundlesForApplication(String localeCode) {
        List<String> resourceBundleNames = this.getResourceBundleNamesForApplication();
        return this.getResourceBundles(resourceBundleNames, localeCode);
    }

    protected List<ResourceBundle> getResourceBundles(List<String> resourceBundleNames, String localeCode) {
        ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        String[] localeIdentifiers = StringUtils.split((String)localeCode, (String)"-");
        if (localeIdentifiers == null || localeIdentifiers.length != 2) {
            throw new RiceRuntimeException("Invalid locale code: " + (localeCode == null ? "Null" : localeCode));
        }
        Locale locale = new Locale(localeIdentifiers[0], localeIdentifiers[1]);
        if (resourceBundleNames != null) {
            for (String bundleName : resourceBundleNames) {
                ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale);
                if (bundle == null) continue;
                resourceBundles.add(bundle);
            }
        }
        return resourceBundles;
    }

    protected List<String> getResourceBundleNamesForNamespace(String namespace) {
        ModuleService moduleService = KRADServiceLocatorWeb.getKualiModuleService().getModuleServiceByNamespaceCode(namespace);
        if (moduleService != null) {
            return moduleService.getModuleConfiguration().getResourceBundleNames();
        }
        return null;
    }

    protected List<String> getResourceBundleNamesForApplication() {
        String resourceBundleNamesConfig = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("resourceBundleNames");
        if (StringUtils.isNotBlank((String)resourceBundleNamesConfig)) {
            String[] resourceBundleNames = StringUtils.split((String)resourceBundleNamesConfig, (String)",");
            return Arrays.asList(resourceBundleNames);
        }
        return null;
    }
}

