/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import java.io.IOException;
import java.security.SecureRandom;
import java.text.ParseException;
import org.bouncycastle.pqc.crypto.xmss.BDS;
import org.bouncycastle.pqc.crypto.xmss.HashTreeAddress;
import org.bouncycastle.pqc.crypto.xmss.KeyedHashFunctions;
import org.bouncycastle.pqc.crypto.xmss.LTreeAddress;
import org.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import org.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import org.bouncycastle.pqc.crypto.xmss.WOTSPlusPublicKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.WOTSPlusSignature;
import org.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import org.bouncycastle.pqc.crypto.xmss.XMSSNode;
import org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import org.bouncycastle.pqc.crypto.xmss.XMSSSignature;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;

public class XMSS {
    private XMSSParameters params;
    private WOTSPlus wotsPlus;
    private SecureRandom prng;
    private KeyedHashFunctions khf;
    private XMSSPrivateKeyParameters privateKey;
    private XMSSPublicKeyParameters publicKey;

    public XMSS(XMSSParameters xMSSParameters) {
        if (xMSSParameters == null) {
            throw new NullPointerException("params == null");
        }
        this.params = xMSSParameters;
        this.wotsPlus = xMSSParameters.getWOTSPlus();
        this.prng = xMSSParameters.getPRNG();
        this.khf = this.wotsPlus.getKhf();
        try {
            this.privateKey = new XMSSPrivateKeyParameters.Builder(xMSSParameters).withBDSState(new BDS(this)).build();
            this.publicKey = new XMSSPublicKeyParameters.Builder(xMSSParameters).build();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void generateKeys() {
        this.privateKey = this.generatePrivateKey();
        XMSSNode xMSSNode = this.getBDSState().initialize((OTSHashAddress)new OTSHashAddress.Builder().build());
        try {
            this.privateKey = new XMSSPrivateKeyParameters.Builder(this.params).withIndex(this.privateKey.getIndex()).withSecretKeySeed(this.privateKey.getSecretKeySeed()).withSecretKeyPRF(this.privateKey.getSecretKeyPRF()).withPublicSeed(this.privateKey.getPublicSeed()).withRoot(xMSSNode.getValue()).withBDSState(this.privateKey.getBDSState()).build();
            this.publicKey = new XMSSPublicKeyParameters.Builder(this.params).withRoot(xMSSNode.getValue()).withPublicSeed(this.getPublicSeed()).build();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private XMSSPrivateKeyParameters generatePrivateKey() {
        int n = this.params.getDigestSize();
        byte[] byArray = new byte[n];
        this.prng.nextBytes(byArray);
        byte[] byArray2 = new byte[n];
        this.prng.nextBytes(byArray2);
        byte[] byArray3 = new byte[n];
        this.prng.nextBytes(byArray3);
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = null;
        try {
            xMSSPrivateKeyParameters = new XMSSPrivateKeyParameters.Builder(this.params).withSecretKeySeed(byArray).withSecretKeyPRF(byArray2).withPublicSeed(byArray3).withBDSState(this.privateKey.getBDSState()).build();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return xMSSPrivateKeyParameters;
    }

    public void importState(byte[] byArray, byte[] byArray2) throws ParseException, ClassNotFoundException, IOException {
        if (byArray == null) {
            throw new NullPointerException("privateKey == null");
        }
        if (byArray2 == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = new XMSSPrivateKeyParameters.Builder(this.params).withPrivateKey(byArray, this).build();
        XMSSPublicKeyParameters xMSSPublicKeyParameters = new XMSSPublicKeyParameters.Builder(this.params).withPublicKey(byArray2).build();
        if (!XMSSUtil.compareByteArray(xMSSPrivateKeyParameters.getRoot(), xMSSPublicKeyParameters.getRoot())) {
            throw new IllegalStateException("root of private key and public key do not match");
        }
        if (!XMSSUtil.compareByteArray(xMSSPrivateKeyParameters.getPublicSeed(), xMSSPublicKeyParameters.getPublicSeed())) {
            throw new IllegalStateException("public seed of private key and public key do not match");
        }
        this.privateKey = xMSSPrivateKeyParameters;
        this.publicKey = xMSSPublicKeyParameters;
        this.wotsPlus.importKeys(new byte[this.params.getDigestSize()], this.privateKey.getPublicSeed());
    }

    public byte[] sign(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("message == null");
        }
        if (this.getBDSState().getAuthenticationPath().isEmpty()) {
            throw new IllegalStateException("not initialized");
        }
        int n = this.privateKey.getIndex();
        if (!XMSSUtil.isIndexValid(this.getParams().getHeight(), n)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = this.khf.PRF(this.privateKey.getSecretKeyPRF(), XMSSUtil.toBytesBigEndian(n, 32));
        byte[] byArray3 = XMSSUtil.concat(byArray2, this.privateKey.getRoot(), XMSSUtil.toBytesBigEndian(n, this.params.getDigestSize()));
        byte[] byArray4 = this.khf.HMsg(byArray3, byArray);
        OTSHashAddress oTSHashAddress = (OTSHashAddress)new OTSHashAddress.Builder().withOTSAddress(n).build();
        WOTSPlusSignature wOTSPlusSignature = this.wotsSign(byArray4, oTSHashAddress);
        XMSSSignature xMSSSignature = null;
        try {
            xMSSSignature = (XMSSSignature)new XMSSSignature.Builder(this.params).withIndex(n).withRandom(byArray2).withWOTSPlusSignature(wOTSPlusSignature).withAuthPath(this.getBDSState().getAuthenticationPath()).build();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        int n2 = this.getParams().getHeight();
        if (n < (1 << n2) - 1) {
            this.getBDSState().nextAuthenticationPath((OTSHashAddress)new OTSHashAddress.Builder().build());
        }
        this.setIndex(n + 1);
        return xMSSSignature.toByteArray();
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2, byte[] byArray3) throws ParseException {
        if (byArray == null) {
            throw new NullPointerException("message == null");
        }
        if (byArray2 == null) {
            throw new NullPointerException("signature == null");
        }
        if (byArray3 == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSSignature xMSSSignature = new XMSSSignature.Builder(this.params).withSignature(byArray2).build();
        XMSSPublicKeyParameters xMSSPublicKeyParameters = new XMSSPublicKeyParameters.Builder(this.params).withPublicKey(byArray3).build();
        int n = this.privateKey.getIndex();
        byte[] byArray4 = this.privateKey.getPublicSeed();
        int n2 = xMSSSignature.getIndex();
        this.setIndex(n2);
        this.setPublicSeed(xMSSPublicKeyParameters.getPublicSeed());
        this.wotsPlus.importKeys(new byte[this.params.getDigestSize()], this.getPublicSeed());
        byte[] byArray5 = XMSSUtil.concat(xMSSSignature.getRandom(), xMSSPublicKeyParameters.getRoot(), XMSSUtil.toBytesBigEndian(n2, this.params.getDigestSize()));
        byte[] byArray6 = this.khf.HMsg(byArray5, byArray);
        OTSHashAddress oTSHashAddress = (OTSHashAddress)new OTSHashAddress.Builder().withOTSAddress(n2).build();
        XMSSNode xMSSNode = this.getRootNodeFromSignature(byArray6, xMSSSignature, oTSHashAddress);
        this.setIndex(n);
        this.setPublicSeed(byArray4);
        return XMSSUtil.compareByteArray(xMSSNode.getValue(), xMSSPublicKeyParameters.getRoot());
    }

    public byte[] exportPrivateKey() {
        return this.privateKey.toByteArray();
    }

    public byte[] exportPublicKey() {
        return this.publicKey.toByteArray();
    }

    protected XMSSNode randomizeHash(XMSSNode xMSSNode, XMSSNode xMSSNode2, XMSSAddress xMSSAddress) {
        int n;
        Object object;
        Object object2;
        Object object3;
        if (xMSSNode == null) {
            throw new NullPointerException("left == null");
        }
        if (xMSSNode2 == null) {
            throw new NullPointerException("right == null");
        }
        if (xMSSNode.getHeight() != xMSSNode2.getHeight()) {
            throw new IllegalStateException("height of both nodes must be equal");
        }
        if (xMSSAddress == null) {
            throw new NullPointerException("address == null");
        }
        byte[] byArray = this.getPublicSeed();
        if (xMSSAddress instanceof LTreeAddress) {
            object3 = (LTreeAddress)xMSSAddress;
            xMSSAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(((XMSSAddress)object3).getLayerAddress())).withTreeAddress(((XMSSAddress)object3).getTreeAddress())).withLTreeAddress(((LTreeAddress)object3).getLTreeAddress()).withTreeHeight(((LTreeAddress)object3).getTreeHeight()).withTreeIndex(((LTreeAddress)object3).getTreeIndex()).withKeyAndMask(0)).build();
        } else if (xMSSAddress instanceof HashTreeAddress) {
            object3 = (HashTreeAddress)xMSSAddress;
            xMSSAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(((XMSSAddress)object3).getLayerAddress())).withTreeAddress(((XMSSAddress)object3).getTreeAddress())).withTreeHeight(((HashTreeAddress)object3).getTreeHeight()).withTreeIndex(((HashTreeAddress)object3).getTreeIndex()).withKeyAndMask(0)).build();
        }
        object3 = this.khf.PRF(byArray, xMSSAddress.toByteArray());
        if (xMSSAddress instanceof LTreeAddress) {
            object2 = (LTreeAddress)xMSSAddress;
            xMSSAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(((XMSSAddress)object2).getLayerAddress())).withTreeAddress(((XMSSAddress)object2).getTreeAddress())).withLTreeAddress(((LTreeAddress)object2).getLTreeAddress()).withTreeHeight(((LTreeAddress)object2).getTreeHeight()).withTreeIndex(((LTreeAddress)object2).getTreeIndex()).withKeyAndMask(1)).build();
        } else if (xMSSAddress instanceof HashTreeAddress) {
            object2 = (HashTreeAddress)xMSSAddress;
            xMSSAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(((XMSSAddress)object2).getLayerAddress())).withTreeAddress(((XMSSAddress)object2).getTreeAddress())).withTreeHeight(((HashTreeAddress)object2).getTreeHeight()).withTreeIndex(((HashTreeAddress)object2).getTreeIndex()).withKeyAndMask(1)).build();
        }
        object2 = this.khf.PRF(byArray, xMSSAddress.toByteArray());
        if (xMSSAddress instanceof LTreeAddress) {
            object = (LTreeAddress)xMSSAddress;
            xMSSAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(((XMSSAddress)object).getLayerAddress())).withTreeAddress(((XMSSAddress)object).getTreeAddress())).withLTreeAddress(((LTreeAddress)object).getLTreeAddress()).withTreeHeight(((LTreeAddress)object).getTreeHeight()).withTreeIndex(((LTreeAddress)object).getTreeIndex()).withKeyAndMask(2)).build();
        } else if (xMSSAddress instanceof HashTreeAddress) {
            object = (HashTreeAddress)xMSSAddress;
            xMSSAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(((XMSSAddress)object).getLayerAddress())).withTreeAddress(((XMSSAddress)object).getTreeAddress())).withTreeHeight(((HashTreeAddress)object).getTreeHeight()).withTreeIndex(((HashTreeAddress)object).getTreeIndex()).withKeyAndMask(2)).build();
        }
        object = this.khf.PRF(byArray, xMSSAddress.toByteArray());
        int n2 = this.params.getDigestSize();
        byte[] byArray2 = new byte[2 * n2];
        for (n = 0; n < n2; ++n) {
            byArray2[n] = (byte)(xMSSNode.getValue()[n] ^ object2[n]);
        }
        for (n = 0; n < n2; ++n) {
            byArray2[n + n2] = (byte)(xMSSNode2.getValue()[n] ^ object[n]);
        }
        byte[] byArray3 = this.khf.H((byte[])object3, byArray2);
        return new XMSSNode(xMSSNode.getHeight(), byArray3);
    }

    protected XMSSNode lTree(WOTSPlusPublicKeyParameters wOTSPlusPublicKeyParameters, LTreeAddress lTreeAddress) {
        int n;
        if (wOTSPlusPublicKeyParameters == null) {
            throw new NullPointerException("publicKey == null");
        }
        if (lTreeAddress == null) {
            throw new NullPointerException("address == null");
        }
        int n2 = this.wotsPlus.getParams().getLen();
        byte[][] byArray = wOTSPlusPublicKeyParameters.toByteArray();
        XMSSNode[] xMSSNodeArray = new XMSSNode[byArray.length];
        for (n = 0; n < byArray.length; ++n) {
            xMSSNodeArray[n] = new XMSSNode(0, byArray[n]);
        }
        lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(lTreeAddress.getLayerAddress())).withTreeAddress(lTreeAddress.getTreeAddress())).withLTreeAddress(lTreeAddress.getLTreeAddress()).withTreeHeight(0).withTreeIndex(lTreeAddress.getTreeIndex()).withKeyAndMask(lTreeAddress.getKeyAndMask())).build();
        while (n2 > 1) {
            for (n = 0; n < (int)Math.floor(n2 / 2); ++n) {
                lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(lTreeAddress.getLayerAddress())).withTreeAddress(lTreeAddress.getTreeAddress())).withLTreeAddress(lTreeAddress.getLTreeAddress()).withTreeHeight(lTreeAddress.getTreeHeight()).withTreeIndex(n).withKeyAndMask(lTreeAddress.getKeyAndMask())).build();
                xMSSNodeArray[n] = this.randomizeHash(xMSSNodeArray[2 * n], xMSSNodeArray[2 * n + 1], lTreeAddress);
            }
            if (n2 % 2 == 1) {
                xMSSNodeArray[(int)Math.floor((double)((double)(n2 / 2)))] = xMSSNodeArray[n2 - 1];
            }
            n2 = (int)Math.ceil((double)n2 / 2.0);
            lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(lTreeAddress.getLayerAddress())).withTreeAddress(lTreeAddress.getTreeAddress())).withLTreeAddress(lTreeAddress.getLTreeAddress()).withTreeHeight(lTreeAddress.getTreeHeight() + 1).withTreeIndex(lTreeAddress.getTreeIndex()).withKeyAndMask(lTreeAddress.getKeyAndMask())).build();
        }
        return xMSSNodeArray[0];
    }

    protected WOTSPlusSignature wotsSign(byte[] byArray, OTSHashAddress oTSHashAddress) {
        if (byArray.length != this.params.getDigestSize()) {
            throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
        }
        if (oTSHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        this.wotsPlus.importKeys(this.getWOTSPlusSecretKey(oTSHashAddress), this.getPublicSeed());
        return this.wotsPlus.sign(byArray, oTSHashAddress);
    }

    protected XMSSNode getRootNodeFromSignature(byte[] byArray, XMSSReducedSignature xMSSReducedSignature, OTSHashAddress oTSHashAddress) {
        if (byArray.length != this.params.getDigestSize()) {
            throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
        }
        if (xMSSReducedSignature == null) {
            throw new NullPointerException("signature == null");
        }
        if (oTSHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        LTreeAddress lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withLTreeAddress(oTSHashAddress.getOTSAddress()).build();
        HashTreeAddress hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withTreeIndex(oTSHashAddress.getOTSAddress()).build();
        WOTSPlusPublicKeyParameters wOTSPlusPublicKeyParameters = this.wotsPlus.getPublicKeyFromSignature(byArray, xMSSReducedSignature.getWOTSPlusSignature(), oTSHashAddress);
        XMSSNode[] xMSSNodeArray = new XMSSNode[2];
        xMSSNodeArray[0] = this.lTree(wOTSPlusPublicKeyParameters, lTreeAddress);
        for (int i = 0; i < this.params.getHeight(); ++i) {
            hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(i).withTreeIndex(hashTreeAddress.getTreeIndex()).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
            if (Math.floor(this.privateKey.getIndex() / (1 << i)) % 2.0 == 0.0) {
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight()).withTreeIndex(hashTreeAddress.getTreeIndex() / 2).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
                xMSSNodeArray[1] = this.randomizeHash(xMSSNodeArray[0], xMSSReducedSignature.getAuthPath().get(i), hashTreeAddress);
                xMSSNodeArray[1] = new XMSSNode(xMSSNodeArray[1].getHeight() + 1, xMSSNodeArray[1].getValue());
            } else {
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight()).withTreeIndex((hashTreeAddress.getTreeIndex() - 1) / 2).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
                xMSSNodeArray[1] = this.randomizeHash(xMSSReducedSignature.getAuthPath().get(i), xMSSNodeArray[0], hashTreeAddress);
                xMSSNodeArray[1] = new XMSSNode(xMSSNodeArray[1].getHeight() + 1, xMSSNodeArray[1].getValue());
            }
            xMSSNodeArray[0] = xMSSNodeArray[1];
        }
        return xMSSNodeArray[0];
    }

    protected byte[] getWOTSPlusSecretKey(OTSHashAddress oTSHashAddress) {
        oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withOTSAddress(oTSHashAddress.getOTSAddress()).build();
        return this.khf.PRF(this.privateKey.getSecretKeySeed(), oTSHashAddress.toByteArray());
    }

    public XMSSParameters getParams() {
        return this.params;
    }

    protected WOTSPlus getWOTSPlus() {
        return this.wotsPlus;
    }

    protected KeyedHashFunctions getKhf() {
        return this.khf;
    }

    public byte[] getRoot() {
        return this.privateKey.getRoot();
    }

    protected void setRoot(byte[] byArray) {
        try {
            this.privateKey = new XMSSPrivateKeyParameters.Builder(this.params).withIndex(this.privateKey.getIndex()).withSecretKeySeed(this.privateKey.getSecretKeySeed()).withSecretKeyPRF(this.privateKey.getSecretKeyPRF()).withPublicSeed(this.getPublicSeed()).withRoot(byArray).withBDSState(this.privateKey.getBDSState()).build();
            this.publicKey = new XMSSPublicKeyParameters.Builder(this.params).withRoot(byArray).withPublicSeed(this.getPublicSeed()).build();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public int getIndex() {
        return this.privateKey.getIndex();
    }

    protected void setIndex(int n) {
        try {
            this.privateKey = new XMSSPrivateKeyParameters.Builder(this.params).withIndex(n).withSecretKeySeed(this.privateKey.getSecretKeySeed()).withSecretKeyPRF(this.privateKey.getSecretKeyPRF()).withPublicSeed(this.privateKey.getPublicSeed()).withRoot(this.privateKey.getRoot()).withBDSState(this.privateKey.getBDSState()).build();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public byte[] getPublicSeed() {
        return this.privateKey.getPublicSeed();
    }

    protected void setPublicSeed(byte[] byArray) {
        try {
            this.privateKey = new XMSSPrivateKeyParameters.Builder(this.params).withIndex(this.privateKey.getIndex()).withSecretKeySeed(this.privateKey.getSecretKeySeed()).withSecretKeyPRF(this.privateKey.getSecretKeyPRF()).withPublicSeed(byArray).withRoot(this.getRoot()).withBDSState(this.privateKey.getBDSState()).build();
            this.publicKey = new XMSSPublicKeyParameters.Builder(this.params).withRoot(this.getRoot()).withPublicSeed(byArray).build();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.wotsPlus.importKeys(new byte[this.params.getDigestSize()], byArray);
    }

    protected BDS getBDSState() {
        return this.privateKey.getBDSState();
    }
}

