/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UrlFactory {
    private static Logger LOG = LogManager.getLogger(UrlFactory.class);
    private static Pattern NEEDS_ENCODING_PATTERN = Pattern.compile(".*[^a-zA-Z0-9-_.* |%\\d\\d].*");
    private static URLCodec urlCodec = new URLCodec("UTF-8");

    public static String parameterizeUrl(String baseUrl, Properties params) {
        if (StringUtils.isEmpty((String)(baseUrl = StringUtils.trim((String)baseUrl)))) {
            throw new IllegalArgumentException("invalid (blank) base URL");
        }
        if (params == null) {
            throw new IllegalArgumentException("invalid (null) Properties");
        }
        StringBuffer ret = new StringBuffer(baseUrl);
        String delimiter = ret.indexOf("?") == -1 ? "?" : "&";
        for (Object key : params.keySet()) {
            String paramName = StringUtils.trim((String)((String)key));
            String paramValue = params.getProperty(paramName);
            ret.append(delimiter);
            if (StringUtils.isEmpty((String)paramName)) {
                throw new IllegalArgumentException("invalid (blank) paramName");
            }
            ret.append(UrlFactory.safeEncode(paramName));
            ret.append("=");
            ret.append(UrlFactory.safeEncode(paramValue));
            delimiter = "&";
        }
        return ret.toString();
    }

    @Deprecated
    public static String encode(String value) {
        try {
            return urlCodec.encode(value);
        }
        catch (EncoderException ex) {
            throw new RuntimeException("Unable to encode value: " + value, ex);
        }
    }

    public static String safeEncode(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        try {
            boolean needsEncoding = NEEDS_ENCODING_PATTERN.matcher(value).matches();
            return needsEncoding ? urlCodec.encode(value) : value;
        }
        catch (EncoderException e) {
            LOG.debug("Unable to encode value: " + value, (Throwable)e);
            throw new RuntimeException("Unable to encode value: " + value, e);
        }
    }
}

