/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.modifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.SpaceField;
import org.kuali.rice.krad.uif.layout.GridLayoutManager;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.modifier.ComparableInfo;
import org.kuali.rice.krad.uif.modifier.ComponentModifierBase;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;

@BeanTags(value={@BeanTag(name="compareFieldCreateModifier", parent="Uif-CompareFieldCreate-Modifier"), @BeanTag(name="maintenanceCompareModifier", parent="Uif-MaintenanceCompare-Modifier")})
public class CompareFieldCreateModifier
extends ComponentModifierBase {
    private static final long serialVersionUID = -6285531580512330188L;
    private int defaultOrderSequence = 1;
    private boolean generateCompareHeaders = true;
    private Header headerFieldPrototype;
    private List<ComparableInfo> comparables = new ArrayList<ComparableInfo>();

    @Override
    public void performInitialization(Object model, Component component) {
        super.performInitialization(model, component);
        if (component != null && !(component instanceof Group)) {
            throw new IllegalArgumentException("Compare field initializer only support Group components, found type: " + component.getClass());
        }
        if (component == null) {
            return;
        }
        Group group = (Group)component;
        for (Component component2 : group.getItems()) {
            component2.pushObjectToContext("renderOnComparableModifier", Boolean.TRUE);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void performModification(Object model, Component component) {
        if (component != null && !(component instanceof Group)) {
            throw new IllegalArgumentException("Compare field initializer only support Group components, found type: " + component.getClass());
        }
        if (component == null) {
            return;
        }
        Group group = (Group)component;
        ArrayList<Component> comparisonItems = new ArrayList<Component>();
        List<ComparableInfo> groupComparables = ComponentUtils.sort(this.comparables, this.defaultOrderSequence);
        HashMap<String, Object> context = new HashMap<String, Object>();
        View view = ViewLifecycle.getView();
        Map<String, Object> viewContext = view.getContext();
        if (viewContext != null) {
            context.putAll(view.getContext());
        }
        context.put("component", component);
        ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
        for (ComparableInfo comparableInfo : groupComparables) {
            expressionEvaluator.evaluateExpressionsOnConfigurable(view, comparableInfo, context);
        }
        if (this.isGenerateCompareHeaders()) {
            SpaceField spaceField = ComponentFactory.getSpaceField();
            comparisonItems.add(spaceField);
            for (ComparableInfo comparableInfo : groupComparables) {
                Header compareHeaderField = ComponentUtils.copy(this.headerFieldPrototype, comparableInfo.getComparableId());
                compareHeaderField.setHeaderText(comparableInfo.getHeaderText());
                comparisonItems.add(compareHeaderField);
            }
            if (group.getLayoutManager() instanceof GridLayoutManager) {
                ((GridLayoutManager)group.getLayoutManager()).setRenderFirstRowHeader(true);
                ((GridLayoutManager)group.getLayoutManager()).getRowCssClasses().add("");
            }
        }
        boolean performValueChangeComparison = false;
        Object var11_15 = null;
        for (ComparableInfo comparable : groupComparables) {
            if (!comparable.isCompareToForValueChange()) continue;
            performValueChangeComparison = true;
            String string = comparable.getBindingObjectPath();
        }
        boolean bl = false;
        for (Component component2 : group.getItems()) {
            if (component2 instanceof Header) {
                comparisonItems.add(component2);
                component2.setColSpan(groupComparables.size() + 1);
                if (!(group.getLayoutManager() instanceof GridLayoutManager)) continue;
                ((GridLayoutManager)group.getLayoutManager()).getRowCssClasses().add("row-separator");
                continue;
            }
            int defaultSuffix = 0;
            boolean suppressLabel = false;
            String rowCssClass = "";
            for (ComparableInfo comparable : groupComparables) {
                Object comparableId = comparable.getComparableId();
                if (StringUtils.isBlank((String)comparableId)) {
                    comparableId = "_comp" + defaultSuffix;
                }
                Component compareItem = ComponentUtils.copy(component2, (String)comparableId);
                ComponentUtils.setComponentPropertyDeep(compareItem, "bindingInfo.bindingObjectPath", comparable.getBindingObjectPath());
                if (comparable.isReadOnly()) {
                    compareItem.setReadOnly(true);
                    if (compareItem.getPropertyExpressions().containsKey("readOnly")) {
                        compareItem.getPropertyExpressions().remove("readOnly");
                    }
                }
                if (suppressLabel && compareItem instanceof Field) {
                    ((Field)compareItem).getFieldLabel().setRender(false);
                }
                compareItem.pushObjectToContext("renderOnComparableModifier", comparable.isCompareToForFieldRender());
                if (performValueChangeComparison && comparable.isHighlightValueChange() && !comparable.isCompareToForValueChange()) {
                    boolean bl2;
                    void var11_16;
                    boolean valueChanged = this.performValueComparison(group, compareItem, model, (String)var11_16);
                    if (valueChanged && !bl2 && this.isGenerateCompareHeaders()) {
                        Group groupToSetHeader = null;
                        if (group.getDisclosure() != null && group.getDisclosure().isRender()) {
                            groupToSetHeader = group;
                        } else if (group.getContext().get("parent") != null) {
                            groupToSetHeader = (Group)group.getContext().get("parent");
                        }
                        if (groupToSetHeader != null) {
                            if (groupToSetHeader.getDisclosure().isRender()) {
                                groupToSetHeader.getDisclosure().setOnDocumentReadyScript("showChangeIconOnDisclosure('" + groupToSetHeader.getId() + "');");
                            } else if (groupToSetHeader.getHeader() != null) {
                                groupToSetHeader.getHeader().setOnDocumentReadyScript("showChangeIconOnHeader('" + groupToSetHeader.getHeader().getId() + "');");
                            }
                        }
                        bl2 = true;
                    }
                    if (valueChanged) {
                        rowCssClass = "uif-compared";
                    }
                }
                comparisonItems.add(compareItem);
                ++defaultSuffix;
                suppressLabel = true;
            }
            if (!(group.getLayoutManager() instanceof GridLayoutManager)) continue;
            ((GridLayoutManager)group.getLayoutManager()).getRowCssClasses().add(rowCssClass);
        }
        group.setItems(comparisonItems);
    }

    protected boolean performValueComparison(Group group, Component compareItem, Object model, String compareValueObjectBindingPath) {
        List<DataField> itemFields = ViewLifecycleUtils.getElementsOfTypeDeep(compareItem, DataField.class);
        boolean valueChanged = false;
        for (DataField field : itemFields) {
            Object fieldBindingPath = field.getBindingInfo().getBindingPath();
            if (field.getPropertyName() != null && field.getPropertyName().length() > 0 && !((String)fieldBindingPath).endsWith(field.getPropertyName())) {
                fieldBindingPath = (String)fieldBindingPath + "." + field.getPropertyName();
            }
            Object fieldValue = ObjectPropertyUtils.getPropertyValue(model, (String)fieldBindingPath);
            String compareBindingPath = StringUtils.replaceOnce((String)fieldBindingPath, (String)field.getBindingInfo().getBindingObjectPath(), (String)compareValueObjectBindingPath);
            Object compareValue = ObjectPropertyUtils.getPropertyValue(model, compareBindingPath);
            if (fieldValue != null || compareValue != null) {
                if (fieldValue == null || compareValue == null) {
                    valueChanged = true;
                } else {
                    boolean bl = valueChanged = !fieldValue.equals(compareValue);
                }
            }
            if (!valueChanged) continue;
            String onReadyScript = "showChangeIcon('" + field.getId() + "');";
            field.setRenderMarkerIconSpan(true);
            field.setOnDocumentReadyScript(onReadyScript);
        }
        return valueChanged;
    }

    protected String getComparableId(ComparableInfo comparable, int index) {
        Object comparableId = comparable.getComparableId();
        if (StringUtils.isBlank((String)comparableId)) {
            comparableId = "_" + index;
        }
        return comparableId;
    }

    @Override
    public Set<Class<? extends Component>> getSupportedComponents() {
        HashSet<Class<? extends Component>> components = new HashSet<Class<? extends Component>>();
        components.add(Group.class);
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(this.headerFieldPrototype);
        return components;
    }

    @BeanTagAttribute
    public int getDefaultOrderSequence() {
        return this.defaultOrderSequence;
    }

    public void setDefaultOrderSequence(int defaultOrderSequence) {
        this.defaultOrderSequence = defaultOrderSequence;
    }

    @BeanTagAttribute
    public boolean isGenerateCompareHeaders() {
        return this.generateCompareHeaders;
    }

    public void setGenerateCompareHeaders(boolean generateCompareHeaders) {
        this.generateCompareHeaders = generateCompareHeaders;
    }

    @BeanTagAttribute
    public Header getHeaderFieldPrototype() {
        return this.headerFieldPrototype;
    }

    public void setHeaderFieldPrototype(Header headerFieldPrototype) {
        this.headerFieldPrototype = headerFieldPrototype;
    }

    @BeanTagAttribute
    public List<ComparableInfo> getComparables() {
        return this.comparables;
    }

    public void setComparables(List<ComparableInfo> comparables) {
        this.comparables = comparables;
    }
}

