/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.coeus.common.framework.sponsor.term.SponsorTermType;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.kra.award.home.AwardTemplate;
import org.kuali.kra.award.home.AwardTemplateTerm;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;

public class SponsorTemplateTermsExistenceRule
extends KcMaintenanceDocumentRuleBase {
    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkTermsExistence(document);
    }

    private boolean checkTermsExistence(MaintenanceDocument maintenanceDocument) {
        boolean valid = true;
        AwardTemplate awardTemplate = (AwardTemplate)maintenanceDocument.getNewMaintainableObject().getDataObject();
        List<AwardTemplateTerm> aList = awardTemplate.getAwardSponsorTerms();
        BusinessObjectService businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        Collection types = businessObjectService.findAll(SponsorTermType.class);
        ArrayList<String> currentTypeCodes = new ArrayList<String>();
        for (AwardTemplateTerm aTerm : aList) {
            currentTypeCodes.add(aTerm.getSponsorTermTypeCode());
        }
        for (SponsorTermType aType : types) {
            if (currentTypeCodes.contains(aType.getSponsorTermTypeCode())) continue;
            ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
            errorReporter.reportError("document.newMaintainableObject.templateTerms", "error.award.sponsorTemplate.term.required", aType.getDescription());
            valid = false;
        }
        return valid;
    }
}

