/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.util.Collection;
import org.kuali.rice.kew.engine.node.NodeMatcher;
import org.kuali.rice.kew.engine.node.NodeNameMatcher;

public class NodeGraphSearchCriteria {
    public static final int SEARCH_DIRECTION_FORWARD = 1;
    public static final int SEARCH_DIRECTION_BACKWARD = 2;
    public static final int SEARCH_DIRECTION_BOTH = 3;
    private int searchDirection = 1;
    private Collection startingNodeInstances;
    private NodeMatcher matcher;

    public NodeGraphSearchCriteria(int searchDirection, Collection startingNodeInstances, NodeMatcher matcher) {
        if (startingNodeInstances == null || startingNodeInstances.isEmpty()) {
            throw new IllegalArgumentException("Starting node instances were empty.  At least one starting node instance must be specified in order to perform a search.");
        }
        this.searchDirection = searchDirection;
        this.startingNodeInstances = startingNodeInstances;
        this.matcher = matcher;
    }

    public NodeGraphSearchCriteria(int searchDirection, Collection startingNodeInstances, String nodeName) {
        this(searchDirection, startingNodeInstances, new NodeNameMatcher(nodeName));
    }

    public NodeMatcher getMatcher() {
        return this.matcher;
    }

    public Collection getStartingNodeInstances() {
        return this.startingNodeInstances;
    }

    public int getSearchDirection() {
        return this.searchDirection;
    }
}

