/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.text.ParseException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.kew.api.rule.RuleContract;
import org.kuali.rice.kew.api.rule.RuleExpressionContract;
import org.kuali.rice.kew.api.rule.RuleResponsibility;
import org.kuali.rice.kew.api.rule.RuleResponsibilityContract;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.rule.AccumulatingBSFRuleExpression;
import org.kuali.rice.kew.rule.KRAMetaRuleEngine;
import org.kuali.rice.kew.rule.Rule;
import org.kuali.rice.kew.rule.RuleExpressionResult;

public class MetaRuleExpression
extends AccumulatingBSFRuleExpression {
    private static final Logger LOG = LogManager.getLogger(MetaRuleExpression.class);

    @Override
    public RuleExpressionResult evaluate(Rule rule, RouteContext context) {
        RuleContract ruleDefinition = rule.getDefinition();
        RuleExpressionContract exprDef = ruleDefinition.getRuleExpressionDef();
        if (exprDef == null) {
            throw new RiceIllegalStateException("No expression defined in rule definition: " + ruleDefinition);
        }
        String expression = exprDef.getExpression();
        if (StringUtils.isEmpty((String)expression)) {
            throw new RiceIllegalStateException("Empty expression in rule definition: " + ruleDefinition);
        }
        String lang = this.parseLang(ruleDefinition.getRuleExpressionDef().getType(), null);
        if (lang == null) {
            return this.evaluateBuiltinExpression(expression, rule, context);
        }
        return super.evaluate(rule, context);
    }

    private RuleExpressionResult evaluateBuiltinExpression(String expression, Rule rule, RouteContext context) {
        try {
            KRAMetaRuleEngine engine = new KRAMetaRuleEngine(expression);
            int responsibilityPriority = 0;
            RuleExpressionResult result = null;
            boolean success = false;
            ArrayList<RuleResponsibility> responsibilities = new ArrayList<RuleResponsibility>();
            while (!engine.isDone()) {
                result = engine.processSingleStatement(context);
                if (!result.isSuccess() || result.getResponsibilities() == null) continue;
                for (RuleResponsibility responsibility : result.getResponsibilities()) {
                    RuleResponsibility.Builder builder = RuleResponsibility.Builder.create((RuleResponsibilityContract)responsibility);
                    builder.setPriority(Integer.valueOf(responsibilityPriority));
                    responsibilities.add(builder.build());
                }
                ++responsibilityPriority;
                success = true;
            }
            result = new RuleExpressionResult(rule, success, responsibilities);
            LOG.debug("MetaRuleExpression returning result: " + result);
            return result;
        }
        catch (ParseException pe) {
            throw new RiceIllegalStateException("Error parsing expression", (Throwable)pe);
        }
    }
}

