/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine.expression;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krms.api.engine.IncompatibleTypeException;
import org.kuali.rice.krms.framework.engine.expression.EngineComparatorExtension;
import org.kuali.rice.krms.framework.engine.expression.StringCoercionExtension;

public class DateComparisonOperator
implements EngineComparatorExtension,
StringCoercionExtension {
    private Logger LOG = LogManager.getLogger(DateComparisonOperator.class);
    private DateTimeService dateTimeService;

    public boolean canCoerce(String type, String value) {
        return this.coerce(type, value) != null;
    }

    public Object coerce(String type, String value) {
        try {
            if (StringUtils.equals((CharSequence)type, (CharSequence)Date.class.getCanonicalName())) {
                return this.dateTimeService.convertToDate(value);
            }
            if (StringUtils.equals((CharSequence)type, (CharSequence)java.sql.Date.class.getCanonicalName())) {
                return this.dateTimeService.convertToSqlDate(value);
            }
            if (StringUtils.equals((CharSequence)type, (CharSequence)Timestamp.class.getCanonicalName())) {
                return this.dateTimeService.convertToSqlTimestamp(value);
            }
            if (StringUtils.equals((CharSequence)type, (CharSequence)Time.class.getCanonicalName())) {
                return this.dateTimeService.convertToSqlTime(value);
            }
            return null;
        }
        catch (ParseException e) {
            this.LOG.info("Unable to parse '" + value + "' into know date/time", (Throwable)e);
            return null;
        }
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public int compare(Object lhs, Object rhs) {
        Long rhsTime;
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        Long lhsTime = ((Date)lhs).getTime();
        if (rhs instanceof Date) {
            rhsTime = ((Date)rhs).getTime();
        } else if (rhs instanceof String) {
            rhsTime = ((Date)this.coerce(lhs.getClass().getCanonicalName(), (String)rhs)).getTime();
        } else {
            throw new IncompatibleTypeException((Object)("Expected Date or String rhs and therefore unable to compare lhs(" + lhs.getClass().getCanonicalName() + ") and rhs(" + rhs.getClass().getCanonicalName() + ")"), new Class[0]);
        }
        return lhsTime.compareTo(rhsTime);
    }

    public boolean canCompare(Object lhs, Object rhs) {
        return this.isDateType(lhs) && (this.isDateType(rhs) || rhs instanceof String && this.canCoerce(lhs.getClass().getCanonicalName(), (String)rhs));
    }

    protected boolean isDateType(Object lhs) {
        return lhs instanceof Date || lhs instanceof java.sql.Date || lhs instanceof Timestamp || lhs instanceof Time;
    }
}

