/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardBudgetBudgetTypeAuditRule
implements DocumentAuditRule {
    public static final String AWARD_BUDGET_TYPE_ERROR_KEY = "awardBudgetTypeAuditErrors";

    public boolean processRunAuditBusinessRules(Document document) {
        AwardBudgetExt budget = ((AwardBudgetDocument)document).getBudget();
        boolean valid = true;
        String[] params = new String[]{"Budget Overview Comments"};
        if ("2".equals(budget.getAwardBudgetTypeCode()) && StringUtils.isBlank((CharSequence)budget.getComments())) {
            this.getAuditErrors().add(new AuditError("document.budget.comments", "error.budget.comments.required.for.rebudget", "parameters.topOfForm", params));
            valid = false;
        }
        return valid;
    }

    private List<AuditError> getAuditErrors() {
        return this.getAuditProblems("Error");
    }

    private List<AuditError> getAuditProblems(String problemType) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!GlobalVariables.getAuditErrorMap().containsKey(AWARD_BUDGET_TYPE_ERROR_KEY)) {
            GlobalVariables.getAuditErrorMap().put(AWARD_BUDGET_TYPE_ERROR_KEY, new AuditCluster("Budget Overview", auditErrors, problemType));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(AWARD_BUDGET_TYPE_ERROR_KEY)).getAuditErrorList();
        }
        return auditErrors;
    }
}

