/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

class KimInternalSuppressUtils {
    private static IdentityService identityService;
    private static PermissionService permissionService;

    private KimInternalSuppressUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static boolean isSuppressName(String entityId) {
        EntityPrivacyPreferences privacy = KimInternalSuppressUtils.getIdentityService().getEntityPrivacyPreferences(entityId);
        if (privacy == null) {
            return false;
        }
        UserSession userSession = GlobalVariables.getUserSession();
        boolean suppressName = privacy.isSuppressName();
        return suppressName && userSession != null && !StringUtils.equals((String)userSession.getPerson().getEntityId(), (String)entityId) && !KimInternalSuppressUtils.canOverrideEntityPrivacyPreferences(entityId);
    }

    public static boolean isSuppressEmail(String entityId) {
        EntityPrivacyPreferences privacy = KimInternalSuppressUtils.getIdentityService().getEntityPrivacyPreferences(entityId);
        if (privacy == null) {
            return false;
        }
        UserSession userSession = GlobalVariables.getUserSession();
        boolean suppressEmail = privacy.isSuppressEmail();
        return suppressEmail && userSession != null && !StringUtils.equals((String)userSession.getPerson().getEntityId(), (String)entityId) && !KimInternalSuppressUtils.canOverrideEntityPrivacyPreferences(entityId);
    }

    public static boolean isSuppressAddress(String entityId) {
        EntityPrivacyPreferences privacy = KimInternalSuppressUtils.getIdentityService().getEntityPrivacyPreferences(entityId);
        if (privacy == null) {
            return false;
        }
        UserSession userSession = GlobalVariables.getUserSession();
        boolean suppressAddress = privacy.isSuppressAddress();
        return suppressAddress && userSession != null && !StringUtils.equals((String)userSession.getPerson().getEntityId(), (String)entityId) && !KimInternalSuppressUtils.canOverrideEntityPrivacyPreferences(entityId);
    }

    public static boolean isSuppressPhone(String entityId) {
        EntityPrivacyPreferences privacy = KimInternalSuppressUtils.getIdentityService().getEntityPrivacyPreferences(entityId);
        if (privacy == null) {
            return false;
        }
        UserSession userSession = GlobalVariables.getUserSession();
        boolean suppressPhone = privacy.isSuppressPhone();
        return suppressPhone && userSession != null && !StringUtils.equals((String)userSession.getPerson().getEntityId(), (String)entityId) && !KimInternalSuppressUtils.canOverrideEntityPrivacyPreferences(entityId);
    }

    public static boolean isSuppressPersonal(String entityId) {
        EntityPrivacyPreferences privacy = KimInternalSuppressUtils.getIdentityService().getEntityPrivacyPreferences(entityId);
        if (privacy == null) {
            return false;
        }
        UserSession userSession = GlobalVariables.getUserSession();
        boolean suppressPersonal = privacy.isSuppressPersonal();
        return suppressPersonal && userSession != null && !StringUtils.equals((String)userSession.getPerson().getEntityId(), (String)entityId) && !KimInternalSuppressUtils.canOverrideEntityPrivacyPreferences(entityId);
    }

    protected static boolean canOverrideEntityPrivacyPreferences(String entityId) {
        List principals = KimInternalSuppressUtils.getIdentityService().getPrincipalsByEntityId(entityId);
        if (CollectionUtils.isEmpty((Collection)principals)) {
            return false;
        }
        String principalId = ((Principal)principals.get(0)).getPrincipalId();
        return KimInternalSuppressUtils.getPermissionService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), "KR-IDM", "Override Entity Privacy Preferences", Collections.singletonMap("principalId", principalId));
    }

    private static IdentityService getIdentityService() {
        if (identityService == null) {
            identityService = KimApiServiceLocator.getIdentityService();
        }
        return identityService;
    }

    private static PermissionService getPermissionService() {
        if (permissionService == null) {
            permissionService = KimApiServiceLocator.getPermissionService();
        }
        return permissionService;
    }
}

