/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;

public class ObjectCachePerBrokerImpl
implements ObjectCache,
PBStateListener {
    protected Map objectTable = new HashMap();

    public ObjectCachePerBrokerImpl(PersistenceBroker persistenceBroker, Properties properties) {
        persistenceBroker.addListener(this, true);
    }

    @Override
    public void clear() {
        this.objectTable.clear();
    }

    @Override
    public void cache(Identity identity, Object object) {
        if (object != null) {
            SoftReference<Object> softReference = new SoftReference<Object>(object);
            this.objectTable.put(identity, softReference);
        }
    }

    public boolean cacheIfNew(Identity identity, Object object) {
        if (this.objectTable.get(identity) == null) {
            this.objectTable.put(identity, object);
            return true;
        }
        return false;
    }

    @Override
    public Object lookup(Identity identity) {
        Object var2_2 = null;
        SoftReference softReference = (SoftReference)this.objectTable.get(identity);
        if (softReference != null && (var2_2 = softReference.get()) == null) {
            this.objectTable.remove(identity);
        }
        return var2_2;
    }

    @Override
    public void remove(Identity identity) {
        if (identity != null) {
            this.objectTable.remove(identity);
        }
    }

    @Override
    public void beforeClose(PBStateEvent pBStateEvent) {
        this.clear();
    }

    @Override
    public void afterOpen(PBStateEvent pBStateEvent) {
    }

    @Override
    public void beforeBegin(PBStateEvent pBStateEvent) {
    }

    @Override
    public void afterBegin(PBStateEvent pBStateEvent) {
    }

    @Override
    public void beforeCommit(PBStateEvent pBStateEvent) {
    }

    @Override
    public void afterCommit(PBStateEvent pBStateEvent) {
    }

    @Override
    public void beforeRollback(PBStateEvent pBStateEvent) {
    }

    @Override
    public void afterRollback(PBStateEvent pBStateEvent) {
        this.clear();
    }
}

