/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.bind;

import java.beans.PropertyEditor;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.bind.RequestAccessible;
import org.kuali.rice.krad.web.bind.RequestProtected;
import org.kuali.rice.krad.web.bind.UifBeanPropertyBindingResult;
import org.kuali.rice.krad.web.bind.UifBeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValue;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class UifViewBeanWrapper
extends UifBeanWrapper {
    private static Logger LOG = LogManager.getLogger(UifViewBeanWrapper.class);
    private Set<String> processedProperties;
    private final UifBeanPropertyBindingResult bindingResult;

    public UifViewBeanWrapper(ViewModel model, UifBeanPropertyBindingResult bindingResult) {
        super(model);
        this.bindingResult = bindingResult;
        this.processedProperties = new HashSet<String>();
    }

    @Override
    protected Object getPropertyValue(String propertyName, boolean autoGrowNestedPaths) {
        this.registerEditorFromView(propertyName);
        return super.getPropertyValue(propertyName, autoGrowNestedPaths);
    }

    protected void registerEditorFromView(String propertyName) {
        ViewPostMetadata viewPostMetadata;
        if (this.processedProperties.contains(propertyName)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to find property editor for property '" + propertyName + "'");
        }
        if ((viewPostMetadata = ((ViewModel)this.getWrappedInstance()).getViewPostMetadata()) == null) {
            return;
        }
        PropertyEditor propertyEditor = viewPostMetadata.getFieldEditor(propertyName);
        if (propertyEditor != null) {
            this.registerCustomEditor(null, propertyName, propertyEditor);
        }
        this.processedProperties.add(propertyName);
    }

    @Override
    public void setPropertyValue(PropertyValue pv) throws BeansException {
        boolean isPropertyAccessible = this.checkPropertyBindingAccess(pv.getName());
        if (!isPropertyAccessible) {
            return;
        }
        Object value = this.processValueBeforeSet(pv.getName(), pv.getValue());
        pv = new PropertyValue(pv, value);
        boolean originalValueSaved = true;
        Object originalValue = null;
        if (this.bindingResult.isChangeTracking()) {
            try {
                originalValue = this.getPropertyValue(pv.getName(), true);
            }
            catch (Exception e) {
                originalValueSaved = false;
            }
        }
        super.setPropertyValue(pv);
        if (this.bindingResult.isChangeTracking() && originalValueSaved) {
            try {
                Object newValue = this.getPropertyValue(pv.getName());
                if (ObjectUtils.notEqual((Object)originalValue, (Object)newValue)) {
                    this.bindingResult.addModifiedPath(pv.getName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setPropertyValue(String propertyName, Object value) throws BeansException {
        boolean isPropertyAccessible = this.checkPropertyBindingAccess(propertyName);
        if (!isPropertyAccessible) {
            return;
        }
        value = this.processValueBeforeSet(propertyName, value);
        boolean originalValueSaved = true;
        Object originalValue = null;
        try {
            originalValue = this.getPropertyValue(propertyName, true);
        }
        catch (Exception e) {
            originalValueSaved = false;
        }
        super.setPropertyValue(propertyName, value);
        if (originalValueSaved) {
            try {
                Object newValue = this.getPropertyValue(propertyName);
                if (ObjectUtils.notEqual((Object)originalValue, (Object)newValue)) {
                    this.bindingResult.addModifiedPath(propertyName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean checkPropertyBindingAccess(String propertyName) {
        boolean isAccessible = false;
        Boolean bindingAnnotationAccess = this.checkBindingAnnotationsInPath(propertyName);
        if (bindingAnnotationAccess != null) {
            isAccessible = bindingAnnotationAccess;
        } else {
            ViewPostMetadata viewPostMetadata = ((ViewModel)this.getWrappedInstance()).getViewPostMetadata();
            if (viewPostMetadata != null && viewPostMetadata.getAccessibleBindingPaths() != null && !(isAccessible = viewPostMetadata.getAccessibleBindingPaths().contains(propertyName)) && propertyName.contains("[")) {
                String wildcardedPropertyName = propertyName.substring(0, propertyName.lastIndexOf("[")) + "[*" + propertyName.substring(propertyName.lastIndexOf("]"));
                isAccessible = viewPostMetadata.getAccessibleBindingPaths().contains(wildcardedPropertyName);
            }
        }
        if (!isAccessible) {
            LOG.debug("Request parameter sent for inaccessible binding path: " + propertyName);
            this.bindingResult.recordSuppressedField(propertyName);
        }
        return isAccessible;
    }

    protected Boolean checkBindingAnnotationsInPath(String propertyPath) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        while (!StringUtils.isEmpty((Object)propertyPath)) {
            RequestProtected protectedAnnotation;
            String nestedPath = ObjectPropertyUtils.getPathTail(propertyPath);
            String parentPropertyPath = ObjectPropertyUtils.removePathTail(propertyPath);
            Class<?> parentPropertyClass = this.getWrappedClass();
            if (!StringUtils.isEmpty((Object)parentPropertyPath)) {
                parentPropertyClass = ObjectPropertyUtils.getPropertyType(this.getWrappedInstance(), parentPropertyPath);
            }
            if (org.apache.commons.lang.StringUtils.endsWith((String)nestedPath, (String)"]")) {
                nestedPath = org.apache.commons.lang.StringUtils.substringBefore((String)nestedPath, (String)"[");
            }
            if ((protectedAnnotation = (RequestProtected)CopyUtils.getFieldAnnotation(parentPropertyClass, nestedPath, RequestProtected.class)) != null && this.annotationMatchesRequestMethod(protectedAnnotation.method(), request.getMethod())) {
                return Boolean.FALSE;
            }
            RequestAccessible accessibleAnnotation = (RequestAccessible)CopyUtils.getFieldAnnotation(parentPropertyClass, nestedPath, RequestAccessible.class);
            if (accessibleAnnotation != null) {
                boolean isAnnotationRequestMethod = this.annotationMatchesRequestMethod(accessibleAnnotation.method(), request.getMethod());
                boolean isAnnotationMethodToCalls = this.annotationMatchesMethodToCalls(accessibleAnnotation.methodToCalls(), request.getParameter("methodToCall"));
                if (isAnnotationRequestMethod && isAnnotationMethodToCalls) {
                    return Boolean.TRUE;
                }
            }
            propertyPath = parentPropertyPath;
        }
        return null;
    }

    protected boolean annotationMatchesMethodToCalls(String[] annotationMethodToCalls, String methodToCall) {
        if (annotationMethodToCalls == null || annotationMethodToCalls.length == 0) {
            return true;
        }
        for (String annotationMethodToCall : annotationMethodToCalls) {
            if (!org.apache.commons.lang.StringUtils.equals((String)annotationMethodToCall, (String)methodToCall)) continue;
            return true;
        }
        return false;
    }

    protected boolean annotationMatchesRequestMethod(RequestMethod[] annotationMethods, String requestMethod) {
        if (annotationMethods == null || annotationMethods.length == 0) {
            return true;
        }
        for (RequestMethod annotationMethod : annotationMethods) {
            if (!org.apache.commons.lang.StringUtils.equals((String)annotationMethod.name(), (String)requestMethod)) continue;
            return true;
        }
        return false;
    }

    protected Object processValueBeforeSet(String propertyName, Object value) {
        this.registerEditorFromView(propertyName);
        Object processedValue = value;
        if (value instanceof String) {
            String propertyValue = (String)value;
            processedValue = StringUtils.isEmpty((Object)propertyValue) ? null : this.decryptValueIfNecessary(propertyName, propertyValue);
        }
        return processedValue;
    }

    protected String decryptValueIfNecessary(String propertyName, String propertyValue) {
        boolean isSecure = this.isSecure(this.getWrappedClass(), propertyName);
        if (org.apache.commons.lang.StringUtils.endsWith((String)propertyValue, (String)"(&^#&)")) {
            propertyValue = org.apache.commons.lang.StringUtils.removeEnd((String)propertyValue, (String)"(&^#&)");
            isSecure = true;
        }
        if (isSecure) {
            try {
                if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                    propertyValue = CoreApiServiceLocator.getEncryptionService().decrypt(propertyValue);
                }
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return propertyValue;
    }

    protected boolean isSecure(Class<?> wrappedClass, String propertyPath) {
        BeanWrapperImpl beanWrapper;
        if (KRADUtils.isSecure(propertyPath, wrappedClass)) {
            return true;
        }
        this.setAutoGrowNestedPaths(true);
        try {
            beanWrapper = this.getPropertyAccessorForPropertyPath(propertyPath);
        }
        catch (NotReadablePropertyException | NullValueInNestedPathException e) {
            LOG.debug("Bean wrapper was not found for " + propertyPath + ", but since it cannot be accessed it will not be set as secure.", e);
            return false;
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)beanWrapper.getNestedPath())) {
            PropertyTokenHolder tokens = this.getPropertyNameTokens(propertyPath);
            String nestedPropertyPath = org.apache.commons.lang.StringUtils.removeStart((String)tokens.canonicalName, (String)beanWrapper.getNestedPath());
            return this.isSecure(beanWrapper.getWrappedClass(), nestedPropertyPath);
        }
        return false;
    }

    protected BeanWrapperImpl getPropertyAccessorForPropertyPath(String propertyPath) {
        BeanWrapperImpl beanWrapper = (BeanWrapperImpl)super.getPropertyAccessorForPropertyPath(propertyPath);
        PropertyTokenHolder tokens = this.getPropertyNameTokens(propertyPath);
        String canonicalName = tokens.canonicalName;
        int pos = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex((String)canonicalName);
        if (pos != -1) {
            canonicalName = canonicalName.substring(0, pos);
        }
        this.copyCustomEditorsTo((PropertyEditorRegistry)beanWrapper, canonicalName);
        return beanWrapper;
    }

    private PropertyTokenHolder getPropertyNameTokens(String propertyName) {
        PropertyTokenHolder tokens = new PropertyTokenHolder();
        String actualName = null;
        ArrayList<String> keys = new ArrayList<String>(2);
        int searchIndex = 0;
        while (searchIndex != -1) {
            String key;
            int keyEnd;
            int keyStart = propertyName.indexOf("[", searchIndex);
            searchIndex = -1;
            if (keyStart == -1 || (keyEnd = propertyName.indexOf("]", keyStart + "[".length())) == -1) continue;
            if (actualName == null) {
                actualName = propertyName.substring(0, keyStart);
            }
            if ((key = propertyName.substring(keyStart + "[".length(), keyEnd)).startsWith("'") && key.endsWith("'") || key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            keys.add(key);
            searchIndex = keyEnd + "]".length();
        }
        tokens.canonicalName = tokens.actualName = actualName != null ? actualName : propertyName;
        if (!keys.isEmpty()) {
            tokens.canonicalName = tokens.canonicalName + "[" + StringUtils.collectionToDelimitedString(keys, (String)"][") + "]";
            tokens.keys = StringUtils.toStringArray(keys);
        }
        return tokens;
    }

    private static class PropertyTokenHolder {
        public String canonicalName;
        public String actualName;
        public String[] keys;

        private PropertyTokenHolder() {
        }
    }
}

