/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.print;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.framework.print.ReportBean;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.customdata.InstitutionalProposalCustomData;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.web.ui.Column;

public class PendingReportBean
extends ReportBean {
    private String proposalNumber;
    private String sponsorName;
    private String roleCode;
    private String proposalTitle;
    private ScaleTwoDecimal totalDirectCostTotal;
    private ScaleTwoDecimal totalIndirectCostTotal;
    private Date requestedStartDateInitial;
    private Date requestedEndDateTotal;
    private ScaleTwoDecimal academicYearEffort;
    private ScaleTwoDecimal calendarYearEffort;
    private ScaleTwoDecimal summerEffort;
    private ScaleTwoDecimal totalEffort;
    private ParameterService parameterService;
    private List<InstitutionalProposalCustomData> institutionalProposalCustomDataList;

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public PendingReportBean(InstitutionalProposalPerson ipPerson) {
        InstitutionalProposal proposal = ipPerson.getInstitutionalProposal();
        this.proposalNumber = proposal.getProposalNumber();
        this.sponsorName = proposal.getSponsorName();
        this.roleCode = ipPerson.getRoleCode();
        this.proposalTitle = proposal.getTitle();
        this.totalDirectCostTotal = proposal.getTotalDirectCostTotal();
        this.totalIndirectCostTotal = proposal.getTotalIndirectCostTotal();
        this.requestedStartDateInitial = proposal.getRequestedStartDateInitial();
        this.requestedEndDateTotal = proposal.getRequestedEndDateTotal();
        this.academicYearEffort = ipPerson.getAcademicYearEffort();
        this.calendarYearEffort = ipPerson.getCalendarYearEffort();
        this.summerEffort = ipPerson.getSummerEffort();
        this.totalEffort = ipPerson.getTotalEffort();
        this.institutionalProposalCustomDataList = new ArrayList<InstitutionalProposalCustomData>();
        String customGroupName = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "CURRENT_PENDING_REPORT_GROUP_NAME");
        for (InstitutionalProposalCustomData custData : proposal.getInstitutionalProposalCustomDataList()) {
            if (custData.getCustomAttributeId() == null) continue;
            if (proposal.getInstitutionalProposalDocument().getCustomAttributeDocuments() != null) {
                custData.setCustomAttribute(proposal.getInstitutionalProposalDocument().getCustomAttributeDocument(custData.getCustomAttributeId().toString()).getCustomAttribute());
            }
            if (!customGroupName.equals(custData.getCustomAttribute().getGroupName())) continue;
            this.institutionalProposalCustomDataList.add(custData);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PendingReportBean)) {
            return false;
        }
        PendingReportBean that = (PendingReportBean)o;
        return this.proposalNumber.equals(that.proposalNumber);
    }

    public ScaleTwoDecimal getAcademicYearEffort() {
        return this.academicYearEffort;
    }

    public ScaleTwoDecimal getCalendarYearEffort() {
        return this.calendarYearEffort;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public String getProposalTitle() {
        return this.proposalTitle;
    }

    public Date getRequestedEndDateTotal() {
        return this.requestedEndDateTotal;
    }

    public Date getRequestedStartDateInitial() {
        return this.requestedStartDateInitial;
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public String getSponsorName() {
        return this.sponsorName;
    }

    public ScaleTwoDecimal getSummerEffort() {
        return this.summerEffort;
    }

    public ScaleTwoDecimal getTotalDirectCostTotal() {
        return this.totalDirectCostTotal;
    }

    public ScaleTwoDecimal getTotalEffort() {
        return this.totalEffort;
    }

    public ScaleTwoDecimal getTotalIndirectCostTotal() {
        return this.totalIndirectCostTotal;
    }

    public ScaleTwoDecimal getTotalRequestedCost() {
        return (ScaleTwoDecimal)this.totalDirectCostTotal.add((AbstractDecimal)this.totalIndirectCostTotal);
    }

    public int hashCode() {
        return this.proposalNumber.hashCode();
    }

    @Override
    protected List<Column> createColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(this.createColumn("Proposal Number", "proposalNumber", this.proposalNumber, String.class));
        columns.add(this.createColumn("Agency", "sponsorName", this.sponsorName, String.class));
        columns.add(this.createColumn("Role", "roleCode", this.roleCode, String.class));
        columns.add(this.createColumn("Title", "proposalTitle", this.proposalTitle, String.class));
        columns.add(this.createColumn("Total Direct Cost", "totalDirectCostTotal", this.totalDirectCostTotal, ScaleTwoDecimal.class));
        columns.add(this.createColumn("Total F&A Cost", "totalIndirectCostTotal", this.totalIndirectCostTotal, ScaleTwoDecimal.class));
        columns.add(this.createColumn("Total Requested Cost", "totalRequestedCost", this.getTotalRequestedCost(), ScaleTwoDecimal.class));
        columns.add(this.createColumn("Effective Date", "requestedStartDateInitial", this.requestedStartDateInitial, Date.class));
        columns.add(this.createColumn("End Date", "requestedEndDateTotal", this.requestedEndDateTotal, Date.class));
        columns.add(this.createColumn("% Effort", "totalEffort", this.totalEffort, ScaleTwoDecimal.class));
        columns.add(this.createColumn("Academic Year Effort %", "academicYearEffort", this.academicYearEffort, ScaleTwoDecimal.class));
        columns.add(this.createColumn("Summer Year Effort %", "summerYearEffort", this.summerEffort, ScaleTwoDecimal.class));
        columns.add(this.createColumn("Calendar Year Effort %", "calendarYearEffort", this.calendarYearEffort, ScaleTwoDecimal.class));
        if (this.institutionalProposalCustomDataList.size() > 0) {
            for (InstitutionalProposalCustomData institutionalProposalCustomData : this.institutionalProposalCustomDataList) {
                columns.add(this.createColumn(institutionalProposalCustomData.getCustomAttribute().getLabel(), "institutionalProposalCustomDataList", institutionalProposalCustomData.getValue(), String.class));
            }
        }
        return columns;
    }

    public void setInstitutionalProposalCustomDataList(List<InstitutionalProposalCustomData> institutionalProposalCustomDataList) {
        this.institutionalProposalCustomDataList = institutionalProposalCustomDataList;
    }

    public List<InstitutionalProposalCustomData> getInstitutionalProposalCustomDataList() {
        return this.institutionalProposalCustomDataList;
    }
}

