/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sourceforge.schemaspy.DbAnalyzer;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.util.HtmlEncoder;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.HtmlFormatter;

public class HtmlConstraintsPage
extends HtmlFormatter {
    private static HtmlConstraintsPage instance = new HtmlConstraintsPage();
    private int columnCounter;

    private HtmlConstraintsPage() {
    }

    public static HtmlConstraintsPage getInstance() {
        return instance;
    }

    public void write(Database database, List<ForeignKeyConstraint> list, Collection<Table> collection, LineWriter lineWriter) throws IOException {
        this.writeHeader(database, lineWriter);
        this.writeForeignKeyConstraints(list, lineWriter);
        this.writeCheckConstraints(collection, lineWriter);
        this.writeFooter(lineWriter);
    }

    private void writeHeader(Database database, LineWriter lineWriter) throws IOException {
        this.writeHeader(database, null, "Constraints", lineWriter);
        lineWriter.writeln("<div class='indent'>");
    }

    @Override
    protected void writeFooter(LineWriter lineWriter) throws IOException {
        lineWriter.writeln("</div>");
        super.writeFooter(lineWriter);
    }

    private void writeForeignKeyConstraints(List<ForeignKeyConstraint> list, LineWriter lineWriter) throws IOException {
        TreeSet<ForeignKeyConstraint> treeSet = new TreeSet<ForeignKeyConstraint>();
        treeSet.addAll(list);
        lineWriter.writeln("<table width='100%'>");
        lineWriter.writeln("<tr><td class='container' valign='bottom'><b>");
        lineWriter.write(String.valueOf(treeSet.size()));
        lineWriter.writeln(" Foreign Key Constraints:</b>");
        lineWriter.writeln("</td><td class='container' align='right'>");
        if (this.sourceForgeLogoEnabled()) {
            lineWriter.writeln("  <a href='http://sourceforge.net' target='_blank'><img src='http://sourceforge.net/sflogo.php?group_id=137197&amp;type=1' alt='SourceForge.net' border='0' height='31' width='88'></a>");
        }
        lineWriter.writeln("</td></tr>");
        lineWriter.writeln("</table><br>");
        lineWriter.writeln("<table class='dataTable' border='1' rules='groups'>");
        lineWriter.writeln("<colgroup>");
        lineWriter.writeln("<colgroup>");
        lineWriter.writeln("<colgroup>");
        lineWriter.writeln("<colgroup>");
        lineWriter.writeln("<thead align='left'>");
        lineWriter.writeln("<tr>");
        lineWriter.writeln("  <th>Constraint Name</th>");
        lineWriter.writeln("  <th>Child Column</th>");
        lineWriter.writeln("  <th>Parent Column</th>");
        lineWriter.writeln("  <th>Delete Rule</th>");
        lineWriter.writeln("</tr>");
        lineWriter.writeln("</thead>");
        lineWriter.writeln("<tbody>");
        for (ForeignKeyConstraint foreignKeyConstraint : treeSet) {
            this.writeForeignKeyConstraint(foreignKeyConstraint, lineWriter);
        }
        if (list.size() == 0) {
            lineWriter.writeln(" <tr>");
            lineWriter.writeln("  <td class='detail' valign='top' colspan='4'>None detected</td>");
            lineWriter.writeln(" </tr>");
        }
        lineWriter.writeln("</tbody>");
        lineWriter.writeln("</table>");
    }

    private void writeForeignKeyConstraint(ForeignKeyConstraint foreignKeyConstraint, LineWriter lineWriter) throws IOException {
        Object object;
        boolean bl;
        boolean bl2 = bl = this.columnCounter++ % 2 == 0;
        if (bl) {
            lineWriter.writeln("  <tr class='even'>");
        } else {
            lineWriter.writeln("  <tr class='odd'>");
        }
        lineWriter.write("  <td class='detail'>");
        lineWriter.write(foreignKeyConstraint.getName());
        lineWriter.writeln("</td>");
        lineWriter.write("  <td class='detail'>");
        Object object2 = foreignKeyConstraint.getChildColumns().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            lineWriter.write("<a href='tables/");
            lineWriter.write(HtmlConstraintsPage.urlEncode(((TableColumn)object).getTable().getName()));
            lineWriter.write(".html'>");
            lineWriter.write(((TableColumn)object).getTable().getName());
            lineWriter.write("</a>");
            lineWriter.write(".");
            lineWriter.write(((TableColumn)object).getName());
            if (!object2.hasNext()) continue;
            lineWriter.write("<br>");
        }
        lineWriter.writeln("</td>");
        lineWriter.write("  <td class='detail'>");
        object2 = foreignKeyConstraint.getParentColumns().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            lineWriter.write("<a href='tables/");
            lineWriter.write(HtmlConstraintsPage.urlEncode(((TableColumn)object).getTable().getName()));
            lineWriter.write(".html'>");
            lineWriter.write(((TableColumn)object).getTable().getName());
            lineWriter.write("</a>");
            lineWriter.write(".");
            lineWriter.write(((TableColumn)object).getName());
            if (!object2.hasNext()) continue;
            lineWriter.write("<br>");
        }
        lineWriter.writeln("</td>");
        lineWriter.write("  <td class='detail'>");
        object2 = foreignKeyConstraint.getDeleteRuleDescription();
        object = foreignKeyConstraint.getDeleteRuleName();
        lineWriter.write("<span title='" + (String)object2 + "'>" + (String)object + "&nbsp;</span>");
        lineWriter.writeln("</td>");
        lineWriter.writeln(" </tr>");
    }

    public void writeCheckConstraints(Collection<Table> collection, LineWriter lineWriter) throws IOException {
        lineWriter.writeln("<a name='checkConstraints'></a><p>");
        lineWriter.writeln("<b>Check Constraints:</b>");
        lineWriter.writeln("<TABLE class='dataTable' border='1' rules='groups'>");
        lineWriter.writeln("<colgroup>");
        lineWriter.writeln("<colgroup>");
        lineWriter.writeln("<colgroup>");
        lineWriter.writeln("<thead align='left'>");
        lineWriter.writeln("<tr>");
        lineWriter.writeln("  <th>Table</th>");
        lineWriter.writeln("  <th>Constraint Name</th>");
        lineWriter.writeln("  <th>Constraint</th>");
        lineWriter.writeln("</tr>");
        lineWriter.writeln("</thead>");
        lineWriter.writeln("<tbody>");
        List<Table> list = DbAnalyzer.sortTablesByName(new ArrayList<Table>(collection));
        int n = 0;
        for (Table table : list) {
            n += this.writeCheckConstraints(table, lineWriter);
        }
        if (n == 0) {
            lineWriter.writeln(" <tr>");
            lineWriter.writeln("  <td class='detail' valign='top' colspan='3'>None detected</td>");
            lineWriter.writeln(" </tr>");
        }
        lineWriter.writeln("</tbody>");
        lineWriter.writeln("</table>");
    }

    private int writeCheckConstraints(Table table, LineWriter lineWriter) throws IOException {
        Map<String, String> map = table.getCheckConstraints();
        int n = 0;
        for (String string : map.keySet()) {
            lineWriter.writeln(" <tr>");
            lineWriter.write("  <td class='detail' valign='top'><a href='tables/");
            lineWriter.write(HtmlConstraintsPage.urlEncode(table.getName()));
            lineWriter.write(".html'>");
            lineWriter.write(table.getName());
            lineWriter.write("</a></td>");
            lineWriter.write("  <td class='detail' valign='top'>");
            lineWriter.write(string);
            lineWriter.writeln("</td>");
            lineWriter.write("  <td class='detail'>");
            lineWriter.write(HtmlEncoder.encodeString(map.get(string).toString()));
            lineWriter.writeln("</td>");
            lineWriter.writeln(" </tr>");
            ++n;
        }
        return n;
    }

    @Override
    protected boolean isConstraintsPage() {
        return true;
    }
}

