/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.DataDictionaryPropertyUtils;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.datadictionary.ReferenceDefinition;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.maintenance.Maintainable;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentAuthorizer;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentAuthorizerBase;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentBase;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentPresentationControllerBase;

@BeanTag(name="maintenanceDocumentEntry", parent="uifMaintenanceDocumentEntry")
public class MaintenanceDocumentEntry
extends DocumentEntry {
    private static final long serialVersionUID = 4990040987835057251L;
    protected Class<?> dataObjectClass;
    protected Class<? extends Maintainable> maintainableClass;
    protected List<String> lockingKeys = new ArrayList<String>();
    protected List<String> clearValueOnCopyPropertyNames = new ArrayList<String>();
    protected boolean allowsNewOrCopy = true;
    protected boolean preserveLockingKeysOnCopy = false;
    protected boolean allowsRecordDeletion = false;

    public MaintenanceDocumentEntry() {
        this.setDocumentClass(this.getStandardDocumentBaseClass());
        this.documentAuthorizerClass = MaintenanceDocumentAuthorizerBase.class;
        this.documentPresentationControllerClass = MaintenanceDocumentPresentationControllerBase.class;
    }

    public Class<? extends Document> getStandardDocumentBaseClass() {
        return MaintenanceDocumentBase.class;
    }

    public void setDataObjectClass(Class<?> dataObjectClass) {
        this.dataObjectClass = dataObjectClass;
    }

    @BeanTagAttribute(name="dataObjectClass")
    public Class<?> getDataObjectClass() {
        return this.dataObjectClass;
    }

    @Override
    public Class getEntryClass() {
        return this.dataObjectClass;
    }

    public void setMaintainableClass(Class<? extends Maintainable> maintainableClass) {
        this.maintainableClass = maintainableClass;
    }

    @BeanTagAttribute(name="maintainableClass")
    public Class<? extends Maintainable> getMaintainableClass() {
        return this.maintainableClass;
    }

    public List<String> getLockingKeyFieldNames() {
        return this.lockingKeys;
    }

    @BeanTagAttribute(name="allowsNewOrCopy")
    public boolean getAllowsNewOrCopy() {
        return this.allowsNewOrCopy;
    }

    public void setAllowsNewOrCopy(boolean allowsNewOrCopy) {
        this.allowsNewOrCopy = allowsNewOrCopy;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        Object currentValues2;
        super.completeValidation(tracer);
        if (this.dataObjectClass == null) {
            currentValues2 = new String[]{};
            tracer.createError("invalid (null) dataObjectClass", (String[])currentValues2);
        }
        if (this.maintainableClass == null) {
            currentValues2 = new String[]{};
            tracer.createError("invalid (null) maintainableClass", (String[])currentValues2);
        }
        for (String lockingKey : this.lockingKeys) {
            if (StringUtils.isBlank((String)lockingKey)) {
                currentValues = new String[]{"lockingKeys = " + this.lockingKeys};
                tracer.createError("invalid (blank) lockingKey", currentValues);
                continue;
            }
            if (DataDictionaryPropertyUtils.isPropertyOf(this.dataObjectClass, lockingKey)) continue;
            currentValues = new String[]{"dataObjectClass = " + this.dataObjectClass, "lockingKey = " + lockingKey};
            tracer.createError("lockingKey not found in data object class", currentValues);
        }
        for (String clearValueOnCopyPropertyName : this.clearValueOnCopyPropertyNames) {
            if (StringUtils.isBlank((String)clearValueOnCopyPropertyName)) {
                currentValues = new String[]{"clearValueOnCopyPropertyNames = " + this.clearValueOnCopyPropertyNames};
                tracer.createError("invalid (blank) clearValueOnCopyPropertyNames", currentValues);
                continue;
            }
            if (DataDictionaryPropertyUtils.isPropertyOf(this.dataObjectClass, clearValueOnCopyPropertyName)) continue;
            currentValues = new String[]{"dataObjectClass = " + this.dataObjectClass, "clearValueOnCopyPropertyName = " + clearValueOnCopyPropertyName};
            tracer.createError("clearValueOnCopyPropertyName not found in data object class", currentValues);
        }
        if (this.documentAuthorizerClass != null && !MaintenanceDocumentAuthorizer.class.isAssignableFrom(this.documentAuthorizerClass)) {
            currentValues2 = new String[]{"documentAuthorizerClass = " + this.documentAuthorizerClass.getName()};
            tracer.createError("Maintenance Documents must use an implementation of MaintenanceDocumentAuthorizer", (String[])currentValues2);
        }
    }

    @Override
    protected void validateDefaultExistenceChecks(ValidationTrace tracer) {
        for (ReferenceDefinition refDef : this.defaultExistenceChecks) {
            refDef.completeValidation(this.dataObjectClass, null, tracer.getCopy());
        }
    }

    @BeanTagAttribute(name="lockingKeys", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getLockingKeys() {
        return this.lockingKeys;
    }

    public void setLockingKeys(List<String> lockingKeys) {
        this.lockingKeys = lockingKeys;
    }

    @BeanTagAttribute(name="preserveLockingKeysOnCopy")
    public boolean getPreserveLockingKeysOnCopy() {
        return this.preserveLockingKeysOnCopy;
    }

    public void setPreserveLockingKeysOnCopy(boolean preserveLockingKeysOnCopy) {
        this.preserveLockingKeysOnCopy = preserveLockingKeysOnCopy;
    }

    @BeanTagAttribute(name="clearValueOnCopyPropertyNames", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getClearValueOnCopyPropertyNames() {
        return this.clearValueOnCopyPropertyNames;
    }

    public void setClearValueOnCopyPropertyNames(List<String> clearValueOnCopyPropertyNames) {
        this.clearValueOnCopyPropertyNames = clearValueOnCopyPropertyNames;
    }

    @BeanTagAttribute(name="allowsRecordDeletion")
    public boolean getAllowsRecordDeletion() {
        return this.allowsRecordDeletion;
    }

    public void setAllowsRecordDeletion(boolean allowsRecordDeletion) {
        this.allowsRecordDeletion = allowsRecordDeletion;
    }
}

